/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.en;

import com.sun.speech.freetts.Utterance;
import com.sun.speech.freetts.UtteranceProcessor;
import com.sun.speech.freetts.cart.CARTImpl;
import com.sun.speech.freetts.cart.Intonator;
import com.sun.speech.freetts.en.us.CMUVoice;
import java.util.List;
import java.util.Locale;
import marytts.datatypes.MaryData;
import marytts.language.en_US.datatypes.USEnglishDataTypes;
import marytts.modules.InternalModule;
import marytts.modules.synthesis.FreeTTSVoices;

public class FreeTTSIntonator
extends InternalModule {
    private UtteranceProcessor processor;

    public FreeTTSIntonator() {
        super("Intonator", USEnglishDataTypes.FREETTS_PAUSES, USEnglishDataTypes.FREETTS_INTONATION, Locale.ENGLISH);
    }

    @Override
    public void startup() throws Exception {
        super.startup();
        FreeTTSVoices.load();
        CARTImpl accentCart = new CARTImpl(CMUVoice.class.getResource("int_accent_cart.txt"));
        CARTImpl toneCart = new CARTImpl(CMUVoice.class.getResource("int_tone_cart.txt"));
        this.processor = new Intonator(accentCart, toneCart);
    }

    @Override
    public MaryData process(MaryData d) throws Exception {
        List<Utterance> utterances = d.getUtterances();
        for (Utterance utterance : utterances) {
            this.processor.processUtterance(utterance);
        }
        MaryData output = new MaryData(this.outputType(), d.getLocale());
        output.setUtterances(utterances);
        return output;
    }
}

