/*
 * Decompiled with CFR 0.152.
 */
package marytts.htsengine;

import java.util.Arrays;
import marytts.htsengine.HMMData;

public class HTSModel {
    private String phoneName;
    private double durError;
    private int[] dur;
    private int totalDur = 0;
    private int totalDurMillisec;
    private double[][] lf0Mean;
    private double[][] lf0Variance;
    private double[][] mcepMean;
    private double[][] mcepVariance;
    private double[][] strMean;
    private double[][] strVariance;
    private double[][] magMean;
    private double[][] magVariance;
    private boolean[] voiced;
    private String maryXmlDur;
    private String maryXmlF0;
    private boolean gvSwitch;

    public void setPhoneName(String var) {
        this.phoneName = var;
    }

    public String getPhoneName() {
        return this.phoneName;
    }

    public void setDur(int i, int val) {
        this.dur[i] = val;
    }

    public int getDur(int i) {
        return this.dur[i];
    }

    public void setDurError(double e) {
        this.durError = e;
    }

    public double getDurError() {
        return this.durError;
    }

    public void setTotalDur(int val) {
        this.totalDur = val;
    }

    public int getTotalDur() {
        return this.totalDur;
    }

    public void incrTotalDur(int val) {
        this.totalDur += val;
    }

    public void setTotalDurMillisec(int val) {
        this.totalDurMillisec = val;
    }

    public int getTotalDurMillisec() {
        return this.totalDurMillisec;
    }

    public void setLf0Mean(int i, int j, double val) {
        this.lf0Mean[i][j] = val;
    }

    public double getLf0Mean(int i, int j) {
        return this.lf0Mean[i][j];
    }

    public void setLf0Variance(int i, int j, double val) {
        this.lf0Variance[i][j] = val;
    }

    public double getLf0Variance(int i, int j) {
        return this.lf0Variance[i][j];
    }

    public void setLf0Mean(int i, double[] val) {
        this.lf0Mean[i] = val;
    }

    public void setLf0Variance(int i, double[] val) {
        this.lf0Variance[i] = val;
    }

    public void setMcepMean(int i, int j, double val) {
        this.mcepMean[i][j] = val;
    }

    public double getMcepMean(int i, int j) {
        return this.mcepMean[i][j];
    }

    public void setMcepVariance(int i, int j, double val) {
        this.mcepVariance[i][j] = val;
    }

    public double getMcepVariance(int i, int j) {
        return this.mcepVariance[i][j];
    }

    public void setMcepMean(int i, double[] val) {
        this.mcepMean[i] = val;
    }

    public void setMcepVariance(int i, double[] val) {
        this.mcepVariance[i] = val;
    }

    public double[] getMean(HMMData.FeatureType type, int i) {
        switch (type) {
            case MGC: {
                return Arrays.copyOf(this.mcepMean[i], this.mcepMean[i].length);
            }
            case STR: {
                return Arrays.copyOf(this.strMean[i], this.strMean[i].length);
            }
            case MAG: {
                return Arrays.copyOf(this.magMean[i], this.magMean[i].length);
            }
            case LF0: {
                return Arrays.copyOf(this.lf0Mean[i], this.lf0Mean[i].length);
            }
        }
        throw new RuntimeException("You must not ask me about DUR");
    }

    public double[] getVariance(HMMData.FeatureType type, int i) {
        switch (type) {
            case MGC: {
                return Arrays.copyOf(this.mcepVariance[i], this.mcepVariance[i].length);
            }
            case STR: {
                return Arrays.copyOf(this.strVariance[i], this.strVariance[i].length);
            }
            case MAG: {
                return Arrays.copyOf(this.magVariance[i], this.magVariance[i].length);
            }
            case LF0: {
                return Arrays.copyOf(this.lf0Variance[i], this.lf0Variance[i].length);
            }
        }
        throw new RuntimeException("You must not ask me about DUR");
    }

    public void printMcepMean() {
        this.printVectors(this.mcepMean, this.mcepVariance);
    }

    public void printLf0Mean() {
        this.printVectors(this.lf0Mean, this.lf0Variance);
    }

    public void printVectors(double[][] m, double[][] v) {
        for (int i = 0; i < v.length; ++i) {
            int j;
            System.out.print("  mean[" + i + "]: ");
            for (j = 0; j < m[i].length; ++j) {
                System.out.format("%.6f ", m[i][j]);
            }
            System.out.print("\n  vari[" + i + "]: ");
            for (j = 0; j < v[i].length; ++j) {
                System.out.format("%.6f ", v[i][j]);
            }
            System.out.println();
        }
    }

    public void printDuration(int numStates) {
        System.out.print("phoneName: " + this.phoneName + "\t");
        for (int i = 0; i < numStates; ++i) {
            System.out.print("dur[" + i + "]=" + this.dur[i] + " ");
        }
        System.out.println("  totalDur=" + this.totalDur + "  totalDurMillisec=" + this.totalDurMillisec);
    }

    public void setStrMean(int i, int j, double val) {
        this.strMean[i][j] = val;
    }

    public double getStrMean(int i, int j) {
        return this.strMean[i][j];
    }

    public void setStrVariance(int i, int j, double val) {
        this.strVariance[i][j] = val;
    }

    public double getStrVariance(int i, int j) {
        return this.strVariance[i][j];
    }

    public void setStrMean(int i, double[] val) {
        this.strMean[i] = val;
    }

    public void setStrVariance(int i, double[] val) {
        this.strVariance[i] = val;
    }

    public void setMagMean(int i, int j, double val) {
        this.magMean[i][j] = val;
    }

    public double getMagMean(int i, int j) {
        return this.magMean[i][j];
    }

    public void setMagVariance(int i, int j, double val) {
        this.magVariance[i][j] = val;
    }

    public double getMagVariance(int i, int j) {
        return this.magVariance[i][j];
    }

    public void setMagMean(int i, double[] val) {
        this.magMean[i] = val;
    }

    public void setMagVariance(int i, double[] val) {
        this.magVariance[i] = val;
    }

    public void setVoiced(int i, boolean val) {
        this.voiced[i] = val;
    }

    public boolean getVoiced(int i) {
        return this.voiced[i];
    }

    public int getNumVoiced() {
        int numVoiced = 0;
        for (int i = 0; i < this.voiced.length; ++i) {
            if (!this.getVoiced(i)) continue;
            numVoiced += this.getDur(i);
        }
        return numVoiced;
    }

    public void setMaryXmlDur(String str) {
        this.maryXmlDur = str;
    }

    public String getMaryXmlDur() {
        return this.maryXmlDur;
    }

    public void setMaryXmlF0(String str) {
        this.maryXmlF0 = str;
    }

    public String getMaryXmlF0() {
        return this.maryXmlF0;
    }

    public void setGvSwitch(boolean bv) {
        this.gvSwitch = bv;
    }

    public boolean getGvSwitch() {
        return this.gvSwitch;
    }

    public HTSModel(int nstate) {
        this.dur = new int[nstate];
        this.lf0Mean = new double[nstate][];
        this.lf0Variance = new double[nstate][];
        this.voiced = new boolean[nstate];
        this.mcepMean = new double[nstate][];
        this.mcepVariance = new double[nstate][];
        this.strMean = new double[nstate][];
        this.strVariance = new double[nstate][];
        this.magMean = new double[nstate][];
        this.magVariance = new double[nstate][];
        this.maryXmlDur = null;
        this.maryXmlF0 = null;
        this.gvSwitch = true;
    }

    public String toString() {
        return this.getPhoneName();
    }
}

