/*
 * Decompiled with CFR 0.152.
 */
package marytts.fst;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Trie<Symbol> {
    protected TrieNode root;
    protected List<TrieNode> finalNodes;
    protected Map<TrieNode, Integer> reprs = null;
    protected List<TrieNode> rlist = null;
    protected Map<Symbol, Integer> label2id = new HashMap<Symbol, Integer>();
    protected List<Symbol> labels = new ArrayList<Symbol>();

    public Trie() {
        this.root = new TrieNode(null, this.label2id, this.labels);
        this.finalNodes = new ArrayList<TrieNode>();
    }

    public void add(Symbol[] entry) {
        this.finalNodes.add(this.root.add(entry, 0));
    }

    public void computeMinimization() {
        LinkedList<TrieNode> identityCandidates = new LinkedList<TrieNode>();
        for (TrieNode fn : this.finalNodes) {
            if (fn.hasSuccessor()) continue;
            identityCandidates.add(fn);
        }
        this.rlist = new ArrayList<TrieNode>();
        this.reprs = new HashMap<TrieNode, Integer>();
        while (!identityCandidates.isEmpty()) {
            TrieNode pred;
            TrieNode currCan = (TrieNode)identityCandidates.remove();
            if (this.reprs.containsKey(currCan)) {
                currCan.setId(this.reprs.get(currCan));
            }
            if (!currCan.hasId()) {
                currCan.setId(this.reprs.size());
                this.reprs.put(currCan, currCan.getId());
                this.rlist.add(currCan);
            }
            if (null == (pred = currCan.getBackPointer()) || pred.hasId() || !pred.rightIdentified()) continue;
            identityCandidates.add(pred);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (TrieNode r : this.reprs.keySet()) {
            sb.append("\n");
            sb.append(r.toString());
        }
        return sb.toString();
    }

    class TrieNode {
        private boolean hashcodeFixed = false;
        int hashcode = -1;
        private Map<Integer, TrieNode> labelId2node = new HashMap<Integer, TrieNode>();
        protected boolean isFinal = false;
        private int id = -1;
        private TrieNode backPointer = null;

        public TrieNode(TrieNode predecessor, Map<Symbol, Integer> label2idMap, List<Symbol> labels) {
            this.backPointer = predecessor;
        }

        protected TrieNode add(Symbol[] entry, int index) {
            TrieNode successor;
            if (index == entry.length) {
                this.isFinal = true;
                return this;
            }
            Integer labelId = Trie.this.label2id.get(entry[index]);
            if (null == labelId) {
                labelId = Trie.this.labels.size();
                Trie.this.labels.add(entry[index]);
                Trie.this.label2id.put(entry[index], labelId);
            }
            if (null == (successor = this.labelId2node.get(labelId))) {
                successor = new TrieNode(this, Trie.this.label2id, Trie.this.labels);
                this.labelId2node.put(labelId, successor);
            }
            return successor.add(entry, index + 1);
        }

        protected boolean hasSuccessor() {
            return this.labelId2node.size() > 0;
        }

        public int hashCode() {
            if (this.hashcodeFixed) {
                return this.hashcode;
            }
            int hc = this.isFinal ? 1 : 0;
            for (Integer labelId : this.labelId2node.keySet()) {
                hc += labelId ^ this.labelId2node.get((Object)labelId).id;
            }
            return hc;
        }

        public boolean equals(Object other) {
            TrieNode otherNode;
            try {
                otherNode = (TrieNode)other;
            }
            catch (ClassCastException e) {
                return false;
            }
            if (this.isFinal != otherNode.isFinal) {
                return false;
            }
            if (!this.labelId2node.keySet().equals(otherNode.labelId2node.keySet())) {
                return false;
            }
            for (Integer labelId : this.labelId2node.keySet()) {
                if (this.labelId2node.get((Object)labelId).id == otherNode.labelId2node.get((Object)labelId).id) continue;
                return false;
            }
            return true;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id2) {
            this.id = id2;
            this.hashcode = this.hashCode();
            this.hashcodeFixed = true;
        }

        public boolean hasId() {
            return this.id != -1;
        }

        public TrieNode getBackPointer() {
            return this.backPointer;
        }

        public boolean rightIdentified() {
            for (TrieNode n : this.labelId2node.values()) {
                if (n.hasId()) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.backPointer == null) {
                sb.append(">");
            }
            if (this.isFinal) {
                sb.append("((" + this.id + "))");
            } else {
                sb.append("(" + this.id + ")");
            }
            for (Integer lId : this.labelId2node.keySet()) {
                String l = Trie.this.labels.get(lId).toString();
                sb.append("\n");
                sb.append("|-" + l);
                sb.append(" (" + this.labelId2node.get((Object)lId).id + ")");
            }
            return sb.toString();
        }

        public Map<Integer, TrieNode> getArcMap() {
            return this.labelId2node;
        }
    }
}

