/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.lt.tools.tokenizer.output;

public class Token {
    private static final String LRB = "-LRB-";
    private static final String RRB = "-RRB-";
    private static final String LSB = "-LSB-";
    private static final String RSB = "-RSB-";
    private static final String LCB = "-LCB-";
    private static final String RCB = "-RCB-";
    private int startIndex;
    private int endIndex;
    private String type;
    private String image;

    public Token() {
        this.setStartIndex(0);
        this.setEndIndex(0);
        this.setType(new String());
        this.setImage(new String());
    }

    public Token(int aStartIndex, int anEndIndex, String aType, String anImage) {
        this.setStartIndex(aStartIndex);
        this.setEndIndex(anEndIndex);
        this.setType(aType);
        this.setImage(anImage);
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int aStartIndex) {
        this.startIndex = aStartIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public void setEndIndex(int anEndIndex) {
        this.endIndex = anEndIndex;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String aType) {
        this.type = aType;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String anImage) {
        this.image = anImage;
    }

    public String getPtbImage() {
        return Token.applyPtbFormat(this.image, this.type);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        String newline = System.getProperty("line.separator");
        result.append("    Token: ").append(Token.filledStringLeft(this.getImage(), 15)).append("\tType: ").append(this.getType()).append("\tStart: ").append(this.getStartIndex()).append("\tEnd: ").append(this.getEndIndex());
        String ptbImage = Token.applyPtbFormat(this.image, this.type);
        if (null != ptbImage) {
            result.append("\tPTB: \"").append(ptbImage).append("\"");
        }
        result.append(newline);
        return result.toString();
    }

    private static String filledStringLeft(String aString, int aLength) {
        StringBuffer result = new StringBuffer("\"");
        result.append(aString).append("\"");
        while (result.length() < aLength) {
            result.append(" ".intern());
        }
        return result.toString();
    }

    public static String applyPtbFormat(String image, String type) {
        String result = null;
        if (type.equals("OPEN_BRACKET")) {
            if (image.equals("(")) {
                result = LRB;
            } else if (image.equals("[")) {
                result = LSB;
            } else if (image.equals("{")) {
                result = LCB;
            }
        } else if (type.equals("CLOSE_BRACKET")) {
            if (image.equals(")")) {
                result = RRB;
            } else if (image.equals("]")) {
                result = RSB;
            } else if (image.equals("}")) {
                result = RCB;
            }
        } else if (type.equals("OPEN_PUNCT")) {
            result = "``";
        } else if (type.equals("CLOSE_PUNCT")) {
            result = "''";
        } else if (image.contains("/")) {
            result = image.replace("/", "\\/");
        } else if (image.contains("*")) {
            result = image.replace("*", "\\*");
        }
        return result;
    }
}

