/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.lt.tools.tokenizer.output;

import de.dfki.lt.tools.tokenizer.output.TextUnit;
import java.util.ArrayList;
import java.util.List;

public class Paragraph {
    private int startIndex;
    private int endIndex;
    private List<TextUnit> textUnits;

    public Paragraph() {
        this.setStartIndex(0);
        this.setEndIndex(0);
        this.setTextUnits(new ArrayList<TextUnit>());
    }

    public Paragraph(List<TextUnit> someTextUnits) {
        this.setTextUnits(someTextUnits);
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int aStartIndex) {
        this.startIndex = aStartIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public void setEndIndex(int anEndIndex) {
        this.endIndex = anEndIndex;
    }

    public List<TextUnit> getTextUnits() {
        return this.textUnits;
    }

    public void setTextUnits(List<TextUnit> someTextUnits) {
        this.textUnits = someTextUnits;
        if (someTextUnits.size() > 0) {
            this.setStartIndex(someTextUnits.get(0).getStartIndex());
            this.setEndIndex(someTextUnits.get(someTextUnits.size() - 1).getEndIndex());
        } else {
            this.setStartIndex(0);
            this.setEndIndex(0);
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        String newline = System.getProperty("line.separator");
        result.append("Paragraph Start: ").append(this.getStartIndex()).append(newline).append("Paragraph End: ").append(this.getEndIndex()).append(newline);
        for (TextUnit oneTU : this.getTextUnits()) {
            result.append(oneTU.toString());
        }
        return result.toString();
    }
}

