/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.lt.tools.tokenizer;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;

public class FileTools {
    private FileTools() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveStream(InputStream inputStream, File file) throws IOException {
        byte[] ab = new byte[4096];
        FileOutputStream fos = null;
        try {
            int i;
            fos = new FileOutputStream(file);
            while ((i = inputStream.read(ab)) > 0) {
                fos.write(ab, 0, i);
            }
        }
        finally {
            if (null != fos) {
                fos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readUrlToString(URL url) throws IOException {
        URLConnection con = url.openConnection();
        con.connect();
        InputStream is = null;
        ByteArrayOutputStream bos = null;
        int len = con.getContentLength();
        if (-1 == len) {
            len = 10000;
        }
        try {
            bos = new ByteArrayOutputStream(len);
            is = con.getInputStream();
            FileTools.readInputStream(bos, is);
        }
        finally {
            if (null != is) {
                is.close();
            }
            if (null != bos) {
                bos.close();
            }
        }
        return bos.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readUrlToByteArray(URL url) throws IOException {
        URLConnection con = url.openConnection();
        con.connect();
        InputStream is = null;
        ByteArrayOutputStream bos = null;
        int len = con.getContentLength();
        if (-1 == len) {
            len = 10000;
        }
        try {
            bos = new ByteArrayOutputStream(len);
            is = con.getInputStream();
            FileTools.readInputStream(bos, is);
        }
        finally {
            if (null != is) {
                is.close();
            }
            if (null != bos) {
                bos.close();
            }
        }
        return bos.toByteArray();
    }

    public static void readInputStream(OutputStream os, InputStream is) throws IOException {
        int readb;
        byte[] buffer = new byte[4096];
        while ((readb = is.read(buffer)) != -1) {
            os.write(buffer, 0, readb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readInputStream(InputStream is) throws IOException {
        ByteArrayOutputStream bos = null;
        try {
            bos = new ByteArrayOutputStream();
            FileTools.readInputStream(bos, is);
        }
        finally {
            if (null != bos) {
                bos.close();
            }
        }
        return bos.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readInputStreamToByteArray(InputStream is) throws IOException {
        ByteArrayOutputStream bos = null;
        try {
            bos = new ByteArrayOutputStream();
            FileTools.readInputStream(bos, is);
        }
        finally {
            if (null != bos) {
                bos.close();
            }
        }
        return bos.toByteArray();
    }

    public static List getFilesFromDir(String aDirectory, String aSuffix) {
        File directory;
        ArrayList<String> fileNames = new ArrayList<String>();
        if (!aDirectory.endsWith(File.separator)) {
            aDirectory = aDirectory + File.separator;
        }
        if (!(directory = new File(aDirectory)).isDirectory()) {
            return fileNames;
        }
        File[] filesInDir = directory.listFiles();
        for (int i = 0; i < filesInDir.length; ++i) {
            if (filesInDir[i].isDirectory()) {
                fileNames.addAll(FileTools.getFilesFromDir(filesInDir[i].getAbsolutePath(), aSuffix));
                continue;
            }
            if (!filesInDir[i].getName().endsWith(aSuffix)) continue;
            fileNames.add(filesInDir[i].getAbsolutePath());
        }
        return fileNames;
    }

    public static void copyFile(File source, File target) throws IOException {
        FileInputStream fis = new FileInputStream(source);
        FileOutputStream fos = new FileOutputStream(target);
        byte[] buf = new byte[1024];
        int i = 0;
        while ((i = fis.read(buf)) != -1) {
            fos.write(buf, 0, i);
        }
        fis.close();
        fos.close();
    }

    public static ByteBuffer readFile(File aFile) throws FileNotFoundException, IOException {
        FileInputStream fis = new FileInputStream(aFile);
        FileChannel fc = fis.getChannel();
        ByteBuffer readBuffer = ByteBuffer.allocate((int)fc.size());
        fc.read(readBuffer);
        fis.close();
        readBuffer.rewind();
        return readBuffer;
    }

    public static String readFileAsString(File aFile, String aCharSet) throws FileNotFoundException, IOException, UnsupportedCharsetException {
        ByteBuffer buffer = FileTools.readFile(aFile);
        if (null == aCharSet) {
            aCharSet = "ISO-8859-15";
        }
        String converted = new String(buffer.array(), aCharSet);
        return converted;
    }

    public static InputStream openResourceFileAsStream(String resourceFileName) throws FileNotFoundException {
        InputStream is = ClassLoader.getSystemResourceAsStream(resourceFileName);
        if (null == is && null == (is = FileTools.class.getResourceAsStream("/" + resourceFileName)) && null == (is = FileTools.class.getResourceAsStream(resourceFileName))) {
            is = new FileInputStream(resourceFileName);
        }
        return is;
    }
}

