/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.lt.mary.modules.clunits;

import com.sun.speech.freetts.relp.SampleInfo;
import de.dfki.lt.mary.modules.clunits.Sample;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.StringTokenizer;

public class SampleSet {
    private Sample[] samples;
    private SampleInfo sampleInfo;

    public SampleSet() {
    }

    public SampleSet(StringTokenizer tok, BufferedReader reader) {
        try {
            int numSamples = Integer.parseInt(tok.nextToken());
            int numChannels = Integer.parseInt(tok.nextToken());
            int sampleRate = Integer.parseInt(tok.nextToken());
            float coeffMin = Float.parseFloat(tok.nextToken());
            float coeffRange = Float.parseFloat(tok.nextToken());
            float postEmphasis = Float.parseFloat(tok.nextToken());
            int residualFold = Integer.parseInt(tok.nextToken());
            this.samples = new Sample[numSamples];
            this.sampleInfo = new SampleInfo(sampleRate, numChannels, residualFold, coeffMin, coeffRange, postEmphasis);
            for (int i = 0; i < numSamples; ++i) {
                this.samples[i] = new Sample(reader, numChannels);
            }
        }
        catch (Exception nse) {
            throw new Error("Parsing sample error " + nse.getMessage());
        }
    }

    public SampleSet(ByteBuffer bb) throws IOException {
        this.sampleInfo = new SampleInfo(bb);
        int numSamples = bb.getInt();
        this.samples = new Sample[numSamples];
        for (int i = 0; i < numSamples; ++i) {
            this.samples[i] = Sample.loadBinary(bb);
        }
    }

    public SampleSet(DataInputStream is, boolean newVersion) throws IOException {
        this.sampleInfo = new SampleInfo(is);
        int numSamples = is.readInt();
        this.samples = new Sample[numSamples];
        if (newVersion) {
            int frameSize = is.readInt();
            int residualSize = is.readInt();
            for (int i = 0; i < numSamples; ++i) {
                this.samples[i] = Sample.loadBinary(is, residualSize, frameSize);
            }
        } else {
            for (int i = 0; i < numSamples; ++i) {
                this.samples[i] = Sample.loadBinary(is);
            }
        }
    }

    public void dumpBinary_new(DataOutputStream os) throws IOException {
        int i;
        this.sampleInfo.dumpBinary(os);
        int samplesLength = this.samples.length;
        os.writeInt(samplesLength);
        int residualSize = 0;
        int frameSize = 0;
        for (i = 0; i < samplesLength; ++i) {
            if (this.samples[i].getResidualSize() > residualSize) {
                residualSize = this.samples[i].getResidualSize();
            }
            if (this.samples[i].getFrameSize() <= frameSize) continue;
            frameSize = this.samples[i].getFrameSize();
        }
        os.writeInt(frameSize);
        os.writeInt(residualSize);
        for (i = 0; i < samplesLength; ++i) {
            this.samples[i].dumpBinary(os, residualSize, frameSize);
        }
    }

    public void dumpBinary(DataOutputStream os) throws IOException {
        this.sampleInfo.dumpBinary(os);
        os.writeInt(this.samples.length);
        for (int i = 0; i < this.samples.length; ++i) {
            this.samples[i].dumpBinary(os);
        }
    }

    public Sample getSample(int index) {
        return this.samples[index];
    }

    public SampleInfo getSampleInfo() {
        return this.sampleInfo;
    }

    public int getUnitSize(int start, int end) {
        int size = 0;
        for (int i = start; i < end; ++i) {
            size += this.getFrameSize(i);
        }
        return size;
    }

    public int getFrameSize(int frame) {
        return this.samples[frame].getResidualSize();
    }
}

