/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.diphone;

import com.sun.speech.freetts.FeatureSet;
import com.sun.speech.freetts.Item;
import com.sun.speech.freetts.ProcessException;
import com.sun.speech.freetts.Relation;
import com.sun.speech.freetts.Utterance;
import com.sun.speech.freetts.UtteranceProcessor;
import com.sun.speech.freetts.diphone.IntLinkedList;
import com.sun.speech.freetts.relp.LPCResult;
import com.sun.speech.freetts.relp.SampleInfo;

public class DiphonePitchmarkGenerator
implements UtteranceProcessor {
    public void processUtterance(Utterance utterance) throws ProcessException {
        Relation targetRelation = utterance.getRelation("Target");
        if (targetRelation == null) {
            throw new IllegalStateException("DiphonePitchmarkGenerator: Target relation does not exist");
        }
        SampleInfo sampleInfo = (SampleInfo)utterance.getObject("SampleInfo");
        if (sampleInfo == null) {
            throw new IllegalStateException("DiphonePitchmarkGenerator: SampleInfo does not exist");
        }
        float lpos = 0.0f;
        float m = 0.0f;
        float lf0 = utterance.getVoice().getPitch();
        double time = 0.0;
        int pitchMarks = 0;
        IntLinkedList timesList = new IntLinkedList();
        for (Item targetItem = targetRelation.getHead(); targetItem != null; targetItem = targetItem.getNext()) {
            FeatureSet featureSet = targetItem.getFeatures();
            float pos = featureSet.getFloat("pos");
            float f0 = featureSet.getFloat("f0");
            if (time == (double)pos) {
                lf0 = f0;
                continue;
            }
            m = (f0 - lf0) / pos;
            while (time < (double)pos) {
                time += 1.0 / ((double)lf0 + time * (double)m);
                timesList.add((int)(time * (double)sampleInfo.getSampleRate()));
                ++pitchMarks;
            }
            lf0 = f0;
        }
        LPCResult lpcResult = new LPCResult();
        lpcResult.resizeFrames(pitchMarks);
        int[] targetTimes = lpcResult.getTimes();
        timesList.resetIterator();
        for (pitchMarks = 0; pitchMarks < targetTimes.length; ++pitchMarks) {
            targetTimes[pitchMarks] = timesList.nextInt();
        }
        utterance.setObject("target_lpcres", lpcResult);
    }

    public String toString() {
        return "DiphonePitchmarkGenerator";
    }
}

