/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.io;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class LEDataInputStream
implements DataInput {
    private static final String EMBEDDEDCOPYRIGHT = "copyright (c) 1999-2007 Roedy Green, Canadian Mind Products, http://mindprod.com";
    protected final DataInputStream dis;
    protected final InputStream is;
    protected final byte[] work;

    public static String readUTF(DataInput in) throws IOException {
        return DataInputStream.readUTF(in);
    }

    public LEDataInputStream(InputStream in) {
        this.is = in;
        this.dis = new DataInputStream(in);
        this.work = new byte[8];
    }

    public LEDataInputStream(String filename) throws FileNotFoundException {
        this(new FileInputStream(filename));
    }

    public final void close() throws IOException {
        this.dis.close();
    }

    public final int read(byte[] ba, int off, int len) throws IOException {
        return this.is.read(ba, off, len);
    }

    @Override
    public final boolean readBoolean() throws IOException {
        return this.dis.readBoolean();
    }

    public final boolean[] readBoolean(int len) throws IOException {
        boolean[] ret = new boolean[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = this.readBoolean();
        }
        return ret;
    }

    @Override
    public final byte readByte() throws IOException {
        return this.dis.readByte();
    }

    public final byte[] readByte(int len) throws IOException {
        byte[] ret = new byte[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = this.readByte();
        }
        return ret;
    }

    @Override
    public final char readChar() throws IOException {
        this.dis.readFully(this.work, 0, 2);
        return (char)((this.work[1] & 0xFF) << 8 | this.work[0] & 0xFF);
    }

    public final char[] readChar(int len) throws IOException {
        char[] ret = new char[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = this.readChar();
        }
        return ret;
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final double[] readDouble(int len) throws IOException {
        double[] ret = new double[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = this.readDouble();
        }
        return ret;
    }

    public final int[] readDoubleToInt(int len) throws IOException {
        int[] ret = new int[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = (int)this.readDouble();
        }
        return ret;
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final float[] readFloat(int len) throws IOException {
        float[] ret = new float[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = this.readFloat();
        }
        return ret;
    }

    @Override
    public final void readFully(byte[] ba) throws IOException {
        this.dis.readFully(ba, 0, ba.length);
    }

    @Override
    public final void readFully(byte[] ba, int off, int len) throws IOException {
        this.dis.readFully(ba, off, len);
    }

    @Override
    public final int readInt() throws IOException {
        this.dis.readFully(this.work, 0, 4);
        return this.work[3] << 24 | (this.work[2] & 0xFF) << 16 | (this.work[1] & 0xFF) << 8 | this.work[0] & 0xFF;
    }

    public final int[] readInt(int len) throws IOException {
        int[] ret = new int[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = this.readInt();
        }
        return ret;
    }

    @Override
    public final String readLine() throws IOException {
        return this.dis.readLine();
    }

    @Override
    public final long readLong() throws IOException {
        this.dis.readFully(this.work, 0, 8);
        return (long)this.work[7] << 56 | (long)(this.work[6] & 0xFF) << 48 | (long)(this.work[5] & 0xFF) << 40 | (long)(this.work[4] & 0xFF) << 32 | (long)(this.work[3] & 0xFF) << 24 | (long)(this.work[2] & 0xFF) << 16 | (long)(this.work[1] & 0xFF) << 8 | (long)(this.work[0] & 0xFF);
    }

    public final long[] readLong(int len) throws IOException {
        long[] ret = new long[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = this.readLong();
        }
        return ret;
    }

    @Override
    public final short readShort() throws IOException {
        this.dis.readFully(this.work, 0, 2);
        return (short)((this.work[1] & 0xFF) << 8 | this.work[0] & 0xFF);
    }

    public final short[] readShort(int len) throws IOException {
        short[] ret = new short[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = this.readShort();
        }
        return ret;
    }

    @Override
    public final String readUTF() throws IOException {
        return this.dis.readUTF();
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        return this.dis.readUnsignedByte();
    }

    public final int[] readUnsignedByte(int len) throws IOException {
        int[] ret = new int[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = this.readUnsignedByte();
        }
        return ret;
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        this.dis.readFully(this.work, 0, 2);
        return (this.work[1] & 0xFF) << 8 | this.work[0] & 0xFF;
    }

    public final int[] readUnsignedShort(int len) throws IOException {
        int[] ret = new int[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = this.readUnsignedShort();
        }
        return ret;
    }

    @Override
    public final int skipBytes(int n) throws IOException {
        return this.dis.skipBytes(n);
    }
}

