/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.data.text;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.StringTokenizer;
import marytts.util.data.text.TextReaderDoubleDataSource;

public class LabelfileDoubleDataSource
extends TextReaderDoubleDataSource {
    public LabelfileDoubleDataSource(File file) throws FileNotFoundException {
        this(new FileReader(file));
    }

    public LabelfileDoubleDataSource(Reader reader) {
        super(reader);
        try {
            while (!this.reader.readLine().trim().equals("#")) {
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    @Override
    public int getData(double[] target, int targetPos, int length) {
        for (int i = 0; i < length; ++i) {
            try {
                double value;
                String line = this.reader.readLine();
                if (line == null) {
                    return i;
                }
                String token = new StringTokenizer(line.trim()).nextToken();
                target[targetPos + i] = value = Double.parseDouble(token);
                continue;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return i;
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
                return i;
            }
        }
        return length;
    }
}

