/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.data;

import java.io.DataOutput;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;

public class Datagram {
    public static final int NUM_HEADER_BYTES = 12;
    protected long duration = 0L;
    protected byte[] data = null;

    protected Datagram(long duration) {
        if (duration < 0L) {
            throw new IllegalArgumentException("Can't create a datagram with the negative duration [" + duration + "].");
        }
        this.duration = duration;
    }

    public Datagram(long setDuration, byte[] setData) {
        if (setDuration < 0L) {
            throw new IllegalArgumentException("Can't create a datagram with the negative duration [" + setDuration + "].");
        }
        if (setData == null) {
            throw new NullPointerException("null argument");
        }
        this.duration = setDuration;
        this.data = setData;
    }

    public Datagram(RandomAccessFile raf) throws IOException {
        this.duration = raf.readLong();
        if (this.duration < 0L) {
            throw new IOException("Can't create a datagram with a negative duration [" + this.duration + "].");
        }
        int len = raf.readInt();
        if (len < 0) {
            throw new IOException("Can't create a datagram with a negative data size [" + len + "].");
        }
        this.data = new byte[len];
        raf.readFully(this.data);
    }

    public Datagram(ByteBuffer bb) throws IOException {
        this(bb, true);
    }

    public Datagram(ByteBuffer bb, boolean readData) throws IOException {
        this.duration = bb.getLong();
        if (this.duration < 0L) {
            throw new IOException("Can't create a datagram with a negative duration [" + this.duration + "].");
        }
        int len = bb.getInt();
        if (len < 0) {
            throw new IOException("Can't create a datagram with a negative data size [" + len + "].");
        }
        this.data = new byte[len];
        if (!readData) {
            return;
        }
        if (bb.limit() - bb.position() < len) {
            throw new IOException("Not enough data in byte buffer to read the full datagram: datagram length is " + len + ", but can read only " + (bb.limit() - bb.position()));
        }
        bb.get(this.data);
    }

    public void setDuration(long setDuration) {
        if (setDuration < 0L) {
            throw new IllegalArgumentException("Can't create a datagram with the negative duration [" + setDuration + "].");
        }
        this.duration = setDuration;
    }

    public void write(DataOutput raf) throws IOException {
        assert (this.duration >= 0L);
        if (this.data == null) {
            throw new IllegalStateException("This method can only be called for data that is not null");
        }
        raf.writeLong(this.duration);
        raf.writeInt(this.data.length);
        raf.write(this.data);
    }

    public long getDuration() {
        assert (this.duration >= 0L);
        return this.duration;
    }

    public int getLength() {
        if (this.data == null) {
            throw new IllegalStateException("This method must not be called if data is null");
        }
        return this.data.length;
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Datagram)) {
            return false;
        }
        Datagram other = (Datagram)obj;
        if (this.duration != other.duration) {
            return false;
        }
        if (this.data.length != other.data.length) {
            return false;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == other.data[i]) continue;
            return false;
        }
        return true;
    }
}

