/*
 * Decompiled with CFR 0.152.
 */
package marytts.util;

import java.io.File;
import java.net.MalformedURLException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import marytts.server.MaryProperties;
import marytts.util.MaryUtils;

public class MaryCache {
    private static MaryCache maryCache;
    private Connection connection;

    public static MaryCache getCache() {
        if (maryCache == null) {
            try {
                File targetFile = new File(MaryProperties.getFilename("cache.file", "maryCache"));
                File directory = targetFile.getParentFile();
                if (!directory.isDirectory()) {
                    directory.mkdirs();
                }
                maryCache = new MaryCache(targetFile, MaryProperties.getBoolean("cache.clearOnStart", false));
            }
            catch (Exception e) {
                MaryUtils.getLogger(MaryCache.class).warn("Cannot set up cache", e);
            }
        }
        return maryCache;
    }

    public static boolean haveCache() {
        return maryCache != null;
    }

    public MaryCache(File cacheFile, boolean clearCache) throws ClassNotFoundException, SQLException {
        Class.forName("org.hsqldb.jdbcDriver");
        this.connection = DriverManager.getConnection("jdbc:hsqldb:" + cacheFile.toURI().toString(), "sa", "");
        boolean mustCreateTable = false;
        if (clearCache) {
            Statement st = this.connection.createStatement();
            st.executeUpdate("DROP TABLE MARYCACHE IF EXISTS");
            st.close();
            mustCreateTable = true;
        } else {
            DatabaseMetaData dbInfo = this.connection.getMetaData();
            ResultSet rs = dbInfo.getTables(null, null, "MARYCACHE", new String[]{"TABLE"});
            if (!rs.next()) {
                mustCreateTable = true;
            }
        }
        if (mustCreateTable) {
            String query = "CREATE CACHED TABLE MARYCACHE (id INTEGER IDENTITY, inputtype VARCHAR(50), outputtype VARCHAR(50), locale VARCHAR(10), voice VARCHAR(100), outputparams VARCHAR(1000), style VARCHAR(50), effects VARCHAR(1000), inputtext LONGVARCHAR, outputtext LONGVARCHAR, outputaudio LONGVARBINARY, UNIQUE(inputtype, outputtype, locale, voice, outputparams, style, effects, inputtext))";
            this.update(query);
        }
    }

    private synchronized void update(String query) throws SQLException {
        Statement st = this.connection.createStatement();
        int ok = st.executeUpdate(query);
        if (ok == -1) {
            throw new SQLException("DB problem with query: " + query);
        }
        st.close();
    }

    public void insertText(String inputtype, String outputtype, String locale, String voice, String inputtext, String outputtext) throws SQLException {
        this.insertText(inputtype, outputtype, locale, voice, null, null, null, inputtext, outputtext);
    }

    public synchronized void insertText(String inputtype, String outputtype, String locale, String voice, String outputparams, String style, String effects, String inputtext, String outputtext) throws SQLException {
        if (inputtype == null || outputtype == null || locale == null || voice == null || inputtext == null || outputtext == null) {
            throw new NullPointerException("Null argument");
        }
        if (this.lookupText(inputtype, outputtype, locale, voice, outputparams, style, effects, inputtext) != null) {
            return;
        }
        String query = "INSERT INTO MARYCACHE (inputtype, outputtype, locale, voice, outputparams, style, effects, inputtext, outputtext) VALUES ('" + inputtype + "','" + outputtype + "','" + locale + "','" + voice + "','" + outputparams + "','" + style + "','" + effects + "',?,?)";
        PreparedStatement st = this.connection.prepareStatement(query);
        st.setString(1, inputtext);
        st.setString(2, outputtext);
        st.executeUpdate();
        st.close();
    }

    public void insertAudio(String inputtype, String locale, String voice, String inputtext, byte[] audio) throws SQLException {
        this.insertAudio(inputtype, locale, voice, null, null, null, inputtext, audio);
    }

    public synchronized void insertAudio(String inputtype, String locale, String voice, String outputparams, String style, String effects, String inputtext, byte[] audio) throws SQLException {
        if (inputtype == null || locale == null || voice == null || inputtext == null) {
            throw new NullPointerException("Null argument");
        }
        if (this.lookupAudio(inputtype, locale, voice, outputparams, style, effects, inputtext) != null) {
            return;
        }
        String query = "INSERT INTO MARYCACHE (inputtype, outputtype, locale, voice, outputparams, style, effects, inputtext, outputaudio) VALUES('" + inputtype + "','AUDIO','" + locale + "','" + voice + "','" + outputparams + "','" + style + "','" + effects + "',?,?)";
        PreparedStatement st = this.connection.prepareStatement(query);
        st.setString(1, inputtext);
        st.setBytes(2, audio);
        st.executeUpdate();
        st.close();
    }

    public String lookupText(String inputtype, String outputtype, String locale, String voice, String inputtext) throws SQLException {
        return this.lookupText(inputtype, outputtype, locale, voice, null, null, null, inputtext);
    }

    public synchronized String lookupText(String inputtype, String outputtype, String locale, String voice, String outputparams, String style, String effects, String inputtext) throws SQLException {
        if (inputtype == null || outputtype == null || locale == null || voice == null || inputtext == null) {
            throw new NullPointerException("Null argument");
        }
        String outputtext = null;
        String query = "SELECT outputtext FROM marycache WHERE inputtype = '" + inputtype + "' AND outputtype = '" + outputtype + "' AND locale = '" + locale + "' AND voice = '" + voice + "' AND outputparams = '" + outputparams + "' AND style = '" + style + "' AND effects = '" + effects + "' AND inputtext = ?";
        PreparedStatement st = this.connection.prepareStatement(query);
        st.setString(1, inputtext);
        ResultSet results = st.executeQuery();
        if (results.next()) {
            outputtext = results.getString(1);
        }
        st.close();
        return outputtext;
    }

    public byte[] lookupAudio(String inputtype, String locale, String voice, String inputtext) throws SQLException {
        return this.lookupAudio(inputtype, locale, voice, null, null, null, inputtext);
    }

    public synchronized byte[] lookupAudio(String inputtype, String locale, String voice, String outputparams, String style, String effects, String inputtext) throws SQLException {
        if (inputtype == null || locale == null || voice == null || inputtext == null) {
            throw new NullPointerException("Null argument");
        }
        byte[] audio = null;
        String query = "Select outputaudio FROM marycache WHERE inputtype = '" + inputtype + "' AND outputtype = 'AUDIO' AND locale = '" + locale + "' AND voice = '" + voice + "' AND outputparams = '" + outputparams + "' AND style = '" + style + "' AND effects = '" + effects + "' AND inputtext = ?";
        PreparedStatement st = this.connection.prepareStatement(query);
        st.setString(1, inputtext);
        ResultSet results = st.executeQuery();
        if (results.next()) {
            audio = results.getBytes(1);
        }
        return audio;
    }

    public void shutdown() throws SQLException {
        Statement st = this.connection.createStatement();
        st.execute("SHUTDOWN");
        this.connection.close();
    }

    public static void main(String[] args) throws SQLException, MalformedURLException, ClassNotFoundException {
        MaryCache c = new MaryCache(new File("/Users/marc/Desktop/testdb/testDB"), false);
        String text = c.lookupText("TEXT", "RAWMARYXML", "de", "de1", "Welcome to the world of speech synthesis");
        System.out.println("looked up text: " + text);
        byte[] zeros = new byte[200000];
        byte[] newones = c.lookupAudio("TEXT", "de", "de1", "some dummy text");
        System.out.println("Retrieved binary data of length " + newones.length);
        c.shutdown();
    }
}

