/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection.analysis;

import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import marytts.exceptions.MaryConfigurationException;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmAnalyzerParams;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmSpeechFrame;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmSpeechSignal;
import marytts.signalproc.sinusoidal.hntm.synthesis.HntmSynthesizedSignal;
import marytts.signalproc.sinusoidal.hntm.synthesis.HntmSynthesizer;
import marytts.signalproc.sinusoidal.hntm.synthesis.HntmSynthesizerParams;
import marytts.unitselection.analysis.VoiceDataDumper;
import marytts.unitselection.data.HnmDatagram;
import marytts.unitselection.data.HnmTimelineReader;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.Datagram;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.math.MathUtils;

public class HnmVoiceDataDumper
extends VoiceDataDumper {
    private AudioFormat audioformat;

    @Override
    protected HnmTimelineReader loadAudioTimeline(String fileName) throws IOException, MaryConfigurationException {
        HnmTimelineReader audioTimeline = new HnmTimelineReader(fileName);
        int sampleRate = audioTimeline.getSampleRate();
        this.audioformat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, sampleRate, 16, 1, 2, sampleRate, true);
        return audioTimeline;
    }

    @Override
    protected byte[] getSamples(Datagram[] datagrams) throws IOException {
        HntmSynthesizer hnmSynthesizer = new HntmSynthesizer();
        HntmAnalyzerParams hnmAnalysisParams = new HntmAnalyzerParams();
        HntmSynthesizerParams hnmSynthesisParams = new HntmSynthesizerParams();
        float originalDurationInSeconds = 0.0f;
        for (Datagram datagram : datagrams) {
            HnmDatagram hnmDatagram = (HnmDatagram)datagram;
            originalDurationInSeconds += hnmDatagram.getFrame().deltaAnalysisTimeInSeconds;
        }
        HntmSpeechSignal hnmSpeechSignal = new HntmSpeechSignal(datagrams.length, this.unitDB.getAudioTimeline().getSampleRate(), originalDurationInSeconds);
        float tAnalysisInSeconds = 0.0f;
        for (int i = 0; i < datagrams.length; ++i) {
            HntmSpeechFrame hnmSpeechFrame = ((HnmDatagram)datagrams[i]).getFrame();
            hnmSpeechFrame.tAnalysisInSeconds = tAnalysisInSeconds += hnmSpeechFrame.deltaAnalysisTimeInSeconds;
            hnmSpeechSignal.frames[i] = hnmSpeechFrame;
        }
        HntmSynthesizedSignal hnmSynthesizedSignal = hnmSynthesizer.synthesize(hnmSpeechSignal, null, null, null, null, hnmAnalysisParams, hnmSynthesisParams);
        double[] output = MathUtils.multiply(hnmSynthesizedSignal.output, 3.0517578125E-5);
        BufferedDoubleDataSource buffer = new BufferedDoubleDataSource(output);
        DDSAudioInputStream audio = new DDSAudioInputStream(buffer, this.audioformat);
        byte[] samples = new byte[(int)audio.getFrameLength() * this.audioformat.getFrameSize()];
        audio.read(samples);
        return samples;
    }

    public static void main(String[] args) throws Exception {
        new HnmVoiceDataDumper().dumpData(args[0]);
    }
}

