/*
 * Decompiled with CFR 0.152.
 */
package marytts.tools.emospeak;

import java.io.StringWriter;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import marytts.tools.emospeak.ProsodyXMLDisplayer;
import marytts.util.MaryUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EmoTransformer
extends Thread {
    private int r;
    private ProsodyXMLDisplayer emoSpeak;
    private TransformerFactory tFactory = null;
    private Templates stylesheet = null;
    private Transformer transformer = null;
    private DocumentBuilderFactory dbFactory = null;
    private DocumentBuilder docBuilder = null;
    private Document emotionDocument = null;
    private boolean inputAvailable = false;
    private int activation;
    private int evaluation;
    private int power;
    private String text;
    private String maryxmlString;
    private Locale locale;
    private boolean exitRequested = false;

    public EmoTransformer(ProsodyXMLDisplayer emoSpeak) throws TransformerConfigurationException, ParserConfigurationException {
        this.emoSpeak = emoSpeak;
        this.tFactory = TransformerFactory.newInstance();
        System.err.println("Using XSL processor " + this.tFactory.getClass().getName());
        StreamSource stylesheetStream = new StreamSource(EmoTransformer.class.getResourceAsStream("emotion-to-mary.xsl"));
        this.stylesheet = this.tFactory.newTemplates(stylesheetStream);
        this.dbFactory = DocumentBuilderFactory.newInstance();
        this.dbFactory.setNamespaceAware(true);
        this.docBuilder = this.dbFactory.newDocumentBuilder();
        this.transformer = this.stylesheet.newTransformer();
    }

    public synchronized void setEmotionValues(int activation, int evaluation, int power, String text, Locale locale, int r) {
        this.activation = activation;
        this.evaluation = evaluation;
        this.power = power;
        this.text = text;
        this.locale = locale;
        this.inputAvailable = true;
        this.r = r;
        this.notifyAll();
    }

    public synchronized void requestExit() {
        this.exitRequested = true;
        this.notifyAll();
    }

    private void createEmotionDocument() {
        this.emotionDocument = this.docBuilder.getDOMImplementation().createDocument(null, "emotion", null);
        Element e = this.emotionDocument.getDocumentElement();
        e.setAttributeNS("http://www.w3.org/XML/1998/namespace", "lang", MaryUtils.locale2xmllang(this.locale));
        e.setAttribute("activation", String.valueOf(this.activation));
        e.setAttribute("evaluation", String.valueOf(this.evaluation));
        e.setAttribute("power", String.valueOf(this.power));
        e.appendChild(this.emotionDocument.createTextNode(this.text));
    }

    private void transformToMaryXML() throws TransformerException {
        DOMSource domSource = new DOMSource(this.emotionDocument);
        StringWriter sw = new StringWriter();
        StreamResult streamResult = new StreamResult(sw);
        this.transformer.transform(domSource, streamResult);
        this.maryxmlString = sw.toString();
    }

    private synchronized void doWait() {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        while (!this.exitRequested) {
            if (this.inputAvailable) {
                this.inputAvailable = false;
                try {
                    int r1 = this.r;
                    System.err.println("EmoTransformer about to process request no. " + r1);
                    this.createEmotionDocument();
                    this.transformToMaryXML();
                    System.err.println("EmoTransformer has processed.");
                    this.emoSpeak.updateProsodyXML(this.maryxmlString, r1);
                }
                catch (TransformerException e) {
                    e.printStackTrace();
                }
                continue;
            }
            this.doWait();
            System.err.println("EmoTransformer waking up from wait.");
        }
        System.err.println("EmoTransformer exiting.");
    }
}

