/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.window;

import marytts.signalproc.display.FunctionGraph;
import marytts.signalproc.display.LogSpectrum;
import marytts.signalproc.window.DynamicWindow;
import marytts.signalproc.window.Window;
import marytts.util.math.MathUtils;

public class DynamicTwoHalvesWindow
extends DynamicWindow {
    protected double prescale;

    public DynamicTwoHalvesWindow(int windowType) {
        super(windowType);
        this.prescale = 1.0;
    }

    public DynamicTwoHalvesWindow(int windowType, double prescale) {
        super(windowType);
        this.prescale = prescale;
    }

    public void applyInlineLeftHalf(double[] data, int off, int len) {
        Window w = Window.get(this.windowType, 2 * len, this.prescale);
        w.apply(data, off, data, off, 0, len);
    }

    public void applyInlineRightHalf(double[] data, int off, int len) {
        Window w = Window.get(this.windowType, 2 * len, this.prescale);
        w.apply(data, off, data, off, len, len);
    }

    public static void main(String[] args) {
        int samplingRate = Integer.getInteger("samplingrate", 1);
        int windowLengthMs = Integer.getInteger("windowlength.ms", 0);
        int windowLength = Integer.getInteger("windowlength.samples", 512);
        float asymmetry = 1.5f;
        if (windowLengthMs != 0) {
            windowLength = windowLengthMs * samplingRate / 1000;
        }
        int leftHalfLength = windowLength / 2;
        int rightHalfLength = (int)((float)leftHalfLength * asymmetry);
        windowLength = leftHalfLength + rightHalfLength;
        int fftSize = Math.max(4096, MathUtils.closestPowerOfTwoAbove(windowLength));
        int windowType = 3;
        Window wLeft = Window.get(windowType, 2 * leftHalfLength);
        Window wRight = Window.get(windowType, 2 * rightHalfLength);
        double[] window = new double[windowLength];
        System.arraycopy(wLeft.window, 0, window, 0, leftHalfLength);
        System.arraycopy(wRight.window, rightHalfLength, window, leftHalfLength, rightHalfLength);
        FunctionGraph timeGraph = new FunctionGraph(0.0, 1.0 / (double)samplingRate, window);
        timeGraph.showInJFrame("Asymmetric " + wLeft.toString() + " in time domain", true, false);
        double[] fftSignal = new double[fftSize];
        double sum = MathUtils.sum(window);
        for (int i = 0; i < window.length; ++i) {
            fftSignal[i] = window[i] / sum;
        }
        LogSpectrum freqGraph = new LogSpectrum(fftSignal, samplingRate);
        freqGraph.showInJFrame("Asymmetric " + wLeft.toString() + " log frequency response", true, false);
    }
}

