/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal.hntm.analysis.pitch;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class HnmPitchVoicingAnalyzerParams {
    public float mvfAnalysisWindowSizeInSeconds;
    public float mvfAnalysisSkipSizeInSeconds;
    public float f0AnalysisWindowSizeInSeconds;
    public float f0AnalysisSkipSizeInSeconds;
    public int fftSize;
    public int numFilteringStages;
    public int medianFilterLength;
    public int movingAverageFilterLength;
    public float numPeriodsInitialPitchEstimation;
    public float cumulativeAmpThreshold;
    public float maximumAmpThresholdInDB;
    public float harmonicDeviationPercent;
    public float sharpPeakAmpDiffInDB;
    public int minimumTotalHarmonics;
    public int maximumTotalHarmonics;
    public float minimumVoicedFrequencyOfVoicing;
    public float maximumVoicedFrequencyOfVoicing;
    public float maximumFrequencyOfVoicingFinalShift;
    public float runningMeanVoicingThreshold;
    public int lastCorrelatedHarmonicNeighbour;
    public float vuvSearchMinHarmonicMultiplier;
    public float vuvSearchMaxHarmonicMultiplier;
    public float neighsPercent;

    public HnmPitchVoicingAnalyzerParams() {
        this.mvfAnalysisWindowSizeInSeconds = 0.04f;
        this.mvfAnalysisSkipSizeInSeconds = 0.01f;
        this.f0AnalysisWindowSizeInSeconds = 0.04f;
        this.f0AnalysisSkipSizeInSeconds = 0.005f;
        this.fftSize = 4096;
        this.numFilteringStages = 2;
        this.medianFilterLength = 12;
        this.movingAverageFilterLength = 12;
        this.numPeriodsInitialPitchEstimation = 3.0f;
        this.cumulativeAmpThreshold = 2.0f;
        this.maximumAmpThresholdInDB = 13.0f;
        this.harmonicDeviationPercent = 20.0f;
        this.sharpPeakAmpDiffInDB = 12.0f;
        this.minimumTotalHarmonics = 0;
        this.maximumTotalHarmonics = 100;
        this.minimumVoicedFrequencyOfVoicing = 5000.0f;
        this.maximumVoicedFrequencyOfVoicing = 5000.0f;
        this.maximumFrequencyOfVoicingFinalShift = 0.0f;
        this.runningMeanVoicingThreshold = 0.5f;
        this.lastCorrelatedHarmonicNeighbour = -1;
        this.vuvSearchMinHarmonicMultiplier = 0.7f;
        this.vuvSearchMaxHarmonicMultiplier = 4.3f;
        this.neighsPercent = 50.0f;
    }

    public HnmPitchVoicingAnalyzerParams(DataInputStream dis) {
        try {
            this.read(dis);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public HnmPitchVoicingAnalyzerParams(HnmPitchVoicingAnalyzerParams existing) {
        this.mvfAnalysisWindowSizeInSeconds = existing.mvfAnalysisWindowSizeInSeconds;
        this.mvfAnalysisSkipSizeInSeconds = existing.mvfAnalysisSkipSizeInSeconds;
        this.f0AnalysisWindowSizeInSeconds = existing.f0AnalysisWindowSizeInSeconds;
        this.f0AnalysisSkipSizeInSeconds = existing.f0AnalysisSkipSizeInSeconds;
        this.fftSize = existing.fftSize;
        this.numFilteringStages = existing.numFilteringStages;
        this.medianFilterLength = existing.medianFilterLength;
        this.movingAverageFilterLength = existing.movingAverageFilterLength;
        this.numPeriodsInitialPitchEstimation = existing.numPeriodsInitialPitchEstimation;
        this.cumulativeAmpThreshold = existing.cumulativeAmpThreshold;
        this.maximumAmpThresholdInDB = existing.maximumAmpThresholdInDB;
        this.harmonicDeviationPercent = existing.harmonicDeviationPercent;
        this.sharpPeakAmpDiffInDB = existing.sharpPeakAmpDiffInDB;
        this.minimumTotalHarmonics = existing.minimumTotalHarmonics;
        this.maximumTotalHarmonics = existing.maximumTotalHarmonics;
        this.minimumVoicedFrequencyOfVoicing = existing.minimumVoicedFrequencyOfVoicing;
        this.maximumVoicedFrequencyOfVoicing = existing.maximumVoicedFrequencyOfVoicing;
        this.maximumFrequencyOfVoicingFinalShift = existing.maximumFrequencyOfVoicingFinalShift;
        this.runningMeanVoicingThreshold = existing.runningMeanVoicingThreshold;
        this.lastCorrelatedHarmonicNeighbour = existing.lastCorrelatedHarmonicNeighbour;
        this.vuvSearchMinHarmonicMultiplier = existing.vuvSearchMinHarmonicMultiplier;
        this.vuvSearchMaxHarmonicMultiplier = existing.vuvSearchMaxHarmonicMultiplier;
        this.neighsPercent = existing.neighsPercent;
    }

    public boolean equals(HnmPitchVoicingAnalyzerParams existing) {
        if (this.mvfAnalysisWindowSizeInSeconds != existing.mvfAnalysisWindowSizeInSeconds) {
            return false;
        }
        if (this.mvfAnalysisSkipSizeInSeconds != existing.mvfAnalysisSkipSizeInSeconds) {
            return false;
        }
        if (this.f0AnalysisWindowSizeInSeconds != existing.f0AnalysisWindowSizeInSeconds) {
            return false;
        }
        if (this.f0AnalysisSkipSizeInSeconds != existing.f0AnalysisSkipSizeInSeconds) {
            return false;
        }
        if (this.fftSize != existing.fftSize) {
            return false;
        }
        if (this.numFilteringStages != existing.numFilteringStages) {
            return false;
        }
        if (this.medianFilterLength != existing.medianFilterLength) {
            return false;
        }
        if (this.movingAverageFilterLength != existing.movingAverageFilterLength) {
            return false;
        }
        if (this.numPeriodsInitialPitchEstimation != existing.numPeriodsInitialPitchEstimation) {
            return false;
        }
        if (this.cumulativeAmpThreshold != existing.cumulativeAmpThreshold) {
            return false;
        }
        if (this.maximumAmpThresholdInDB != existing.maximumAmpThresholdInDB) {
            return false;
        }
        if (this.harmonicDeviationPercent != existing.harmonicDeviationPercent) {
            return false;
        }
        if (this.sharpPeakAmpDiffInDB != existing.sharpPeakAmpDiffInDB) {
            return false;
        }
        if (this.minimumTotalHarmonics != existing.minimumTotalHarmonics) {
            return false;
        }
        if (this.maximumTotalHarmonics != existing.maximumTotalHarmonics) {
            return false;
        }
        if (this.minimumVoicedFrequencyOfVoicing != existing.minimumVoicedFrequencyOfVoicing) {
            return false;
        }
        if (this.maximumVoicedFrequencyOfVoicing != existing.maximumVoicedFrequencyOfVoicing) {
            return false;
        }
        if (this.maximumFrequencyOfVoicingFinalShift != existing.maximumFrequencyOfVoicingFinalShift) {
            return false;
        }
        if (this.runningMeanVoicingThreshold != existing.runningMeanVoicingThreshold) {
            return false;
        }
        if (this.lastCorrelatedHarmonicNeighbour != existing.lastCorrelatedHarmonicNeighbour) {
            return false;
        }
        if (this.vuvSearchMinHarmonicMultiplier != existing.vuvSearchMinHarmonicMultiplier) {
            return false;
        }
        if (this.vuvSearchMaxHarmonicMultiplier != existing.vuvSearchMaxHarmonicMultiplier) {
            return false;
        }
        return this.neighsPercent == existing.neighsPercent;
    }

    public void write(DataOutputStream dos) throws IOException {
        dos.writeFloat(this.mvfAnalysisWindowSizeInSeconds);
        dos.writeFloat(this.mvfAnalysisSkipSizeInSeconds);
        dos.writeFloat(this.f0AnalysisWindowSizeInSeconds);
        dos.writeFloat(this.f0AnalysisSkipSizeInSeconds);
        dos.writeInt(this.fftSize);
        dos.writeInt(this.numFilteringStages);
        dos.writeInt(this.medianFilterLength);
        dos.writeInt(this.movingAverageFilterLength);
        dos.writeFloat(this.numPeriodsInitialPitchEstimation);
        dos.writeDouble(this.cumulativeAmpThreshold);
        dos.writeDouble(this.maximumAmpThresholdInDB);
        dos.writeDouble(this.harmonicDeviationPercent);
        dos.writeDouble(this.sharpPeakAmpDiffInDB);
        dos.writeInt(this.minimumTotalHarmonics);
        dos.writeInt(this.maximumTotalHarmonics);
        dos.writeFloat(this.minimumVoicedFrequencyOfVoicing);
        dos.writeFloat(this.maximumVoicedFrequencyOfVoicing);
        dos.writeFloat(this.maximumFrequencyOfVoicingFinalShift);
        dos.writeFloat(this.runningMeanVoicingThreshold);
        dos.writeInt(this.lastCorrelatedHarmonicNeighbour);
        dos.writeDouble(this.vuvSearchMinHarmonicMultiplier);
        dos.writeDouble(this.vuvSearchMaxHarmonicMultiplier);
        dos.writeDouble(this.neighsPercent);
    }

    public void read(DataInputStream dis) throws IOException {
        this.mvfAnalysisWindowSizeInSeconds = dis.readFloat();
        this.mvfAnalysisSkipSizeInSeconds = dis.readFloat();
        this.f0AnalysisWindowSizeInSeconds = dis.readFloat();
        this.f0AnalysisSkipSizeInSeconds = dis.readFloat();
        this.fftSize = dis.readInt();
        this.numFilteringStages = dis.readInt();
        this.medianFilterLength = dis.readInt();
        this.movingAverageFilterLength = dis.readInt();
        this.numPeriodsInitialPitchEstimation = dis.readFloat();
        this.cumulativeAmpThreshold = dis.readFloat();
        this.maximumAmpThresholdInDB = dis.readFloat();
        this.harmonicDeviationPercent = dis.readFloat();
        this.sharpPeakAmpDiffInDB = dis.readFloat();
        this.minimumTotalHarmonics = dis.readInt();
        this.maximumTotalHarmonics = dis.readInt();
        this.minimumVoicedFrequencyOfVoicing = dis.readFloat();
        this.maximumVoicedFrequencyOfVoicing = dis.readFloat();
        this.maximumFrequencyOfVoicingFinalShift = dis.readFloat();
        this.runningMeanVoicingThreshold = dis.readFloat();
        this.lastCorrelatedHarmonicNeighbour = dis.readInt();
        this.vuvSearchMinHarmonicMultiplier = dis.readFloat();
        this.vuvSearchMaxHarmonicMultiplier = dis.readFloat();
        this.neighsPercent = dis.readFloat();
    }
}

