/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.filter;

import java.io.File;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.signalproc.display.FunctionGraph;
import marytts.signalproc.filter.FIRFilter;
import marytts.signalproc.window.BlackmanWindow;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.DoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.math.FFT;
import marytts.util.math.MathUtils;

public class LowPassFilter
extends FIRFilter {
    public static double DEFAULT_TRANSITIONBANDWIDTH = 0.01;
    public double normalisedCutoffFrequency;

    public LowPassFilter(double normalisedCutoffFrequencyIn) {
        this(normalisedCutoffFrequencyIn, DEFAULT_TRANSITIONBANDWIDTH);
    }

    public LowPassFilter(double normalisedCutoffFrequencyIn, double normalisedTransitionBandwidth) {
        this(normalisedCutoffFrequencyIn, LowPassFilter.bandwidth2kernelLength(normalisedTransitionBandwidth));
    }

    public LowPassFilter(double normalisedCutoffFrequencyIn, int kernelLength) {
        if (kernelLength <= 0 || kernelLength % 2 == 0) {
            throw new IllegalArgumentException("Kernel length must be an odd positive number, got " + kernelLength);
        }
        this.normalisedCutoffFrequency = normalisedCutoffFrequencyIn;
        if (this.normalisedCutoffFrequency <= 0.0 || this.normalisedCutoffFrequency >= 0.5) {
            throw new IllegalArgumentException("Normalised cutoff frequency must be between 0 and 0.5, got " + this.normalisedCutoffFrequency);
        }
        double[] kernel = LowPassFilter.getKernel(this.normalisedCutoffFrequency, kernelLength);
        this.sliceLength = MathUtils.closestPowerOfTwoAbove(2 * kernelLength) - kernelLength;
        this.initialise(kernel, this.sliceLength);
    }

    public double getTransitionBandWidth(int samplingRate) {
        return (double)samplingRate * LowPassFilter.kernelLength2bandwidth(this.impulseResponseLength);
    }

    protected static double[] getKernel(double normalisedCutoffFrequencyIn, int kernelLength) {
        int i;
        double[] kernel = new double[kernelLength];
        int m = (kernelLength - 1) / 2;
        double fc = normalisedCutoffFrequencyIn;
        double sum = 0.0;
        BlackmanWindow window = new BlackmanWindow(kernelLength);
        for (i = 0; i < m; ++i) {
            kernel[i] = Math.sin(Math.PI * 2 * fc * (double)(i - m)) / (double)(i - m) * window.value(i);
            kernel[kernelLength - i - 1] = kernel[i];
            sum += 2.0 * kernel[i];
        }
        kernel[m] = Math.PI * 2 * fc;
        sum += kernel[m];
        i = 0;
        while (i < kernelLength) {
            int n = i++;
            kernel[n] = kernel[n] / sum;
        }
        return kernel;
    }

    protected static int bandwidth2kernelLength(double normalisedTransitionBandwidth) {
        int l = (int)(4.0 / normalisedTransitionBandwidth);
        if (l % 2 == 0) {
            ++l;
        }
        return l;
    }

    protected static double kernelLength2bandwidth(int kernelLength) {
        return 4.0 / (double)kernelLength;
    }

    public String toString() {
        return "Lowpass filter";
    }

    public static void main(String[] args) throws Exception {
        int cutoffFreq = Integer.valueOf(args[0]);
        AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(args[1]));
        int samplingRate = (int)inputAudio.getFormat().getSampleRate();
        AudioDoubleDataSource source = new AudioDoubleDataSource(inputAudio);
        double normalisedCutoffFrequency = (double)cutoffFreq / (double)samplingRate;
        LowPassFilter filter = new LowPassFilter(normalisedCutoffFrequency);
        System.err.println("Created " + filter.toString() + " with cutoff frequency " + cutoffFreq + " Hz and transition band width " + (int)filter.getTransitionBandWidth(samplingRate) + " Hz");
        double[] fftSignal = new double[filter.transformedIR.length];
        System.arraycopy(filter.transformedIR, 0, fftSignal, 0, filter.transformedIR.length);
        FFT.realTransform(fftSignal, true);
        double[] kernel = new double[filter.impulseResponseLength];
        System.arraycopy(fftSignal, 0, kernel, 0, kernel.length);
        FunctionGraph timeGraph = new FunctionGraph(0.0, 1.0, kernel);
        timeGraph.showInJFrame(filter.toString() + " in time domain", true, false);
        double[] powerSpectrum = FFT.computePowerSpectrum_FD(filter.transformedIR);
        for (int i = 0; i < powerSpectrum.length; ++i) {
            powerSpectrum[i] = MathUtils.db(powerSpectrum[i]);
        }
        FunctionGraph freqGraph = new FunctionGraph(0.0, (double)samplingRate / (double)filter.transformedIR.length, powerSpectrum);
        freqGraph.showInJFrame(filter.toString() + " log frequency response", true, false);
        DoubleDataSource filteredSignal = filter.apply(source);
        DDSAudioInputStream outputAudio = new DDSAudioInputStream(new BufferedDoubleDataSource(filteredSignal), source.getAudioFormat());
        String outFileName = args[1].substring(0, args[1].length() - 4) + "_lpf.wav";
        AudioSystem.write((AudioInputStream)outputAudio, AudioFileFormat.Type.WAVE, new File(outFileName));
    }
}

