/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.effects;

import marytts.signalproc.effects.AudioEffect;
import marytts.util.data.DoubleDataSource;
import marytts.util.string.StringUtils;

public class BaseAudioEffect
implements AudioEffect {
    public static String strLineBreak = "\n";
    public static float NULL_FLOAT_PARAM = -100000.0f;
    public static double NULL_DOUBLE_PARAM = -100000.0;
    public static int NULL_INT_PARAM = -100000;
    public static String NULL_STRING_PARAM = "";
    public String strEffectName = "";
    public String strHelpText = "";
    public String strExampleParameters = "";
    public String[] paramNames;
    public float[] paramVals;
    public String strParams;
    public static char chParamEquals = (char)58;
    public static char chParamSeparator = (char)59;
    public static char chEffectParamStart = (char)40;
    public static char chEffectParamEnd = (char)41;
    private boolean isHMMEffect;
    public int fs;

    public BaseAudioEffect(BaseAudioEffect existing) {
        int i;
        this.fs = existing.fs;
        if (existing.paramNames != null && existing.paramNames.length > 0) {
            this.paramNames = new String[existing.paramNames.length];
            for (i = 0; i < this.paramNames.length; ++i) {
                this.paramNames[i] = existing.paramNames[i];
            }
        } else {
            this.paramNames = null;
        }
        if (existing.paramVals != null && existing.paramVals.length > 0) {
            this.paramVals = new float[existing.paramVals.length];
            for (i = 0; i < this.paramVals.length; ++i) {
                this.paramVals[i] = existing.paramVals[i];
            }
        } else {
            this.paramVals = null;
        }
        this.strEffectName = existing.strEffectName;
        this.strParams = existing.strParams;
        this.strExampleParameters = existing.strExampleParameters;
        this.strHelpText = existing.strHelpText;
        this.setHMMEffect(false);
    }

    public BaseAudioEffect(int samplingRate) {
        this.fs = samplingRate;
        this.parseParameters(this.getExampleParameters());
    }

    public BaseAudioEffect(int samplingRate, String strParams) {
        this.fs = samplingRate;
        this.parseParameters(strParams);
    }

    public DoubleDataSource apply(DoubleDataSource input) {
        return this.apply(input, this.strParams);
    }

    @Override
    public DoubleDataSource apply(DoubleDataSource input, String param) {
        this.strParams = param;
        this.parseParameters(this.strParams);
        return this.process(input);
    }

    @Override
    public DoubleDataSource process(DoubleDataSource input) {
        return input;
    }

    @Override
    public void setParams(String params) {
        String params2 = this.preprocessParams(params);
        this.parseParameters(params2);
        this.checkParameters();
    }

    @Override
    public String preprocessParams(String params) {
        String params2 = params;
        params2 = params2.replace('=', chParamEquals);
        params2 = params2.replace(',', chParamSeparator);
        params2 = params2.replaceAll(" ", "");
        return params2;
    }

    @Override
    public void parseParameters(String param) {
        if (param != null && param != "") {
            int count = 0;
            int ind = -1;
            while ((ind = param.indexOf(chParamEquals, ind + 1)) > -1) {
                ++count;
            }
            if (count > 0) {
                int stName = 0;
                int enName = -1;
                int stVal = 0;
                int enVal = -1;
                int ind1 = -1;
                int ind2 = -1;
                this.paramNames = new String[count];
                this.paramVals = new float[count];
                for (int i = 0; i < count; ++i) {
                    ind1 = param.indexOf(chParamEquals, ind2 + 1);
                    ind2 = param.indexOf(chParamSeparator, ind1 + 1);
                    if (ind1 <= -1) continue;
                    enName = ind1 - 1;
                    stVal = ind1 + 1;
                    enVal = ind2 > -1 ? ind2 - 1 : param.length() - 1;
                    String strTmp = param.substring(stName, enName + 1);
                    this.paramNames[i] = strTmp = StringUtils.deblank(strTmp);
                    strTmp = param.substring(stVal, enVal + 1);
                    strTmp = StringUtils.deblank(strTmp);
                    try {
                        this.paramVals[i] = StringUtils.string2float(strTmp);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Error! The parameter should be numeric...");
                    }
                    stName = ind2 + 1;
                    if (stName > param.length() - 1) break;
                }
                this.strParams = this.getParamsAsString(false);
            }
        }
    }

    @Override
    public void checkParameters() {
    }

    @Override
    public String getExampleParameters() {
        return this.strExampleParameters;
    }

    @Override
    public String getName() {
        return this.strEffectName;
    }

    @Override
    public void setName(String strName) {
        this.strEffectName = strName;
    }

    @Override
    public void setExampleParameters(String strExampleParams) {
        this.strExampleParameters = strExampleParams;
        this.strExampleParameters = this.preprocessParams(this.strExampleParameters);
    }

    @Override
    public String getHelpText() {
        return this.strHelpText;
    }

    @Override
    public String getParamsAsString() {
        return this.getParamsAsString(true);
    }

    @Override
    public String getParamsAsString(boolean bWithParantheses) {
        String strRet = "";
        if (this.paramNames != null && this.paramNames.length > 0) {
            if (bWithParantheses) {
                strRet = strRet + chEffectParamStart;
            }
            for (int i = 0; i < this.paramNames.length; ++i) {
                strRet = strRet + this.paramNames[i] + chParamEquals + String.valueOf(this.paramVals[i]);
                if (i >= this.paramNames.length - 1) continue;
                strRet = strRet + chParamSeparator;
            }
            if (bWithParantheses) {
                strRet = strRet + chEffectParamEnd;
            }
        }
        return strRet;
    }

    @Override
    public String getFullEffectAsString() {
        return this.getName() + this.getParamsAsString(true);
    }

    public String setParamsFromFullName(String fullEffectAsString) {
        int ind = fullEffectAsString.indexOf(this.strEffectName);
        if (ind > -1) {
            String strNewParams = fullEffectAsString.substring(ind + this.strEffectName.length(), fullEffectAsString.length());
            this.setParams(strNewParams);
        }
        return this.getParamsAsString();
    }

    @Override
    public String getFullEffectWithExampleParametersAsString() {
        if (this.strExampleParameters != null && this.strExampleParameters != "") {
            return this.getName() + "(" + this.strExampleParameters + ")";
        }
        return this.getName();
    }

    @Override
    public float expectFloatParameter(String strParamName) {
        float ret = NULL_FLOAT_PARAM;
        if (this.paramNames != null) {
            for (int i = 0; i < this.paramNames.length; ++i) {
                if (strParamName.compareToIgnoreCase(this.paramNames[i]) != 0) continue;
                ret = this.paramVals[i];
                break;
            }
        }
        return ret;
    }

    @Override
    public double expectDoubleParameter(String strParamName) {
        double ret = NULL_DOUBLE_PARAM;
        if (this.paramNames != null) {
            for (int i = 0; i < this.paramNames.length; ++i) {
                if (strParamName.compareToIgnoreCase(this.paramNames[i]) != 0) continue;
                ret = this.paramVals[i];
                break;
            }
        }
        return ret;
    }

    @Override
    public int expectIntParameter(String strParamName) {
        int ret = NULL_INT_PARAM;
        if (this.paramNames != null) {
            for (int i = 0; i < this.paramNames.length; ++i) {
                if (strParamName.compareToIgnoreCase(this.paramNames[i]) != 0) continue;
                ret = (int)this.paramVals[i];
                break;
            }
        }
        return ret;
    }

    @Override
    public boolean isHMMEffect() {
        return this.isHMMEffect;
    }

    public void setHMMEffect(boolean bHMMEffect) {
        this.isHMMEffect = bHMMEffect;
    }

    public static void main(String[] args) throws Exception {
        BaseAudioEffect b = new BaseAudioEffect(16000, "a1:1.1 ; a2 :2.02; a3: 3.003; a4  :  4.0004  ;a5:5.12345; a6: 6.6   ; a7:7.0a");
        for (int i = 0; i < b.paramNames.length; ++i) {
            System.out.println(b.paramNames[i] + "=" + String.valueOf(b.paramVals[i]));
        }
    }
}

