/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis.distance;

import java.io.IOException;
import marytts.modules.phonemiser.AllophoneSet;
import marytts.signalproc.adaptation.BaselineAdaptationItem;
import marytts.signalproc.adaptation.BaselineAdaptationSet;
import marytts.signalproc.adaptation.BaselineFeatureExtractor;
import marytts.signalproc.analysis.AlignedLabels;
import marytts.signalproc.analysis.Label;
import marytts.signalproc.analysis.Labels;
import marytts.signalproc.analysis.LsfFileHeader;
import marytts.signalproc.analysis.Lsfs;
import marytts.signalproc.analysis.distance.BaselineDistortionComputer;
import marytts.tools.analysis.TranscriptionAligner;
import marytts.util.io.FileUtils;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;
import marytts.util.string.StringUtils;

public class RmsLsfDistortionComputer
extends BaselineDistortionComputer {
    private AllophoneSet allophoneSet;
    private String silenceSymbol;
    private TranscriptionAligner aligner;

    public RmsLsfDistortionComputer() throws IOException {
        this.setupTranscriptionAligner();
    }

    private void setupTranscriptionAligner() throws IOException {
        String allophoneSetFilename = System.getProperty("allophoneset");
        if (allophoneSetFilename == null) {
            throw new IOException("Allophone set not provided (use -Dallophoneset=/path/to/allophones.xml)");
        }
        this.allophoneSet = null;
        try {
            this.allophoneSet = AllophoneSet.getAllophoneSet(allophoneSetFilename);
        }
        catch (Exception e) {
            IOException ioe = new IOException("Problem reading Allophones file " + allophoneSetFilename);
            ioe.initCause(e);
            throw ioe;
        }
        this.silenceSymbol = this.allophoneSet.getSilence().name();
        this.aligner = new TranscriptionAligner(this.allophoneSet);
    }

    public double[] getDistances(String folder1, String folder2, double upperFreqInHz) throws IOException {
        folder1 = StringUtils.checkLastSlash(folder1);
        folder2 = StringUtils.checkLastSlash(folder2);
        BaselineAdaptationSet set1 = new BaselineAdaptationSet(folder1, ".wav");
        BaselineAdaptationSet set2 = new BaselineAdaptationSet(folder2, ".wav");
        return this.getDistances(set1, set2, false, upperFreqInHz);
    }

    public double[] getDistances(String folder1, String folder2, boolean isBark, double upperFreqInHz) throws IOException {
        folder1 = StringUtils.checkLastSlash(folder1);
        folder2 = StringUtils.checkLastSlash(folder2);
        BaselineAdaptationSet set1 = new BaselineAdaptationSet(folder1, ".wav");
        BaselineAdaptationSet set2 = new BaselineAdaptationSet(folder2, ".wav");
        return this.getDistances(set1, set2, isBark, upperFreqInHz);
    }

    public double[] getDistances(BaselineAdaptationSet set1, BaselineAdaptationSet set2, boolean isBark, double upperFreqInHz) throws IOException {
        int[] map = new int[Math.min(set1.items.length, set2.items.length)];
        for (int i = 0; i < map.length; ++i) {
            map[i] = i;
        }
        return this.getDistances(set1, set2, isBark, upperFreqInHz, map);
    }

    public double[] getDistances(BaselineAdaptationSet set1, BaselineAdaptationSet set2, boolean isBark, double upperFreqInHz, int[] map) throws IOException {
        double[] distances = null;
        double[] tmpDistances = null;
        for (int i = 0; i < map.length; ++i) {
            double[] itemDistances = this.getItemDistances(set1.items[i], set2.items[map[i]], isBark, upperFreqInHz);
            if (distances != null && itemDistances != null) {
                tmpDistances = new double[distances.length];
                System.arraycopy(distances, 0, tmpDistances, 0, distances.length);
                distances = new double[tmpDistances.length + itemDistances.length];
                System.arraycopy(tmpDistances, 0, distances, 0, tmpDistances.length);
                System.arraycopy(itemDistances, 0, distances, tmpDistances.length, itemDistances.length);
                continue;
            }
            distances = new double[itemDistances.length];
            System.arraycopy(itemDistances, 0, distances, 0, itemDistances.length);
        }
        return distances;
    }

    public double[][] getDistancesPerFile(BaselineAdaptationSet set1, BaselineAdaptationSet set2, boolean isBark, double upperFreqInHz, int[] map) throws IOException {
        double[][] allDistances = new double[map.length][];
        for (int i = 0; i < map.length; ++i) {
            double[] itemDistances = this.getItemDistances(set1.items[i], set2.items[map[i]], isBark, upperFreqInHz);
            allDistances[i] = itemDistances;
        }
        return allDistances;
    }

    private boolean isInitialOrFinalSilence(double time, Labels labels, String silenceSymbol) {
        int i = labels.getLabelIndexAtTime(time);
        if (i == -1) {
            i = time < 0.0 ? 0 : labels.items.length - 1;
        }
        assert (i >= 0);
        Label l = labels.items[i];
        return (i == 0 || i == labels.items.length - 1) && l.phn.equals(silenceSymbol);
    }

    private double computeOneFrameDistance(double[] l1, double[] l2, boolean isBark, double upperFreqInHz) {
        double[] tmp2;
        double[] tmp1;
        int maxInd2;
        int maxInd1 = MathUtils.getLargestIndexSmallerThan(l1, upperFreqInHz);
        int maxInd = Math.min(maxInd1, maxInd2 = MathUtils.getLargestIndexSmallerThan(l2, upperFreqInHz));
        if (maxInd + 1 == l1.length) {
            tmp1 = l1;
        } else {
            tmp1 = new double[maxInd + 1];
            System.arraycopy(l1, 0, tmp1, 0, maxInd + 1);
        }
        if (maxInd + 1 == l2.length) {
            tmp2 = l2;
        } else {
            tmp2 = new double[maxInd + 1];
            System.arraycopy(l2, 0, tmp2, 0, maxInd + 1);
        }
        double distance = !isBark ? SignalProcUtils.getRmsDistance(tmp1, tmp2) : SignalProcUtils.getRmsDistance(SignalProcUtils.freq2bark(tmp1), SignalProcUtils.freq2bark(tmp2));
        return distance;
    }

    public double[] getItemDistances(BaselineAdaptationItem item1, BaselineAdaptationItem item2, boolean isBark, double upperFreqInHz) throws IOException {
        LsfFileHeader lsfParams;
        if (!FileUtils.exists(item1.lsfFile)) {
            lsfParams = new LsfFileHeader();
            BaselineFeatureExtractor.lsfAnalysis(item1, lsfParams, true);
        }
        if (!FileUtils.exists(item2.lsfFile)) {
            lsfParams = new LsfFileHeader();
            BaselineFeatureExtractor.lsfAnalysis(item2, lsfParams, true);
        }
        Lsfs lsfs1 = new Lsfs(item1.lsfFile);
        Lsfs lsfs2 = new Lsfs(item2.lsfFile);
        Labels labs1 = new Labels(item1.labelFile);
        Labels labs2 = new Labels(item2.labelFile);
        double[] frameDistances = null;
        int count = 0;
        if (labs1.items == null || labs2.items == null) {
            throw new IOException("Do not have labels for pair " + StringUtils.getFileName(item1.audioFile));
        }
        AlignedLabels aligned = this.aligner.alignLabels(labs1, labs2);
        assert (aligned != null);
        frameDistances = new double[Math.max(lsfs1.params.numfrm, lsfs2.params.numfrm)];
        int frameSeen1 = -1;
        int frameSeen2 = -1;
        block0: for (AlignedLabels.AlignedTimeStretch ats : aligned.getAlignedTimeStretches()) {
            int toIndex;
            int fromIndex;
            boolean firstIsShorter;
            boolean bl = firstIsShorter = ats.firstDuration <= ats.secondDuration;
            if (firstIsShorter) {
                fromIndex = SignalProcUtils.time2frameIndex(ats.firstStart, (double)lsfs1.params.winsize, (double)lsfs1.params.skipsize);
                if (fromIndex < 0) {
                    fromIndex = 0;
                }
                if (frameSeen1 >= fromIndex) {
                    fromIndex = frameSeen1 + 1;
                }
                if ((toIndex = SignalProcUtils.time2frameIndex(ats.firstStart + ats.firstDuration, (double)lsfs1.params.winsize, (double)lsfs1.params.skipsize)) >= lsfs1.lsfs.length) break;
                for (int f1 = fromIndex; f1 <= toIndex; ++f1) {
                    int f2;
                    double t1 = SignalProcUtils.frameIndex2Time(f1, lsfs1.params.winsize, lsfs1.params.skipsize);
                    double t2 = aligned.mapTimeFromFirstToSecond(t1);
                    if (this.isInitialOrFinalSilence(t1, labs1, this.silenceSymbol) || this.isInitialOrFinalSilence(t2, labs2, this.silenceSymbol) || (f2 = SignalProcUtils.time2frameIndex(t2, (double)lsfs2.params.winsize, (double)lsfs2.params.skipsize)) <= frameSeen2) continue;
                    if (f2 >= lsfs2.lsfs.length) continue block0;
                    frameDistances[count++] = this.computeOneFrameDistance(lsfs1.lsfs[f1], lsfs2.lsfs[f2], isBark, upperFreqInHz);
                    frameSeen1 = f1;
                    frameSeen2 = f2;
                }
                continue;
            }
            fromIndex = SignalProcUtils.time2frameIndex(ats.secondStart, (double)lsfs2.params.winsize, (double)lsfs2.params.skipsize);
            if (fromIndex < 0) {
                fromIndex = 0;
            }
            if (frameSeen2 >= fromIndex) {
                fromIndex = frameSeen2 + 1;
            }
            if ((toIndex = SignalProcUtils.time2frameIndex(ats.secondStart + ats.secondDuration, (double)lsfs2.params.winsize, (double)lsfs2.params.skipsize)) >= lsfs2.lsfs.length) break;
            for (int f2 = fromIndex; f2 <= toIndex; ++f2) {
                int f1;
                double t2 = SignalProcUtils.frameIndex2Time(f2, lsfs2.params.winsize, lsfs2.params.skipsize);
                double t1 = aligned.mapTimeFromSecondToFirst(t2);
                if (this.isInitialOrFinalSilence(t1, labs1, this.silenceSymbol) || this.isInitialOrFinalSilence(t2, labs2, this.silenceSymbol) || (f1 = SignalProcUtils.time2frameIndex(t1, (double)lsfs1.params.winsize, (double)lsfs1.params.skipsize)) <= frameSeen1) continue;
                if (f1 >= lsfs1.lsfs.length) continue block0;
                frameDistances[count++] = this.computeOneFrameDistance(lsfs1.lsfs[f1], lsfs2.lsfs[f2], isBark, upperFreqInHz);
                frameSeen1 = f1;
                frameSeen2 = f2;
            }
        }
        if (count > 0) {
            double[] tmpFrameDistances = frameDistances;
            frameDistances = new double[count];
            System.arraycopy(tmpFrameDistances, 0, frameDistances, 0, count);
        }
        return frameDistances;
    }

    public static void mainParametricInterspeech2008(String method, String emotion, boolean isBark) throws IOException {
        String baseDir = "D:/Oytun/DFKI/voices/Interspeech08_out/objective_test/";
        String tgtFolder = baseDir + "target/" + emotion;
        String srcFolder = baseDir + "source/" + emotion;
        String tfmFolder = baseDir + method + "/" + emotion;
        String outputFile = baseDir + method + "_" + emotion + "_rmsLsf.txt";
        RmsLsfDistortionComputer r = new RmsLsfDistortionComputer();
        double[] distances1 = r.getDistances(tgtFolder, srcFolder, isBark, 8000.0);
        double[] distances2 = r.getDistances(tgtFolder, tfmFolder, isBark, 8000.0);
        double m1 = MathUtils.mean(distances1);
        double s1 = MathUtils.standardDeviation(distances1, m1);
        double m2 = MathUtils.mean(distances2);
        double s2 = MathUtils.standardDeviation(distances2, m2);
        double conf95_1 = MathUtils.getConfidenceInterval95(s1);
        double conf99_1 = MathUtils.getConfidenceInterval99(s1);
        double conf95_2 = MathUtils.getConfidenceInterval95(s2);
        double conf99_2 = MathUtils.getConfidenceInterval99(s2);
        double[] tmpOut = new double[distances1.length + distances2.length + 9];
        tmpOut[0] = m1;
        tmpOut[1] = s1;
        tmpOut[2] = m2;
        tmpOut[3] = s2;
        tmpOut[4] = m1 - m2;
        tmpOut[5] = conf95_1;
        tmpOut[6] = conf99_1;
        tmpOut[7] = conf95_2;
        tmpOut[8] = conf99_2;
        System.arraycopy(distances1, 0, tmpOut, 9, distances1.length);
        System.arraycopy(distances2, 0, tmpOut, distances1.length + 9, distances2.length);
        FileUtils.writeToTextFile(tmpOut, outputFile);
        double c1Left95 = m1 - conf95_1;
        double c1Left99 = m1 - conf99_1;
        double c1Right95 = m1 + conf95_1;
        double c1Right99 = m1 + conf99_1;
        double c2Left95 = m2 - conf95_2;
        double c2Left99 = m2 - conf99_2;
        double c2Right95 = m2 + conf95_2;
        double c2Right99 = m2 + conf99_2;
        System.out.println(method + " " + emotion + " tgt-src: MeanDist=" + String.valueOf(m1) + " " + "StdDist=" + String.valueOf(s1));
        System.out.println(method + " " + emotion + " tgt-tfm: MeanDist=" + String.valueOf(m2) + " " + "StdDist=" + String.valueOf(s2));
        System.out.println(method + " " + emotion + " distance reduction=" + String.valueOf(m1 - m2));
        System.out.println("Confidence intervals tgt-src %95:  " + String.valueOf(conf95_1) + " --> [" + String.valueOf(c1Left95) + "," + String.valueOf(c1Right95) + "]");
        System.out.println("Confidence intervals tgt-src %99:  " + String.valueOf(conf99_1) + " --> [" + String.valueOf(c1Left99) + "," + String.valueOf(c1Right99) + "]");
        System.out.println("Confidence intervals tgt-tfm %95:  " + String.valueOf(conf95_2) + " --> [" + String.valueOf(c2Left95) + "," + String.valueOf(c2Right95) + "]");
        System.out.println("Confidence intervals tgt-tfm %99:  " + String.valueOf(conf99_2) + " --> [" + String.valueOf(c2Left99) + "," + String.valueOf(c2Right99) + "]");
        System.out.println("---------------------------------");
    }

    public static void mainInterspeech2008() throws IOException {
        boolean isBark = true;
        String method = "1_codebook";
        String emotion = "angry";
        RmsLsfDistortionComputer.mainParametricInterspeech2008(method, emotion, isBark);
        emotion = "happy";
        RmsLsfDistortionComputer.mainParametricInterspeech2008(method, emotion, isBark);
        emotion = "sad";
        RmsLsfDistortionComputer.mainParametricInterspeech2008(method, emotion, isBark);
        emotion = "all";
        RmsLsfDistortionComputer.mainParametricInterspeech2008(method, emotion, isBark);
        method = "2_frame";
        emotion = "angry";
        RmsLsfDistortionComputer.mainParametricInterspeech2008(method, emotion, isBark);
        emotion = "happy";
        RmsLsfDistortionComputer.mainParametricInterspeech2008(method, emotion, isBark);
        emotion = "sad";
        RmsLsfDistortionComputer.mainParametricInterspeech2008(method, emotion, isBark);
        emotion = "all";
        RmsLsfDistortionComputer.mainParametricInterspeech2008(method, emotion, isBark);
        method = "3_gmm";
        emotion = "angry";
        RmsLsfDistortionComputer.mainParametricInterspeech2008(method, emotion, isBark);
        emotion = "happy";
        RmsLsfDistortionComputer.mainParametricInterspeech2008(method, emotion, isBark);
        emotion = "sad";
        RmsLsfDistortionComputer.mainParametricInterspeech2008(method, emotion, isBark);
        emotion = "all";
        RmsLsfDistortionComputer.mainParametricInterspeech2008(method, emotion, isBark);
        System.out.println("Objective test completed...");
    }

    public static void mainHmmVoiceConversion(String method1, String method2, String folder1, String folder2, String referenceFolder, String outputFile, boolean isBark) throws IOException {
        RmsLsfDistortionComputer r = new RmsLsfDistortionComputer();
        double[] distances1 = r.getDistances(referenceFolder, folder1, isBark, 8000.0);
        double[] distances2 = r.getDistances(referenceFolder, folder2, isBark, 8000.0);
        double m1 = MathUtils.mean(distances1);
        double s1 = MathUtils.standardDeviation(distances1, m1);
        double m2 = MathUtils.mean(distances2);
        double s2 = MathUtils.standardDeviation(distances2, m2);
        double conf95_1 = MathUtils.getConfidenceInterval95(s1);
        double conf99_1 = MathUtils.getConfidenceInterval99(s1);
        double conf95_2 = MathUtils.getConfidenceInterval95(s2);
        double conf99_2 = MathUtils.getConfidenceInterval99(s2);
        double[] tmpOut = new double[distances1.length + distances2.length + 9];
        tmpOut[0] = m1;
        tmpOut[1] = s1;
        tmpOut[2] = m2;
        tmpOut[3] = s2;
        tmpOut[4] = m1 - m2;
        tmpOut[5] = conf95_1;
        tmpOut[6] = conf99_1;
        tmpOut[7] = conf95_2;
        tmpOut[8] = conf99_2;
        System.arraycopy(distances1, 0, tmpOut, 9, distances1.length);
        System.arraycopy(distances2, 0, tmpOut, distances1.length + 9, distances2.length);
        FileUtils.writeToTextFile(tmpOut, outputFile);
        double c1Left95 = m1 - conf95_1;
        double c1Left99 = m1 - conf99_1;
        double c1Right95 = m1 + conf95_1;
        double c1Right99 = m1 + conf99_1;
        double c2Left95 = m2 - conf95_2;
        double c2Left99 = m2 - conf99_2;
        double c2Right95 = m2 + conf95_2;
        double c2Right99 = m2 + conf99_2;
        System.out.println(method1 + " tgt-src: MeanDist=" + String.valueOf(m1) + " " + "StdDist=" + String.valueOf(s1));
        System.out.println(method2 + " tgt-tfm: MeanDist=" + String.valueOf(m2) + " " + "StdDist=" + String.valueOf(s2));
        System.out.println("Distance reduction=" + String.valueOf(m1 - m2));
        System.out.println("Confidence intervals reference-method1 %95:  " + String.valueOf(conf95_1) + " --> [" + String.valueOf(c1Left95) + "," + String.valueOf(c1Right95) + "]");
        System.out.println("Confidence intervals reference-method1 %99:  " + String.valueOf(conf99_1) + " --> [" + String.valueOf(c1Left99) + "," + String.valueOf(c1Right99) + "]");
        System.out.println("Confidence intervals reference-method2 %95:  " + String.valueOf(conf95_2) + " --> [" + String.valueOf(c2Left95) + "," + String.valueOf(c2Right95) + "]");
        System.out.println("Confidence intervals reference-method2 %99:  " + String.valueOf(conf99_2) + " --> [" + String.valueOf(c2Left99) + "," + String.valueOf(c2Right99) + "]");
        System.out.println("---------------------------------");
    }

    public static void mainHmmVoiceConversion() throws IOException {
        String baseInputFolder = "D:/Oytun/DFKI/voices/hmmVoiceConversionTest2/output/final/";
        String baseOutputFolder = "D:/Oytun/DFKI/voices/hmmVoiceConversionTest2/objective_test/";
        boolean isBark = true;
        String referenceFolder = "D:/Oytun/DFKI/voices/hmmVoiceConversionTest2/output/final/origTarget";
        String method1 = "NOGV";
        String method2 = "GV";
        String folder1 = baseInputFolder + "hmmSource_nogv";
        String folder2 = baseInputFolder + "hmmSource_gv";
        String outputFile = baseOutputFolder + "lsf_" + method1 + "_" + method2 + ".txt";
        RmsLsfDistortionComputer.mainHmmVoiceConversion(method1, method2, folder1, folder2, referenceFolder, outputFile, isBark);
        method1 = "NOGV";
        method2 = "NOGV+SC";
        folder1 = baseInputFolder + "hmmSource_nogv";
        folder2 = baseInputFolder + "tfm_nogv_1092files_128mixes";
        outputFile = baseOutputFolder + "lsf_" + method1 + "_" + method2 + ".txt";
        RmsLsfDistortionComputer.mainHmmVoiceConversion(method1, method2, folder1, folder2, referenceFolder, outputFile, isBark);
        method1 = "GV";
        method2 = "GV+SC";
        folder1 = baseInputFolder + "hmmSource_gv";
        folder2 = baseInputFolder + "tfm_gv_1092files_128mixes";
        outputFile = baseOutputFolder + "lsf_" + method1 + "_" + method2 + ".txt";
        RmsLsfDistortionComputer.mainHmmVoiceConversion(method1, method2, folder1, folder2, referenceFolder, outputFile, isBark);
        System.out.println("Objective test completed...");
    }

    public void mainDistancesPerFile(String folder1, String folder2) throws IOException {
        long startTime = System.currentTimeMillis();
        RmsLsfDistortionComputer r = new RmsLsfDistortionComputer();
        folder1 = StringUtils.checkLastSlash(folder1);
        folder2 = StringUtils.checkLastSlash(folder2);
        BaselineAdaptationSet set1 = new BaselineAdaptationSet(folder1);
        BaselineAdaptationSet set2 = new BaselineAdaptationSet(folder2);
        boolean isBark = true;
        double upperFreqInHz = 8000.0;
        int[] map = new int[set1.items.length];
        for (int i = 0; i < map.length; ++i) {
            if (!StringUtils.getFileName(set1.items[i].audioFile).equals(StringUtils.getFileName(set2.items[i].audioFile))) {
                throw new IOException("Audio files in folders do not match:\n" + set1.items[i].audioFile + " doesn't match " + set2.items[i].audioFile);
            }
            map[i] = i;
        }
        double[][] allDistances = r.getDistancesPerFile(set1, set2, isBark, upperFreqInHz, map);
        assert (allDistances.length == map.length);
        System.out.println("RMSE Bark-scaled LSF distances between " + folder1 + " and " + folder2);
        double allMean = 0.0;
        double allPrevMean = 0.0;
        double allVariance = 0.0;
        long allN = 0L;
        for (int i = 0; i < map.length; ++i) {
            double oneMean = 0.0;
            double onePrevMean = 0.0;
            double oneVariance = 0.0;
            int oneN = 0;
            for (int j = 0; j < allDistances[i].length; ++j) {
                double x = allDistances[i][j];
                allPrevMean = allMean;
                allVariance += (x - allPrevMean) * (x - (allMean += (x - allPrevMean) / (double)(++allN)));
                onePrevMean = oneMean;
                oneVariance += (x - onePrevMean) * (x - (oneMean += (x - onePrevMean) / (double)(++oneN)));
            }
            double oneStddev = Math.sqrt(oneVariance / (double)oneN);
            System.out.println(StringUtils.getFileName(set1.items[i].audioFile) + " mean " + oneMean + " stddev " + oneStddev);
        }
        double allStddev = Math.sqrt(allVariance / (double)allN);
        System.out.println("Global mean " + allMean + " stddev " + allStddev);
        long timeNeeded = System.currentTimeMillis() - startTime;
        System.err.println("Computed distances between " + map.length + " files in " + timeNeeded + " ms");
    }

    public static void main(String[] args) throws Exception {
        new RmsLsfDistortionComputer().mainDistancesPerFile(args[0], args[1]);
    }
}

