/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import java.io.File;
import java.io.FileReader;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.signalproc.Defaults;
import marytts.signalproc.analysis.FrameBasedAnalyser;
import marytts.signalproc.analysis.LpcAnalyser;
import marytts.signalproc.analysis.PitchFrameAnalyser;
import marytts.util.data.DoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.text.ESTTextfileDoubleDataSource;

public class LpcPitchSynchronousAnalyser
extends PitchFrameAnalyser {
    public static int lpOrder = 0;

    public LpcPitchSynchronousAnalyser(DoubleDataSource signal, DoubleDataSource pitchmarks, int windowType, int samplingRate) {
        super(signal, pitchmarks, windowType, samplingRate);
    }

    public LpcPitchSynchronousAnalyser(DoubleDataSource signal, DoubleDataSource pitchmarks, int windowType, int samplingRate, int framePeriods, int shiftPeriods) {
        super(signal, pitchmarks, windowType, samplingRate, framePeriods, shiftPeriods);
    }

    @Override
    public Object analyse(double[] frame) {
        int expectedFrameLength = 0;
        for (int i = 0; i < this.periodLengths.length; ++i) {
            expectedFrameLength += this.periodLengths[i];
        }
        if (frame.length != expectedFrameLength) {
            System.err.println("Expected frame of length " + expectedFrameLength + "(" + this.periodLengths.length + " periods)" + ", got " + frame.length);
        }
        return LpcAnalyser.calcLPC(frame, lpOrder);
    }

    public static void main(String[] args) throws Exception {
        File audioFile = new File(args[0]);
        File pitchmarkFile = new File(args[1]);
        AudioInputStream ais = AudioSystem.getAudioInputStream(audioFile);
        int samplingRate = (int)ais.getFormat().getSampleRate();
        AudioDoubleDataSource signal = new AudioDoubleDataSource(ais);
        ESTTextfileDoubleDataSource pitchmarks = new ESTTextfileDoubleDataSource(new FileReader(pitchmarkFile));
        int windowType = Defaults.getWindowType();
        int fftSize = Defaults.getFFTSize();
        int p = Integer.getInteger("signalproc.lpcorder", 24);
        LpcPitchSynchronousAnalyser pla = new LpcPitchSynchronousAnalyser((DoubleDataSource)signal, (DoubleDataSource)pitchmarks, windowType, samplingRate, 2, 1);
        FrameBasedAnalyser.FrameAnalysisResult[] far = pla.analyseAllFrames();
        for (int i = 0; i < far.length; ++i) {
            LpcAnalyser.LpCoeffs coeffs = (LpcAnalyser.LpCoeffs)far[i].get();
            System.out.print(far[i].getStartTime() + ": gain " + coeffs.getGain() + ", coffs: ");
            for (int j = 0; j < coeffs.getOrder(); ++j) {
                System.out.print(coeffs.getA(j) + "  ");
            }
            System.out.println();
        }
    }
}

