/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.adaptation.prosody;

import java.util.Arrays;
import marytts.signalproc.adaptation.prosody.PitchStatistics;
import marytts.signalproc.adaptation.prosody.PitchStatisticsCollection;
import marytts.util.math.MathUtils;

public class PitchStatisticsMapping {
    public PitchStatistics sourceGlobalStatisticsHz;
    public PitchStatistics targetGlobalStatisticsHz;
    public PitchStatisticsCollection sourceLocalStatisticsHz;
    public PitchStatisticsCollection targetLocalStatisticsHz;
    public PitchStatistics sourceGlobalStatisticsLogHz;
    public PitchStatistics targetGlobalStatisticsLogHz;
    public PitchStatisticsCollection sourceLocalStatisticsLogHz;
    public PitchStatisticsCollection targetLocalStatisticsLogHz;
    public double[] sourceVariancesHz;
    public double[] targetVariancesHz;
    public double[] sourceVariancesLogHz;
    public double[] targetVariancesLogHz;

    public PitchStatisticsMapping(PitchStatisticsCollection allFromTraining) {
        Object tmpCollection = null;
        this.sourceGlobalStatisticsHz = new PitchStatistics(allFromTraining.getGlobalStatisticsSourceHz());
        this.targetGlobalStatisticsHz = new PitchStatistics(allFromTraining.getGlobalStatisticsTargetHz());
        this.sourceLocalStatisticsHz = new PitchStatisticsCollection(allFromTraining.getLocalStatisticsSourceHz());
        this.targetLocalStatisticsHz = new PitchStatisticsCollection(allFromTraining.getLocalStatisticsTargetHz());
        this.sourceVariancesHz = this.setVariances(this.sourceLocalStatisticsHz);
        this.targetVariancesHz = this.setVariances(this.targetLocalStatisticsHz);
        this.sourceGlobalStatisticsLogHz = new PitchStatistics(allFromTraining.getGlobalStatisticsSourceLogHz());
        this.targetGlobalStatisticsLogHz = new PitchStatistics(allFromTraining.getGlobalStatisticsTargetLogHz());
        this.sourceLocalStatisticsLogHz = new PitchStatisticsCollection(allFromTraining.getLocalStatisticsSourceLogHz());
        this.targetLocalStatisticsLogHz = new PitchStatisticsCollection(allFromTraining.getLocalStatisticsTargetLogHz());
        this.sourceVariancesLogHz = this.setVariances(this.sourceLocalStatisticsLogHz);
        this.targetVariancesLogHz = this.setVariances(this.targetLocalStatisticsLogHz);
    }

    private double[] setVariances(PitchStatisticsCollection p) {
        double[] variances = new double[5];
        if (p.entries != null) {
            if (p.entries.length < 2) {
                Arrays.fill(variances, 1.0);
            } else {
                int j;
                double[][] vals = new double[variances.length][];
                for (int i = 0; i < variances.length; ++i) {
                    vals[i] = new double[p.entries.length];
                }
                for (j = 0; j < p.entries.length; ++j) {
                    vals[0][j] = p.entries[j].mean;
                }
                for (j = 0; j < p.entries.length; ++j) {
                    vals[1][j] = p.entries[j].standardDeviation;
                }
                for (j = 0; j < p.entries.length; ++j) {
                    vals[2][j] = p.entries[j].range;
                }
                for (j = 0; j < p.entries.length; ++j) {
                    vals[3][j] = p.entries[j].intercept;
                }
                for (j = 0; j < p.entries.length; ++j) {
                    vals[4][j] = p.entries[j].slope;
                }
                variances = MathUtils.getVarianceRows(vals);
            }
        }
        return variances;
    }
}

