/*
 * Decompiled with CFR 0.152.
 */
package marytts.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import marytts.datatypes.MaryData;
import marytts.datatypes.MaryDataType;
import marytts.datatypes.MaryXML;
import marytts.modules.MaryModule;
import marytts.modules.ModuleRegistry;
import marytts.modules.synthesis.Voice;
import marytts.server.Mary;
import marytts.server.MaryProperties;
import marytts.util.MaryCache;
import marytts.util.MaryRuntimeUtils;
import marytts.util.MaryUtils;
import marytts.util.data.audio.AppendableSequenceAudioInputStream;
import marytts.util.dom.DomUtils;
import marytts.util.dom.MaryDomUtils;
import marytts.util.dom.NameNodeFilter;
import marytts.util.io.FileUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.TreeWalker;

public class Request {
    protected MaryDataType inputType;
    protected MaryDataType outputType;
    protected String outputTypeParams;
    protected AudioFileFormat audioFileFormat;
    protected AppendableSequenceAudioInputStream appendableAudioStream;
    protected Locale defaultLocale;
    protected Voice defaultVoice;
    protected String defaultStyle;
    protected String defaultEffects;
    protected int id;
    protected Logger logger;
    protected MaryData inputData;
    protected MaryData outputData;
    protected boolean streamAudio = false;
    protected boolean abortRequested = false;
    protected Set<MaryModule> usedModules;
    protected Map<MaryModule, Long> timingInfo;

    public Request(MaryDataType inputType, MaryDataType outputType, Locale defaultLocale, Voice defaultVoice, String defaultEffects, String defaultStyle, int id, AudioFileFormat audioFileFormat) {
        this(inputType, outputType, defaultLocale, defaultVoice, defaultEffects, defaultStyle, id, audioFileFormat, false, null);
    }

    public Request(MaryDataType inputType, MaryDataType outputType, Locale defaultLocale, Voice defaultVoice, String defaultEffects, String defaultStyle, int id, AudioFileFormat audioFileFormat, boolean streamAudio, String outputTypeParams) {
        if (!inputType.isInputType()) {
            throw new IllegalArgumentException("not an input type: " + inputType.name());
        }
        if (!outputType.isOutputType()) {
            throw new IllegalArgumentException("not an output type: " + outputType.name());
        }
        this.inputType = inputType;
        this.outputType = outputType;
        this.defaultLocale = defaultLocale;
        this.defaultVoice = defaultVoice;
        this.defaultEffects = defaultEffects;
        this.defaultStyle = defaultStyle;
        this.id = id;
        this.audioFileFormat = audioFileFormat;
        this.streamAudio = streamAudio;
        if (outputType == MaryDataType.get("AUDIO")) {
            if (audioFileFormat == null) {
                throw new NullPointerException("audio file format is needed for output type AUDIO");
            }
            this.appendableAudioStream = new AppendableSequenceAudioInputStream(audioFileFormat.getFormat(), null);
        } else {
            this.appendableAudioStream = null;
        }
        this.logger = MaryUtils.getLogger("R " + id);
        this.outputTypeParams = outputTypeParams;
        this.inputData = null;
        this.outputData = null;
        StringBuilder info = new StringBuilder("New request (input type \"" + inputType.name() + "\", output type \"" + outputType.name());
        if (this.defaultVoice != null) {
            info.append("\", voice \"" + this.defaultVoice.getName());
        }
        if (this.defaultEffects != null && this.defaultEffects != "") {
            info.append("\", effect \"" + this.defaultEffects);
        }
        if (this.defaultStyle != null && this.defaultStyle != "") {
            info.append("\", style \"" + this.defaultStyle);
        }
        if (audioFileFormat != null) {
            info.append("\", audio \"" + audioFileFormat.getType().toString() + "\"");
        }
        if (streamAudio) {
            info.append(", streaming");
        }
        info.append(")");
        this.logger.info(info.toString());
        this.usedModules = new LinkedHashSet<MaryModule>();
        this.timingInfo = new HashMap<MaryModule, Long>();
    }

    public MaryDataType getInputType() {
        return this.inputType;
    }

    public MaryDataType getOutputType() {
        return this.outputType;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public Voice getDefaultVoice() {
        return this.defaultVoice;
    }

    public String getDefaultStyle() {
        return this.defaultStyle;
    }

    public String getDefaultEffects() {
        return this.defaultEffects;
    }

    public int getId() {
        return this.id;
    }

    public AudioFileFormat getAudioFileFormat() {
        return this.audioFileFormat;
    }

    public AppendableSequenceAudioInputStream getAudio() {
        return this.appendableAudioStream;
    }

    public boolean getStreamAudio() {
        return this.streamAudio;
    }

    public void abort() {
        this.logger.info("Requesting abort.");
        this.abortRequested = true;
    }

    public void setInputData(MaryData inputData) {
        if (inputData != null && inputData.getType() != this.inputType) {
            throw new IllegalArgumentException("Input data has wrong data type (expected " + this.inputType.toString() + ", got " + inputData.getType().toString());
        }
        if (this.defaultVoice == null) {
            this.defaultVoice = Voice.getSuitableVoice(inputData);
        }
        if (inputData.getDefaultVoice() == null) {
            inputData.setDefaultVoice(this.defaultVoice);
        }
        inputData.setDefaultStyle(this.defaultStyle);
        inputData.setDefaultEffects(this.defaultEffects);
        this.inputData = inputData;
    }

    public void readInputData(Reader inputReader) throws Exception {
        String inputText = FileUtils.getReaderAsString(inputReader);
        this.setInputData(inputText);
    }

    public void setInputData(String inputText) throws Exception {
        this.inputData = new MaryData(this.inputType, this.defaultLocale);
        this.inputData.setWarnClient(true);
        if (this.inputType == MaryDataType.get("RAWMARYXML")) {
            this.inputData.setValidating(false);
        } else if (this.inputType.isMaryXML()) {
            this.inputData.setValidating(MaryProperties.getBoolean("maryxml.validate.input"));
        }
        this.inputData.setData(inputText);
        if (this.defaultVoice == null) {
            this.defaultVoice = Voice.getSuitableVoice(this.inputData);
        }
        this.inputData.setDefaultVoice(this.defaultVoice);
        this.inputData.setDefaultStyle(this.defaultStyle);
        this.inputData.setDefaultEffects(this.defaultEffects);
    }

    public void process() throws Exception {
        NodeList inputDataList;
        MaryData rawmaryxml;
        assert (Mary.currentState() == 2);
        long startTime = System.currentTimeMillis();
        if (this.inputData == null) {
            throw new NullPointerException("Input data is not set.");
        }
        if (this.inputType.isXMLType() && this.inputData.getDocument() == null) {
            throw new NullPointerException("Input data contains no XML document.");
        }
        if (this.inputType.isMaryXML() && !this.inputData.getDocument().getDocumentElement().hasAttribute("xml:lang")) {
            throw new IllegalArgumentException("Mandatory attribute xml:lang is missing from maryxml document element.");
        }
        if (this.outputType.name().equals("PRAAT_TEXTGRID")) {
            this.outputData = this.processOrLookupOneChunk(this.inputData, this.outputType, this.outputTypeParams);
            return;
        }
        if (this.inputType.isTextType() && this.inputType.name().startsWith("TEXT") || this.inputType.isXMLType() && !this.inputType.isMaryXML()) {
            rawmaryxml = this.processOrLookupOneChunk(this.inputData, MaryDataType.get("RAWMARYXML"), null);
            inputDataList = this.splitIntoChunks(rawmaryxml);
        } else if (this.inputType.equals(MaryDataType.get("RAWMARYXML"))) {
            rawmaryxml = this.inputData;
            inputDataList = this.splitIntoChunks(this.inputData);
        } else {
            this.outputData = this.processOrLookupOneChunk(this.inputData, this.outputType, this.outputTypeParams);
            if (this.outputType == MaryDataType.AUDIO) {
                assert (this.appendableAudioStream != null);
                this.appendableAudioStream.append(this.outputData.getAudio());
                this.appendableAudioStream.doneAppending();
            }
            return;
        }
        assert (rawmaryxml != null && rawmaryxml.getType().equals(MaryDataType.get("RAWMARYXML")) && rawmaryxml.getDocument() != null);
        Request.moveBoundariesIntoParagraphs(rawmaryxml.getDocument());
        this.outputData = new MaryData(this.outputType, this.defaultLocale);
        this.outputData.setDefaultVoice(this.defaultVoice);
        this.outputData.setDefaultStyle(this.defaultStyle);
        this.outputData.setDefaultEffects(this.defaultEffects);
        if (this.outputType.isMaryXML()) {
            this.outputData.setDocument(rawmaryxml.getDocument());
        } else if (this.outputType.equals(MaryDataType.get("AUDIO"))) {
            this.outputData.setAudio(this.appendableAudioStream);
            this.outputData.setAudioFileFormat(this.audioFileFormat);
        }
        int len = inputDataList.getLength();
        for (int i = 0; i < len && !this.abortRequested; ++i) {
            Element currentInputParagraph = (Element)inputDataList.item(i);
            assert (currentInputParagraph.getTagName().equals("p"));
            NodeList outputNodeList = null;
            if (MaryDomUtils.getPlainTextBelow(currentInputParagraph).trim().equals("")) {
                outputNodeList = currentInputParagraph.getChildNodes();
            } else {
                MaryData oneInputData = Request.extractParagraphAsMaryData(rawmaryxml, currentInputParagraph);
                MaryData oneOutputData = this.processOrLookupOneChunk(oneInputData, this.outputType, this.outputTypeParams);
                if (this.outputType.isMaryXML()) {
                    NodeList outParagraphList;
                    outputNodeList = outParagraphList = oneOutputData.getDocument().getDocumentElement().getElementsByTagName("p");
                } else {
                    assert (this.outputData != null);
                    this.outputData.append(oneOutputData);
                }
            }
            if (!this.outputType.isMaryXML()) continue;
            assert (outputNodeList != null);
            MaryDomUtils.replaceElement(currentInputParagraph, outputNodeList);
        }
        long stopTime = System.currentTimeMillis();
        this.logger.info("Request processed in " + (stopTime - startTime) + " ms.");
        for (MaryModule m : this.usedModules) {
            this.logger.info("   " + m.name() + " took " + this.timingInfo.get(m) + " ms");
        }
        if (this.appendableAudioStream != null) {
            this.appendableAudioStream.doneAppending();
        }
    }

    private MaryData processOrLookupOneChunk(MaryData oneInputData, MaryDataType oneOutputType, String outputParams) throws TransformerConfigurationException, FileNotFoundException, TransformerException, IOException, Exception {
        if (this.logger.getEffectiveLevel().equals(Level.DEBUG) && (oneInputData.getType().isTextType() || oneInputData.getType().isXMLType())) {
            this.logger.debug("Now converting the following input data from " + oneInputData.getType() + " to " + oneOutputType + ":");
            ByteArrayOutputStream dummy = new ByteArrayOutputStream();
            oneInputData.writeTo(dummy);
        }
        Locale locale = this.determineLocale(oneInputData);
        assert (locale != null);
        MaryCache cache = null;
        if (MaryProperties.getBoolean("cache")) {
            cache = MaryCache.getCache();
        }
        if (cache == null) {
            return this.processOneChunk(oneInputData, oneOutputType, outputParams, locale);
        }
        String inputtype = null;
        String outputtype = null;
        String localeString = null;
        String voice = null;
        String inputtext = null;
        inputtype = oneInputData.getType().name();
        outputtype = oneOutputType.name();
        ByteArrayOutputStream sw = new ByteArrayOutputStream();
        oneInputData.writeTo(sw);
        inputtext = new String(sw.toByteArray(), "UTF-8");
        voice = this.defaultVoice != null ? this.defaultVoice.getName() : null;
        localeString = locale.toString();
        if (oneOutputType.isTextType()) {
            try {
                String outputtext = cache.lookupText(inputtype, outputtype, localeString, voice, outputParams, this.defaultStyle, this.defaultEffects, inputtext);
                if (outputtext != null) {
                    MaryData outData = new MaryData(oneOutputType, locale);
                    ByteArrayInputStream sr = new ByteArrayInputStream(outputtext.getBytes());
                    outData.readFrom(sr);
                    sr.close();
                    outData.setDefaultVoice(this.defaultVoice);
                    outData.setDefaultStyle(this.defaultStyle);
                    outData.setDefaultEffects(this.defaultEffects);
                    return outData;
                }
            }
            catch (Exception e) {
                this.logger.warn("Problem looking up text in cache", e);
            }
        } else if (outputtype.equals("AUDIO")) {
            try {
                byte[] wavFileData = cache.lookupAudio(inputtype, localeString, voice, outputParams, this.defaultStyle, this.defaultEffects, inputtext);
                if (wavFileData != null) {
                    AudioInputStream ais = AudioSystem.getAudioInputStream(new ByteArrayInputStream(wavFileData));
                    MaryData outData = new MaryData(oneOutputType, locale);
                    outData.setAudio(ais);
                    outData.setAudioFileFormat(this.audioFileFormat);
                    return outData;
                }
            }
            catch (Exception e) {
                this.logger.warn("Problem looking up audio in cache", e);
            }
        }
        if (oneOutputType.equals(MaryDataType.AUDIO) || oneOutputType.equals(MaryDataType.REALISED_ACOUSTPARAMS) || oneOutputType.equals(MaryDataType.REALISED_DURATIONS)) {
            MaryData audioData = this.processOneChunk(oneInputData, MaryDataType.AUDIO, outputParams, locale);
            MaryData realisedAcoustparams = this.processOneChunk(audioData, MaryDataType.REALISED_ACOUSTPARAMS, outputParams, locale);
            MaryData realisedDurations = this.processOneChunk(audioData, MaryDataType.REALISED_DURATIONS, outputParams, locale);
            this.insertAudioIntoCache(cache, inputtype, localeString, voice, outputParams, inputtext, audioData);
            this.insertTextIntoCache(cache, inputtype, MaryDataType.REALISED_ACOUSTPARAMS.name(), localeString, voice, outputParams, inputtext, realisedAcoustparams);
            this.insertTextIntoCache(cache, inputtype, MaryDataType.REALISED_DURATIONS.name(), localeString, voice, outputParams, inputtext, realisedDurations);
            if (oneOutputType.equals(MaryDataType.AUDIO)) {
                return audioData;
            }
            if (oneOutputType.equals(MaryDataType.REALISED_ACOUSTPARAMS)) {
                return realisedAcoustparams;
            }
            return realisedDurations;
        }
        MaryData oneOutputData = this.processOneChunk(oneInputData, oneOutputType, outputParams, locale);
        if (oneOutputType.isTextType()) {
            this.insertTextIntoCache(cache, inputtype, outputtype, localeString, voice, outputParams, inputtext, oneOutputData);
        } else {
            this.logger.debug("Don't know how to cache data of type '" + outputtype + "'");
        }
        return oneOutputData;
    }

    private void insertAudioIntoCache(MaryCache cache, String inputtype, String localeString, String voice, String outputParams, String inputtext, MaryData currentData) throws IOException, SQLException, UnsupportedAudioFileException {
        AppendableSequenceAudioInputStream as = (AppendableSequenceAudioInputStream)currentData.getAudio();
        assert (as != this.appendableAudioStream);
        as.doneAppending();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2 * (int)as.getFrameLength() + 100);
        AudioSystem.write((AudioInputStream)as, AudioFileFormat.Type.WAVE, baos);
        byte[] wavFileData = baos.toByteArray();
        cache.insertAudio(inputtype, localeString, voice, outputParams, this.defaultStyle, this.defaultEffects, inputtext, wavFileData);
        AudioInputStream ais = AudioSystem.getAudioInputStream(new ByteArrayInputStream(wavFileData));
        currentData.setAudio(ais);
    }

    private void insertTextIntoCache(MaryCache cache, String inputtype, String outputtype, String localeString, String voice, String outputParams, String inputtext, MaryData currentData) {
        try {
            ByteArrayOutputStream sw = new ByteArrayOutputStream();
            currentData.writeTo(sw);
            String outputtext = new String(sw.toByteArray(), "UTF-8");
            cache.insertText(inputtype, outputtype, localeString, voice, outputParams, this.defaultStyle, this.defaultEffects, inputtext, outputtext);
        }
        catch (Exception e) {
            this.logger.warn("Problem inserting text into cache", e);
        }
    }

    private MaryData processOneChunk(MaryData oneInputData, MaryDataType oneOutputType, String outputParams, Locale locale) throws Exception, TransformerConfigurationException, FileNotFoundException, TransformerException, IOException {
        this.logger.debug("Determining which modules to use");
        LinkedList<MaryModule> neededModules = ModuleRegistry.modulesRequiredForProcessing(oneInputData.getType(), oneOutputType, locale, oneInputData.getDefaultVoice());
        if (neededModules == null) {
            String message = "No known way of generating output from input -- no processing path through modules.";
            throw new UnsupportedOperationException(message);
        }
        this.usedModules.addAll(neededModules);
        this.logger.info("Handling request using the following modules:");
        for (MaryModule m : neededModules) {
            this.logger.info("- " + m.name() + " (" + m.getClass().getName() + ")");
        }
        MaryData currentData = oneInputData;
        for (MaryModule m : neededModules) {
            if (this.abortRequested) break;
            if (m.getState() == 0) {
                assert (MaryProperties.needProperty("server").compareTo("commandline") == 0);
                this.logger.info("Starting module " + m.name());
                m.startup();
                assert (m.getState() == 1);
            }
            long moduleStartTime = System.currentTimeMillis();
            if (m.outputType() == MaryDataType.get("AUDIO")) {
                currentData.setAudioFileFormat(this.audioFileFormat);
                currentData.setAudio(new AppendableSequenceAudioInputStream(this.audioFileFormat.getFormat(), null));
            }
            if (m.outputType() == oneOutputType || m.outputType() == MaryDataType.AUDIO) {
                currentData.setOutputParams(outputParams);
            }
            if (this.logger.getEffectiveLevel().equals(Level.DEBUG) && (currentData.getType().isTextType() || currentData.getType().isXMLType())) {
                this.logger.debug("Handing the following data to the next module:");
                ByteArrayOutputStream dummy = new ByteArrayOutputStream();
                currentData.writeTo(dummy);
            }
            this.logger.info("Next module: " + m.name());
            MaryData outData = null;
            try {
                outData = m.process(currentData);
            }
            catch (Exception e) {
                throw new Exception("Module " + m.name() + ": Problem processing the data.", e);
            }
            if (outData == null) {
                throw new NullPointerException("Module " + m.name() + " returned null. This should not happen.");
            }
            outData.setDefaultVoice(this.defaultVoice);
            outData.setDefaultStyle(this.defaultStyle);
            outData.setDefaultEffects(this.defaultEffects);
            currentData = outData;
            long moduleStopTime = System.currentTimeMillis();
            long delta = moduleStopTime - moduleStartTime;
            Long soFar = this.timingInfo.get(m);
            if (soFar != null) {
                this.timingInfo.put(m, new Long(soFar + delta));
            } else {
                this.timingInfo.put(m, new Long(delta));
            }
            if (!MaryRuntimeUtils.veryLowMemoryCondition()) continue;
            this.logger.info("Very low memory condition detected (only " + MaryUtils.availableMemory() + " bytes left). Triggering garbage collection.");
            Runtime.getRuntime().gc();
            this.logger.info("After garbage collection: " + MaryUtils.availableMemory() + " bytes available.");
        }
        if (currentData.getType() == MaryDataType.AUDIO) {
            AudioInputStream ais = currentData.getAudio();
            assert (ais != null);
            assert (ais instanceof AppendableSequenceAudioInputStream);
            ((AppendableSequenceAudioInputStream)ais).doneAppending();
        }
        return currentData;
    }

    private NodeList splitIntoChunks(MaryData rawmaryxml) {
        String last;
        String first;
        if (rawmaryxml == null) {
            throw new NullPointerException("Received null data");
        }
        if (rawmaryxml.getType() != MaryDataType.get("RAWMARYXML")) {
            throw new IllegalArgumentException("Expected data of type RAWMARYXML, got " + rawmaryxml.getType());
        }
        if (this.logger.getEffectiveLevel().equals(Level.DEBUG)) {
            this.logger.debug("Now splitting the following RAWMARYXML data into chunks:");
            ByteArrayOutputStream dummy = new ByteArrayOutputStream();
            try {
                rawmaryxml.writeTo(dummy);
            }
            catch (Exception ex) {
                this.logger.debug(ex);
            }
        }
        Document doc = rawmaryxml.getDocument();
        Element root = doc.getDocumentElement();
        TreeWalker tw = ((DocumentTraversal)((Object)doc)).createTreeWalker(root, 4, null, false);
        Node firstNode = null;
        Node lastNode = null;
        Node currentNode = null;
        while ((currentNode = tw.nextNode()) != null) {
            Text currentTextNode;
            if (currentNode.getNodeType() == 3 && (currentTextNode = (Text)currentNode).getData().trim().length() == 0) continue;
            if (!MaryDomUtils.hasAncestor(currentNode, "p")) {
                if (firstNode == null) {
                    firstNode = currentNode;
                }
                lastNode = currentNode;
                continue;
            }
            if (firstNode == null) continue;
            first = firstNode.getNodeType() == 3 ? ((Text)firstNode).getData() : firstNode.getNodeName();
            last = lastNode.getNodeType() == 3 ? ((Text)lastNode).getData() : lastNode.getNodeName();
            this.logger.debug("Found text node below paragraph; enclosing from '" + first + "' to '" + last + "'");
            MaryDomUtils.encloseNodesWithNewElement(firstNode, lastNode, "p");
            firstNode = null;
            lastNode = null;
        }
        if (firstNode != null) {
            first = firstNode.getNodeType() == 3 ? ((Text)firstNode).getData() : firstNode.getNodeName();
            last = lastNode.getNodeType() == 3 ? ((Text)lastNode).getData() : lastNode.getNodeName();
            this.logger.debug("Found text node below paragraph; enclosing from '" + first + "' to '" + last + "'");
            MaryDomUtils.encloseNodesWithNewElement(firstNode, lastNode, "p");
        }
        return doc.getElementsByTagName("p");
    }

    private static void moveBoundariesIntoParagraphs(Document rawmaryxml) {
        if (rawmaryxml == null) {
            throw new NullPointerException("Received null rawmaryxml");
        }
        TreeWalker paraTW = ((DocumentTraversal)((Object)rawmaryxml)).createTreeWalker(rawmaryxml.getDocumentElement(), 1, new NameNodeFilter("p"), true);
        TreeWalker tw = ((DocumentTraversal)((Object)rawmaryxml)).createTreeWalker(rawmaryxml.getDocumentElement(), 1, new NameNodeFilter("p", "boundary"), true);
        Element firstParagraph = (Element)paraTW.nextNode();
        if (firstParagraph == null) {
            throw new NullPointerException("Document does not have a paragraph");
        }
        tw.setCurrentNode(firstParagraph);
        Element boundary = null;
        while ((boundary = (Element)tw.previousNode()) != null) {
            assert (boundary.getTagName().equals("boundary"));
            firstParagraph.insertBefore(boundary, firstParagraph.getFirstChild());
            tw.setCurrentNode(firstParagraph);
        }
        tw.setCurrentNode(firstParagraph);
        Element paragraph = firstParagraph;
        Element current = null;
        while ((current = (Element)tw.nextNode()) != null) {
            if (current.getTagName().equals("p")) {
                paragraph = current;
                continue;
            }
            if (DomUtils.hasAncestor(current, "p")) continue;
            paragraph.appendChild(current);
        }
    }

    private static MaryData extractParagraphAsMaryData(MaryData maryxml, Element paragraph) {
        if (!maryxml.getType().isMaryXML()) {
            throw new IllegalArgumentException("Expected MaryXML data");
        }
        String rootLanguage = maryxml.getDocument().getDocumentElement().getAttribute("xml:lang");
        Document newDoc = MaryXML.newDocument();
        Element newRoot = newDoc.getDocumentElement();
        Element importedInner = (Element)newDoc.importNode(paragraph, true);
        Element toImport = (Element)paragraph.getParentNode();
        while (!toImport.getTagName().equals("maryxml")) {
            Element imported = (Element)newDoc.importNode(toImport, false);
            imported.appendChild(importedInner);
            importedInner = imported;
            toImport = (Element)toImport.getParentNode();
        }
        newRoot.appendChild(importedInner);
        String language = rootLanguage;
        Element voice = (Element)MaryDomUtils.getAncestor((Node)paragraph, "voice");
        if (voice != null) {
            String name;
            Voice v;
            if (voice.hasAttribute("xml:lang")) {
                language = voice.getAttribute("xml:lang");
            } else if (voice.hasAttribute("name") && (v = Voice.getVoice(name = voice.getAttribute("name"))) != null && v.getLocale() != null) {
                language = MaryUtils.locale2xmllang(v.getLocale());
            }
        }
        newRoot.setAttribute("xml:lang", language);
        MaryData md = new MaryData(maryxml.getType(), MaryUtils.string2locale(language));
        Voice dVoice = maryxml.getDefaultVoice();
        if (dVoice != null) {
            md.setDefaultVoice(dVoice);
        }
        md.setDocument(newDoc);
        return md;
    }

    private Locale determineLocale(MaryData data) {
        String langCode;
        Element docEl;
        Document doc;
        Locale locale = null;
        if (data.getType().isXMLType() && (doc = data.getDocument()) != null && (docEl = doc.getDocumentElement()) != null && !(langCode = docEl.getAttribute("xml:lang")).equals("")) {
            locale = MaryUtils.string2locale(langCode);
        }
        assert (this.defaultLocale != null);
        return locale != null ? locale : this.defaultLocale;
    }

    public MaryData getOutputData() {
        return this.outputData;
    }

    public void writeOutputData(OutputStream outputStream) throws Exception {
        if (this.outputData == null) {
            throw new NullPointerException("No output data -- did process() succeed?");
        }
        if (outputStream == null) {
            throw new NullPointerException("cannot write to null output stream");
        }
        final OutputStream os = outputStream;
        Timer timer = new Timer();
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                Request.this.logger.warn("Timeout occurred while writing output. Forcefully closing output stream.");
                try {
                    os.close();
                }
                catch (IOException ioe) {
                    Request.this.logger.warn(ioe);
                }
            }
        };
        int timeout = MaryProperties.getInteger("modules.timeout", 10000);
        if (this.outputType.equals(MaryDataType.get("AUDIO"))) {
            timeout *= 5;
        }
        timer.schedule(timerTask, timeout);
        try {
            this.outputData.writeTo(os);
        }
        catch (Exception e) {
            timer.cancel();
            throw e;
        }
        timer.cancel();
    }
}

