/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Locale;
import marytts.cart.CART;
import marytts.cart.io.MaryCARTReader;
import marytts.datatypes.MaryData;
import marytts.datatypes.MaryDataType;
import marytts.exceptions.SynthesisException;
import marytts.features.FeatureDefinition;
import marytts.features.FeatureProcessorManager;
import marytts.features.FeatureRegistry;
import marytts.features.TargetFeatureComputer;
import marytts.modules.InternalModule;
import marytts.modules.phonemiser.Allophone;
import marytts.modules.phonemiser.AllophoneSet;
import marytts.modules.synthesis.Voice;
import marytts.server.MaryProperties;
import marytts.unitselection.UnitSelectionVoice;
import marytts.unitselection.select.Target;
import marytts.util.MaryRuntimeUtils;
import marytts.util.MaryUtils;
import marytts.util.dom.MaryDomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;

public class CARTF0Modeller
extends InternalModule {
    protected CART leftCart;
    protected CART midCart;
    protected CART rightCart;
    protected TargetFeatureComputer featureComputer;
    private String propertyPrefix;
    private FeatureProcessorManager featureProcessorManager;

    public CARTF0Modeller(String locale, String propertyPrefix) throws Exception {
        this(MaryUtils.string2locale(locale), propertyPrefix, FeatureRegistry.getFeatureProcessorManager(MaryUtils.string2locale(locale)));
    }

    public CARTF0Modeller(String locale, String propertyPrefix, String featprocClassInfo) throws Exception {
        this(MaryUtils.string2locale(locale), propertyPrefix, (FeatureProcessorManager)MaryRuntimeUtils.instantiateObject(featprocClassInfo));
    }

    protected CARTF0Modeller(Locale locale, String propertyPrefix, FeatureProcessorManager featureProcessorManager) {
        super("CARTF0Modeller", MaryDataType.DURATIONS, MaryDataType.ACOUSTPARAMS, locale);
        this.propertyPrefix = propertyPrefix.endsWith(".") ? propertyPrefix : propertyPrefix + ".";
        this.featureProcessorManager = featureProcessorManager;
    }

    @Override
    public void startup() throws Exception {
        super.startup();
        String leftCartFilename = MaryProperties.getFilename(this.propertyPrefix + "cart.left");
        if (leftCartFilename != null) {
            File leftCartFile = new File(leftCartFilename);
            File fdFile = new File(MaryProperties.needFilename(this.propertyPrefix + "featuredefinition"));
            FeatureDefinition featureDefinition = new FeatureDefinition(new BufferedReader(new FileReader(fdFile)), true);
            this.leftCart = new MaryCARTReader().load(leftCartFile.getAbsolutePath());
            File midCartFile = new File(MaryProperties.needFilename(this.propertyPrefix + "cart.mid"));
            this.midCart = new MaryCARTReader().load(midCartFile.getAbsolutePath());
            File rightCartFile = new File(MaryProperties.needFilename(this.propertyPrefix + "cart.right"));
            this.rightCart = new MaryCARTReader().load(rightCartFile.getAbsolutePath());
            this.featureComputer = new TargetFeatureComputer(this.featureProcessorManager, featureDefinition.getFeatureNames());
        }
    }

    @Override
    public MaryData process(MaryData d) throws Exception {
        Document doc = d.getDocument();
        NodeIterator sentenceIt = MaryDomUtils.createNodeIterator((Node)doc, "s");
        Element sentence = null;
        AllophoneSet allophoneSet = null;
        while ((sentence = (Element)sentenceIt.nextNode()) != null) {
            Element syllable;
            Element voice = (Element)MaryDomUtils.getAncestor((Node)sentence, "voice");
            Voice maryVoice = Voice.getVoice(voice);
            if (maryVoice == null) {
                maryVoice = d.getDefaultVoice();
            }
            if (maryVoice == null) {
                Locale locale = MaryUtils.string2locale(doc.getDocumentElement().getAttribute("xml:lang"));
                maryVoice = Voice.getDefaultVoice(locale);
            }
            CART currentLeftCart = this.leftCart;
            CART currentMidCart = this.midCart;
            CART currentRightCart = this.rightCart;
            TargetFeatureComputer currentFeatureComputer = this.featureComputer;
            if (maryVoice instanceof UnitSelectionVoice) {
                FeatureDefinition voiceFeatDef;
                CART[] voiceTrees = ((UnitSelectionVoice)maryVoice).getF0Trees();
                if (voiceTrees != null) {
                    currentLeftCart = voiceTrees[0];
                    currentMidCart = voiceTrees[1];
                    currentRightCart = voiceTrees[2];
                    this.logger.debug("Using voice carts");
                }
                if ((voiceFeatDef = ((UnitSelectionVoice)maryVoice).getF0CartsFeatDef()) != null) {
                    currentFeatureComputer = new TargetFeatureComputer(this.featureProcessorManager, voiceFeatDef.getFeatureNames());
                    this.logger.debug("Using voice feature definition");
                }
            }
            if (currentLeftCart == null) {
                throw new NullPointerException("Do not have f0 prediction tree");
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker(sentence, "syllable");
            Object previous = null;
            while ((syllable = (Element)tw.nextNode()) != null) {
                Element firstVoiced = null;
                Element vowel = null;
                Element lastVoiced = null;
                Element s = MaryDomUtils.getFirstChildElement(syllable);
                while (s != null) {
                    Allophone allophone;
                    assert (s.getTagName().equals("ph")) : "expected phone element, found " + s.getTagName();
                    String phone = s.getAttribute("p");
                    if (allophoneSet == null) {
                        allophoneSet = MaryRuntimeUtils.determineAllophoneSet(s);
                    }
                    assert (allophoneSet != null);
                    try {
                        allophone = allophoneSet.getAllophone(phone);
                    }
                    catch (IllegalArgumentException e) {
                        throw new SynthesisException(e);
                    }
                    if (allophone.isVowel()) {
                        if (firstVoiced == null) {
                            firstVoiced = s;
                        }
                        if (vowel == null) {
                            vowel = s;
                        }
                        lastVoiced = s;
                    } else if (allophone.isVoiced()) {
                        if (firstVoiced == null) {
                            firstVoiced = s;
                        }
                        lastVoiced = s;
                    }
                    s = MaryDomUtils.getNextSiblingElement(s);
                }
                if (vowel == null) continue;
                assert (firstVoiced != null) : "First voiced should not be null";
                assert (lastVoiced != null) : "Last voiced should not be null";
                String phone = vowel.getAttribute("p");
                Target t = new Target(phone, vowel);
                t.setFeatureVector(currentFeatureComputer.computeFeatureVector(t));
                float[] left = (float[])currentLeftCart.interpret(t, 0);
                assert (left != null) : "Null frequency";
                assert (left.length == 2) : "Unexpected frequency length: " + left.length;
                float leftF0InHz = left[1];
                float leftStddevInHz = left[0];
                float[] mid = (float[])currentMidCart.interpret(t, 0);
                assert (mid != null) : "Null frequency";
                assert (mid.length == 2) : "Unexpected frequency length: " + mid.length;
                float midF0InHz = mid[1];
                float midStddevInHz = mid[0];
                float[] right = (float[])currentRightCart.interpret(t, 0);
                assert (right != null) : "Null frequency";
                assert (right.length == 2) : "Unexpected frequency length: " + right.length;
                float rightF0InHz = right[1];
                float rightStddevInHz = right[0];
                String leftTargetString = "(0," + (int)leftF0InHz + ")";
                String currentVal = firstVoiced.getAttribute("f0");
                String newVal = !currentVal.equals("") ? currentVal + " " + leftTargetString : leftTargetString;
                firstVoiced.setAttribute("f0", newVal);
                String midTargetString = "(50," + (int)midF0InHz + ")";
                currentVal = vowel.getAttribute("f0");
                newVal = !currentVal.equals("") ? currentVal + " " + midTargetString : midTargetString;
                vowel.setAttribute("f0", newVal);
                String rightTargetString = "(100," + (int)rightF0InHz + ")";
                currentVal = lastVoiced.getAttribute("f0");
                newVal = !currentVal.equals("") ? currentVal + " " + rightTargetString : rightTargetString;
                lastVoiced.setAttribute("f0", newVal);
            }
        }
        MaryData output = new MaryData(this.outputType(), d.getLocale());
        output.setDocument(doc);
        return output;
    }
}

