/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.en;

import com.sun.speech.freetts.Utterance;
import com.sun.speech.freetts.UtteranceProcessor;
import com.sun.speech.freetts.cart.CARTImpl;
import com.sun.speech.freetts.cart.Phraser;
import com.sun.speech.freetts.en.us.CMUVoice;
import java.util.List;
import java.util.Locale;
import marytts.datatypes.MaryData;
import marytts.language.en_US.datatypes.USEnglishDataTypes;
import marytts.modules.InternalModule;
import marytts.modules.synthesis.FreeTTSVoices;

public class FreeTTSPhraser
extends InternalModule {
    private UtteranceProcessor processor;

    public FreeTTSPhraser() {
        super("Phraser", USEnglishDataTypes.FREETTS_POS, USEnglishDataTypes.FREETTS_PHRASES, Locale.ENGLISH);
    }

    @Override
    public void startup() throws Exception {
        super.startup();
        FreeTTSVoices.load();
        CARTImpl phrasingCart = new CARTImpl(CMUVoice.class.getResource("phrasing_cart.txt"));
        this.processor = new Phraser(phrasingCart);
    }

    @Override
    public MaryData process(MaryData d) throws Exception {
        List<Utterance> utterances = d.getUtterances();
        for (Utterance utterance : utterances) {
            this.processor.processUtterance(utterance);
        }
        MaryData output = new MaryData(this.outputType(), d.getLocale());
        output.setUtterances(utterances);
        return output;
    }
}

