/*
 * Decompiled with CFR 0.152.
 */
package marytts.client;

import marytts.client.AudioEffectControlData;
import marytts.util.string.StringUtils;

public class AudioEffectsBoxData {
    private AudioEffectControlData[] effectControlsData = null;

    public AudioEffectsBoxData(String availableEffects) {
        if (availableEffects != null && availableEffects.length() > 0) {
            this.parseAvailableEffects(availableEffects);
        }
    }

    public AudioEffectControlData getControlData(int index) {
        if (this.effectControlsData != null && index >= 0 && index < this.effectControlsData.length) {
            return this.effectControlsData[index];
        }
        return null;
    }

    public boolean hasEffects() {
        return this.effectControlsData != null;
    }

    protected int parseAvailableEffects(String availableEffects) {
        String[] effectLines = StringUtils.toStringArray(availableEffects);
        this.effectControlsData = new AudioEffectControlData[effectLines.length];
        for (int i = 0; i < effectLines.length; ++i) {
            String strParams;
            String strEffectName;
            int iSpace = effectLines[i].indexOf(32);
            if (iSpace != -1) {
                strEffectName = effectLines[i].substring(0, iSpace);
                strParams = effectLines[i].substring(iSpace + 1);
            } else {
                strEffectName = effectLines[i];
                strParams = "";
            }
            this.effectControlsData[i] = new AudioEffectControlData(strEffectName, strParams, null);
        }
        return this.getTotalEffects();
    }

    public int getTotalEffects() {
        if (this.effectControlsData != null) {
            return this.effectControlsData.length;
        }
        return 0;
    }
}

