/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.sql.Array;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Type;

public class ArrayType
extends Type {
    final Type dataType;
    final int maxCardinality;

    public ArrayType(Type type, int n) {
        super(50, 50, 0L, 0);
        this.dataType = type;
        this.maxCardinality = n;
    }

    @Override
    public int displaySize() {
        return 7 + (this.dataType.displaySize() + 1) * this.maxCardinality;
    }

    @Override
    public int getJDBCTypeCode() {
        return 2003;
    }

    @Override
    public Class getJDBCClass() {
        return Array.class;
    }

    @Override
    public String getJDBCClassName() {
        return "java.sql.Array";
    }

    @Override
    public Integer getJDBCScale() {
        return ValuePool.INTEGER_0;
    }

    @Override
    public int getJDBCPrecision() {
        return ValuePool.INTEGER_0;
    }

    @Override
    public int getSQLGenericTypeCode() {
        return 0;
    }

    @Override
    public String getNameString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.dataType.getNameString()).append(' ');
        stringBuffer.append("ARRAY");
        if (this.maxCardinality != 1024) {
            stringBuffer.append('[').append(this.maxCardinality).append(']');
        }
        return stringBuffer.toString();
    }

    @Override
    String getDefinition() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.dataType.getDefinition()).append(' ');
        stringBuffer.append("ARRAY");
        if (this.maxCardinality != 1024) {
            stringBuffer.append('[').append(this.maxCardinality).append(']');
        }
        return stringBuffer.toString();
    }

    @Override
    public int compare(Session session, Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        Object[] objectArray = (Object[])object2;
        Object[] objectArray2 = (Object[])object;
        int n = objectArray2.length;
        if (objectArray.length < n) {
            n = objectArray.length;
        }
        for (int i = 0; i < n; ++i) {
            int n2 = this.dataType.compare(session, objectArray2[i], objectArray[i]);
            if (n2 == 0) continue;
            return n2;
        }
        if (objectArray2.length > objectArray.length) {
            return 1;
        }
        if (objectArray2.length < objectArray.length) {
            return -1;
        }
        return 0;
    }

    @Override
    public Object convertToTypeLimits(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return null;
        }
        Object[] objectArray = (Object[])object;
        if (objectArray.length > this.maxCardinality) {
            throw Error.error(3491);
        }
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = this.dataType.convertToTypeLimits(sessionInterface, objectArray[i]);
        }
        return objectArray2;
    }

    @Override
    public Object convertToType(SessionInterface sessionInterface, Object object, Type type) {
        if (object == null) {
            return null;
        }
        if (type == null) {
            return object;
        }
        if (!type.isArrayType()) {
            throw Error.error(5562);
        }
        Object[] objectArray = (Object[])object;
        if (objectArray.length > this.maxCardinality) {
            throw Error.error(3491);
        }
        Type type2 = type.collectionBaseType();
        if (this.dataType.equals(type2)) {
            return object;
        }
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = this.dataType.convertToType(sessionInterface, objectArray[i], type2);
        }
        return objectArray2;
    }

    @Override
    public Object convertToDefaultType(SessionInterface sessionInterface, Object object) {
        return object;
    }

    @Override
    public String convertToString(Object object) {
        if (object == null) {
            return null;
        }
        return this.convertToSQLString(object);
    }

    @Override
    public String convertToSQLString(Object object) {
        if (object == null) {
            return "NULL";
        }
        Object[] objectArray = (Object[])object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ARRAY");
        stringBuffer.append('[');
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.dataType.convertToSQLString(objectArray[i]));
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    @Override
    public boolean canConvertFrom(Type type) {
        if (type == null) {
            return true;
        }
        if (!type.isArrayType()) {
            return false;
        }
        Type type2 = type.collectionBaseType();
        return this.dataType.canConvertFrom(type2);
    }

    @Override
    public boolean canBeAssignedFrom(Type type) {
        if (type == null) {
            return true;
        }
        Type type2 = type.collectionBaseType();
        return type2 != null && this.dataType.canBeAssignedFrom(type2);
    }

    @Override
    public Type collectionBaseType() {
        return this.dataType;
    }

    @Override
    public int arrayLimitCardinality() {
        return this.maxCardinality;
    }

    @Override
    public boolean isArrayType() {
        return true;
    }

    @Override
    public Type getAggregateType(Type type) {
        if (type == null) {
            return this;
        }
        if (!type.isArrayType()) {
            throw Error.error(5562);
        }
        Type type2 = type.collectionBaseType();
        if (this.dataType.equals(type2)) {
            return this;
        }
        Type type3 = this.dataType.getAggregateType(type2);
        return new ArrayType(type3, this.maxCardinality);
    }

    @Override
    public Type getCombinedType(Type type, int n) {
        if (n != 36) {
            return this.getAggregateType(type);
        }
        if (type == null) {
            return this;
        }
        if (!type.isArrayType()) {
            throw Error.error(5562);
        }
        Type type2 = type.collectionBaseType();
        Type type3 = this.dataType.getAggregateType(type2);
        return new ArrayType(type3, this.maxCardinality + type.arrayLimitCardinality());
    }

    @Override
    public int cardinality(Session session, Object object) {
        if (object == null) {
            return 0;
        }
        return ((Object[])object).length;
    }

    @Override
    public Object concat(Session session, Object object, Object object2) {
        if (object == null || object2 == null) {
            return null;
        }
        int n = ((Object[])object).length + ((Object[])object2).length;
        Object[] objectArray = new Object[n];
        System.arraycopy(object, 0, objectArray, 0, ((Object[])object).length);
        System.arraycopy(object2, 0, objectArray, ((Object[])object).length, ((Object[])object2).length);
        return objectArray;
    }
}

