/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.TableWorks;
import org.hsqldb.TextTable;
import org.hsqldb.error.Error;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.result.Result;
import org.hsqldb.rights.User;
import org.hsqldb.scriptio.ScriptWriterText;

public class StatementCommand
extends Statement {
    Expression[] expressions;
    Object[] parameters;

    StatementCommand(int n, Object[] objectArray) {
        this(n, objectArray, null, null);
    }

    StatementCommand(int n, Object[] objectArray, HsqlNameManager.HsqlName hsqlName, HsqlNameManager.HsqlName hsqlName2) {
        super(n);
        this.isTransactionStatement = true;
        this.parameters = objectArray;
        if (hsqlName != null && hsqlName != hsqlName2) {
            this.readTableNames = new HsqlNameManager.HsqlName[]{hsqlName};
        }
        if (hsqlName2 != null) {
            this.writeTableNames = new HsqlNameManager.HsqlName[]{hsqlName2};
        }
        switch (n) {
            case 1002: {
                this.group = 2014;
                this.isLogged = false;
                break;
            }
            case 1001: 
            case 1004: {
                this.group = 2014;
                this.isLogged = false;
                break;
            }
            case 1025: 
            case 1026: 
            case 1048: {
                this.isTransactionStatement = false;
                this.group = 2013;
                break;
            }
            case 1011: 
            case 1012: 
            case 1013: 
            case 1014: 
            case 1015: 
            case 1016: 
            case 1017: 
            case 1018: 
            case 1019: 
            case 1020: 
            case 1023: 
            case 1024: 
            case 1031: 
            case 1032: 
            case 1033: 
            case 1034: 
            case 1037: 
            case 1038: 
            case 1039: 
            case 1041: 
            case 1042: 
            case 1043: 
            case 1044: 
            case 1045: 
            case 1046: 
            case 1047: {
                this.group = 2013;
                this.isTransactionStatement = true;
                break;
            }
            case 1086: {
                this.isLogged = false;
            }
            case 1085: {
                this.metaDataImpact = 1;
                this.group = 2012;
                this.isTransactionStatement = true;
                break;
            }
            case 1084: {
                this.metaDataImpact = 1;
                this.group = 2012;
                this.isTransactionStatement = true;
                break;
            }
            case 1003: {
                this.isLogged = false;
                this.group = 2014;
                this.isTransactionStatement = false;
                break;
            }
            case 1087: {
                this.group = 2012;
                this.isTransactionStatement = true;
                break;
            }
            case 1083: {
                this.group = 2013;
                this.isTransactionStatement = false;
                this.isLogged = false;
                break;
            }
            case 1061: 
            case 1062: {
                this.group = 2013;
                this.isTransactionStatement = false;
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementCommand");
            }
        }
    }

    @Override
    public Result execute(Session session) {
        Result result;
        try {
            result = this.getResult(session);
        }
        catch (Throwable throwable) {
            result = Result.newErrorResult(throwable, null);
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
            return result;
        }
        try {
            if (this.isLogged) {
                session.database.logger.writeToLog(session, this.sql);
            }
        }
        catch (Throwable throwable) {
            return Result.newErrorResult(throwable, this.sql);
        }
        return result;
    }

    Result getResult(Session session) {
        if (this.isExplain) {
            return Result.newSingleColumnStringResult("OPERATION", this.describe(session));
        }
        switch (this.type) {
            case 1001: {
                String string = (String)this.parameters[0];
                boolean bl = (Boolean)this.parameters[1];
                boolean bl2 = (Boolean)this.parameters[2];
                boolean bl3 = (Boolean)this.parameters[3];
                try {
                    session.checkAdmin();
                    if (!session.database.getType().equals("file:")) {
                        return Result.newErrorResult(Error.error(464));
                    }
                    if (session.database.isReadOnly()) {
                        return Result.newErrorResult(Error.error(459), null);
                    }
                    if (session.database.logger.isStoredFileAccess) {
                        return Result.newErrorResult(Error.error(464), null);
                    }
                    session.database.logger.backup(string, session.database.getPath(), bl2, bl, bl3);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1002: {
                boolean bl = (Boolean)this.parameters[0];
                try {
                    session.database.logger.checkpoint(bl);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1011: {
                try {
                    boolean bl = (Boolean)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setIncrementBackup(bl);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1012: {
                try {
                    int n = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setCacheMaxRows(n);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1013: {
                try {
                    int n = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setCacheSize(n);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1016: {
                try {
                    int n = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (session.isProcessingScript) {
                        session.database.logger.setLobFileScaleNoCheck(n);
                    } else {
                        session.database.logger.setLobFileScale(n);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1023: {
                try {
                    int n = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (session.isProcessingScript) {
                        session.database.logger.setCacheFileScaleNoCheck(n);
                    } else {
                        session.database.logger.setCacheFileScale(n);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1014: {
                try {
                    int n = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setDefagLimit(n);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1015: {
                try {
                    int n = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setEventLogLevel(n);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1017: {
                try {
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1020: {
                try {
                    boolean bl = (Boolean)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setNioDataFile(bl);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1018: {
                try {
                    boolean bl = (Boolean)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setLogData(bl);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1019: {
                try {
                    int n = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setLogSize(n);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1025: {
                try {
                    String string = (String)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1026: {
                try {
                    int n = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setWriteDelay(n);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1039: {
                try {
                    String string = (String)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.collation.setCollation(string);
                    session.database.schemaManager.setSchemaChangeTimestamp();
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1041: {
                boolean bl = (Boolean)this.parameters[0];
                session.database.setReferentialIntegrity(bl);
                return Result.updateZeroResult;
            }
            case 1042: {
                boolean bl = (Boolean)this.parameters[0];
                session.database.setStrictNames(bl);
                return Result.updateZeroResult;
            }
            case 1043: {
                boolean bl = (Boolean)this.parameters[0];
                session.database.setStrictColumnSize(bl);
                return Result.updateZeroResult;
            }
            case 1044: {
                boolean bl = (Boolean)this.parameters[0];
                session.database.setStrictReferences(bl);
                return Result.updateZeroResult;
            }
            case 1031: {
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.parameters[0];
                session.database.schemaManager.setDefaultSchemaHsqlName(hsqlName);
                session.database.schemaManager.setSchemaChangeTimestamp();
                return Result.updateZeroResult;
            }
            case 1032: {
                Integer n = (Integer)this.parameters[0];
                session.database.schemaManager.setDefaultTableType(n);
                return Result.updateZeroResult;
            }
            case 1038: {
                try {
                    int n = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setScriptType(n);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1046: {
                try {
                    int n = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.txManager.setTransactionControl(session, n);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1047: {
                try {
                    int n = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.defaultIsolationLevel = n;
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1033: {
                try {
                    int n = (Integer)this.parameters[0];
                    session.checkAdmin();
                    JavaSystem.gcFrequency = n;
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1034: {
                try {
                    String string = (String)this.parameters[0];
                    Object object = this.parameters[1];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1037: {
                int n = (Integer)this.parameters[0];
                session.database.getProperties().setProperty("hsqldb.result_max_memory_rows", n);
                session.database.setResultMaxMemoryRows(n);
                return Result.updateZeroResult;
            }
            case 1045: {
                try {
                    String string = (String)this.parameters[0];
                    HsqlProperties hsqlProperties = null;
                    if (string.length() > 0 && (hsqlProperties = HsqlProperties.delimitedArgPairsToProps(string, "=", ";", null)).getErrorKeys().length > 0) {
                        throw Error.error(482, hsqlProperties.getErrorKeys()[0]);
                    }
                    session.database.logger.setDefaultTextTableProperties(string, hsqlProperties);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1048: {
                try {
                    String string = (String)this.parameters[0];
                    session.database.setUniqueName(string);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1004: {
                ScriptWriterText scriptWriterText = null;
                String string = (String)this.parameters[0];
                if (string == null) {
                    return session.database.getScript(false);
                }
                try {
                    scriptWriterText = new ScriptWriterText(session.database, string, true, true, true);
                    scriptWriterText.writeAll();
                    scriptWriterText.close();
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
                return Result.updateZeroResult;
            }
            case 1003: {
                try {
                    int n = (Integer)this.parameters[0];
                    session.database.close(n);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1083: {
                try {
                    HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.parameters[0];
                    String string = (String)this.parameters[1];
                    Table table = session.database.schemaManager.getTable(session, hsqlName.name, hsqlName.schema.name);
                    table.setIndexRoots(session, string);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1084: {
                try {
                    HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.parameters[0];
                    Table table = session.database.schemaManager.getTable(session, hsqlName.name, hsqlName.schema.name);
                    boolean bl = (Boolean)this.parameters[1];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    table.setDataReadOnly(bl);
                    session.database.schemaManager.setSchemaChangeTimestamp();
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1085: 
            case 1086: {
                try {
                    HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.parameters[0];
                    Table table = session.database.schemaManager.getTable(session, hsqlName.name, hsqlName.schema.name);
                    if (!table.isText()) {
                        HsqlException hsqlException = Error.error(321);
                        return Result.newErrorResult(hsqlException, this.sql);
                    }
                    if (this.parameters[1] != null) {
                        boolean bl = (Boolean)this.parameters[1];
                        if (bl) {
                            ((TextTable)table).connect(session);
                        } else {
                            ((TextTable)table).disconnect();
                        }
                        session.database.schemaManager.setSchemaChangeTimestamp();
                        return Result.updateZeroResult;
                    }
                    String string = (String)this.parameters[2];
                    boolean bl = (Boolean)this.parameters[3];
                    boolean bl4 = (Boolean)this.parameters[4];
                    if (bl4) {
                        ((TextTable)table).setHeader(string);
                    } else {
                        ((TextTable)table).setDataSource(session, string, bl, false);
                    }
                    return Result.updateZeroResult;
                }
                catch (Throwable throwable) {
                    HsqlException hsqlException;
                    if (!(throwable instanceof HsqlException)) {
                        hsqlException = Error.error(467, throwable.getMessage());
                    }
                    if (session.isProcessingLog() || session.isProcessingScript()) {
                        session.addWarning(hsqlException);
                        session.database.logger.logWarningEvent("Problem processing SET TABLE SOURCE", hsqlException);
                        return Result.updateZeroResult;
                    }
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1087: {
                try {
                    HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.parameters[0];
                    int n = (Integer)this.parameters[1];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    Table table = session.database.schemaManager.getUserTable(session, hsqlName.name, hsqlName.schema.name);
                    session.setScripting(true);
                    TableWorks tableWorks = new TableWorks(session, table);
                    tableWorks.setTableType(session, n);
                    session.database.schemaManager.setSchemaChangeTimestamp();
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1061: {
                try {
                    User user = (User)this.parameters[0];
                    HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.parameters[1];
                    session.checkDDLWrite();
                    if (user == null) {
                        user = session.getUser();
                    } else {
                        session.checkAdmin();
                        session.checkDDLWrite();
                        user = session.database.userManager.get(user.getNameString());
                    }
                    if (hsqlName != null) {
                        hsqlName = session.database.schemaManager.getSchemaHsqlName(hsqlName.name);
                    }
                    user.setInitialSchema(hsqlName);
                    session.database.schemaManager.setSchemaChangeTimestamp();
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
            case 1062: {
                try {
                    User user = this.parameters[0] == null ? session.getUser() : (User)this.parameters[0];
                    String string = (String)this.parameters[1];
                    session.checkDDLWrite();
                    session.setScripting(true);
                    user.setPassword(string);
                    return Result.updateZeroResult;
                }
                catch (HsqlException hsqlException) {
                    return Result.newErrorResult(hsqlException, this.sql);
                }
            }
        }
        throw Error.runtimeError(201, "StatemntCommand");
    }

    @Override
    public boolean isAutoCommitStatement() {
        return this.isTransactionStatement;
    }

    @Override
    public String describe(Session session) {
        return this.sql;
    }
}

