/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.SortAndSlice;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.TableDerived;
import org.hsqldb.View;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayListIdentity;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.lib.Set;
import org.hsqldb.navigator.RowSetNavigatorData;
import org.hsqldb.navigator.RowSetNavigatorDataTable;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Type;

public class QueryExpression {
    public static final int NOUNION = 0;
    public static final int UNION = 1;
    public static final int UNION_ALL = 2;
    public static final int INTERSECT = 3;
    public static final int INTERSECT_ALL = 4;
    public static final int EXCEPT_ALL = 5;
    public static final int EXCEPT = 6;
    public static final int UNION_TERM = 7;
    int columnCount;
    private QueryExpression leftQueryExpression;
    private QueryExpression rightQueryExpression;
    SortAndSlice sortAndSlice;
    private int unionType;
    private boolean unionCorresponding;
    private OrderedHashSet unionCorrespondingColumns;
    int[] unionColumnMap;
    Type[] unionColumnTypes;
    boolean isFullOrder;
    HsqlList unresolvedExpressions;
    boolean isResolved;
    int persistenceScope = 21;
    ResultMetaData resultMetaData;
    boolean[] accessibleColumns;
    View view;
    boolean isMergeable;
    boolean isUpdatable;
    boolean isInsertable;
    boolean isCheckable;
    boolean isTopLevel;
    boolean acceptsSequences;
    public TableBase resultTable;
    public Index mainIndex;
    public Index fullIndex;
    public Index orderIndex;
    public Index idIndex;
    ParserDQL.CompileContext compileContext;

    QueryExpression(ParserDQL.CompileContext compileContext) {
        this.compileContext = compileContext;
        this.sortAndSlice = SortAndSlice.noSort;
    }

    public QueryExpression(ParserDQL.CompileContext compileContext, QueryExpression queryExpression) {
        this(compileContext);
        this.sortAndSlice = SortAndSlice.noSort;
        this.leftQueryExpression = queryExpression;
    }

    void addUnion(QueryExpression queryExpression, int n) {
        this.sortAndSlice = SortAndSlice.noSort;
        this.rightQueryExpression = queryExpression;
        this.unionType = n;
        this.setFullOrder();
    }

    void addSortAndSlice(SortAndSlice sortAndSlice) {
        this.sortAndSlice = sortAndSlice;
        sortAndSlice.sortUnion = true;
    }

    public void setUnionCorresoponding() {
        this.unionCorresponding = true;
    }

    public void setUnionCorrespondingColumns(OrderedHashSet orderedHashSet) {
        this.unionCorrespondingColumns = orderedHashSet;
    }

    public void setFullOrder() {
        this.isFullOrder = true;
        if (this.leftQueryExpression == null) {
            if (this.isResolved) {
                ((QuerySpecification)this).createFullIndex(null);
            }
            return;
        }
        this.leftQueryExpression.setFullOrder();
        this.rightQueryExpression.setFullOrder();
    }

    public void resolve(Session session) {
        this.resolveReferences(session);
        ExpressionColumn.checkColumnsResolved(this.unresolvedExpressions);
        this.resolveTypes(session);
    }

    public void resolve(Session session, RangeVariable[] rangeVariableArray, Type[] typeArray) {
        int n;
        this.resolveReferences(session);
        if (this.unresolvedExpressions != null) {
            for (n = 0; n < this.unresolvedExpressions.size(); ++n) {
                Expression expression = (Expression)this.unresolvedExpressions.get(n);
                HsqlList hsqlList = expression.resolveColumnReferences(rangeVariableArray, null);
                ExpressionColumn.checkColumnsResolved(hsqlList);
            }
        }
        this.resolveTypesPartOne(session);
        for (n = 0; n < this.unionColumnTypes.length && n < typeArray.length; ++n) {
            if (this.unionColumnTypes[n] != null) continue;
            this.unionColumnTypes[n] = typeArray[n];
        }
        this.resolveTypesPartTwo(session);
    }

    public void resolveReferences(Session session) {
        this.leftQueryExpression.resolveReferences(session);
        this.rightQueryExpression.resolveReferences(session);
        this.addUnresolvedExpressions(this.leftQueryExpression.unresolvedExpressions);
        this.addUnresolvedExpressions(this.rightQueryExpression.unresolvedExpressions);
        if (!this.unionCorresponding) {
            this.columnCount = this.leftQueryExpression.getColumnCount();
            int n = this.rightQueryExpression.getColumnCount();
            if (this.columnCount != n) {
                throw Error.error(5594);
            }
            this.unionColumnTypes = new Type[this.columnCount];
            this.leftQueryExpression.unionColumnMap = this.rightQueryExpression.unionColumnMap = new int[this.columnCount];
            ArrayUtil.fillSequence(this.leftQueryExpression.unionColumnMap);
            this.resolveColumnRefernecesInUnionOrderBy();
            return;
        }
        Object[] objectArray = this.leftQueryExpression.getColumnNames();
        Object[] objectArray2 = this.rightQueryExpression.getColumnNames();
        if (this.unionCorrespondingColumns == null) {
            this.unionCorrespondingColumns = new OrderedHashSet();
            OrderedIntHashSet orderedIntHashSet = new OrderedIntHashSet();
            OrderedIntHashSet orderedIntHashSet2 = new OrderedIntHashSet();
            for (int i = 0; i < objectArray.length; ++i) {
                String string = objectArray[i];
                int n = ArrayUtil.find(objectArray2, string);
                if (string.length() <= 0 || n == -1) continue;
                if (!this.leftQueryExpression.accessibleColumns[i]) {
                    throw Error.error(5578);
                }
                if (!this.rightQueryExpression.accessibleColumns[n]) {
                    throw Error.error(5578);
                }
                orderedIntHashSet.add(i);
                orderedIntHashSet2.add(n);
                this.unionCorrespondingColumns.add(string);
            }
            if (this.unionCorrespondingColumns.isEmpty()) {
                throw Error.error(5578);
            }
            this.leftQueryExpression.unionColumnMap = orderedIntHashSet.toArray();
            this.rightQueryExpression.unionColumnMap = orderedIntHashSet2.toArray();
        } else {
            this.leftQueryExpression.unionColumnMap = new int[this.unionCorrespondingColumns.size()];
            this.rightQueryExpression.unionColumnMap = new int[this.unionCorrespondingColumns.size()];
            for (int i = 0; i < this.unionCorrespondingColumns.size(); ++i) {
                String string = (String)this.unionCorrespondingColumns.get(i);
                int n = ArrayUtil.find(objectArray, string);
                if (n == -1) {
                    throw Error.error(5501);
                }
                if (!this.leftQueryExpression.accessibleColumns[n]) {
                    throw Error.error(5578);
                }
                this.leftQueryExpression.unionColumnMap[i] = n;
                n = ArrayUtil.find(objectArray2, string);
                if (n == -1) {
                    throw Error.error(5501);
                }
                if (!this.rightQueryExpression.accessibleColumns[n]) {
                    throw Error.error(5578);
                }
                this.rightQueryExpression.unionColumnMap[i] = n;
            }
        }
        this.columnCount = this.unionCorrespondingColumns.size();
        this.unionColumnTypes = new Type[this.columnCount];
        this.resolveColumnRefernecesInUnionOrderBy();
    }

    void resolveColumnRefernecesInUnionOrderBy() {
        int n = this.sortAndSlice.getOrderLength();
        if (n == 0) {
            return;
        }
        Object[] objectArray = this.getColumnNames();
        for (int i = 0; i < n; ++i) {
            int n2;
            Expression expression = (Expression)this.sortAndSlice.exprList.get(i);
            Expression expression2 = expression.getLeftNode();
            if (expression2.getType() == 1) {
                if (expression2.getDataType().typeCode == 4 && 0 < (n2 = ((Integer)expression2.getValue(null)).intValue()) && n2 <= objectArray.length) {
                    expression.getLeftNode().queryTableColumnIndex = n2 - 1;
                    continue;
                }
            } else if (expression2.getType() == 2 && (n2 = ArrayUtil.find(objectArray, expression2.getColumnName())) >= 0) {
                expression.getLeftNode().queryTableColumnIndex = n2;
                continue;
            }
            throw Error.error(5576);
        }
        this.sortAndSlice.prepare(null);
    }

    private void addUnresolvedExpressions(HsqlList hsqlList) {
        if (hsqlList == null) {
            return;
        }
        if (this.unresolvedExpressions == null) {
            this.unresolvedExpressions = new ArrayListIdentity();
        }
        this.unresolvedExpressions.addAll(hsqlList);
    }

    public void resolveTypes(Session session) {
        if (this.isResolved) {
            return;
        }
        this.resolveTypesPartOne(session);
        this.resolveTypesPartTwo(session);
        this.isResolved = true;
    }

    void resolveTypesPartOne(Session session) {
        ArrayUtil.projectRowReverse(this.leftQueryExpression.unionColumnTypes, this.leftQueryExpression.unionColumnMap, this.unionColumnTypes);
        this.leftQueryExpression.resolveTypesPartOne(session);
        ArrayUtil.projectRow(this.leftQueryExpression.unionColumnTypes, this.leftQueryExpression.unionColumnMap, this.unionColumnTypes);
        ArrayUtil.projectRowReverse(this.rightQueryExpression.unionColumnTypes, this.rightQueryExpression.unionColumnMap, this.unionColumnTypes);
        this.rightQueryExpression.resolveTypesPartOne(session);
        ArrayUtil.projectRow(this.rightQueryExpression.unionColumnTypes, this.rightQueryExpression.unionColumnMap, this.unionColumnTypes);
    }

    void resolveTypesPartTwo(Session session) {
        Object object;
        ArrayUtil.projectRowReverse(this.leftQueryExpression.unionColumnTypes, this.leftQueryExpression.unionColumnMap, this.unionColumnTypes);
        this.leftQueryExpression.resolveTypesPartTwo(session);
        ArrayUtil.projectRowReverse(this.rightQueryExpression.unionColumnTypes, this.rightQueryExpression.unionColumnMap, this.unionColumnTypes);
        this.rightQueryExpression.resolveTypesPartTwo(session);
        if (this.unionCorresponding) {
            this.resultMetaData = this.leftQueryExpression.getMetaData().getNewMetaData(this.leftQueryExpression.unionColumnMap);
            this.createTable(session);
        }
        if (this.sortAndSlice.hasOrder()) {
            object = this;
            while (true) {
                if (((QueryExpression)object).leftQueryExpression == null || ((QueryExpression)object).unionCorresponding) {
                    this.sortAndSlice.setIndex(session, ((QueryExpression)object).resultTable);
                    break;
                }
                object = ((QueryExpression)object).leftQueryExpression;
            }
        }
        object = this.getMetaData();
    }

    public Object[] getValues(Session session) {
        Result result = this.getResult(session, 2);
        int n = result.getNavigator().getSize();
        if (n == 0) {
            return new Object[result.metaData.getColumnCount()];
        }
        if (n == 1) {
            return result.getSingleRowData();
        }
        throw Error.error(3201);
    }

    public Object[] getSingleRowValues(Session session) {
        Result result = this.getResult(session, 2);
        int n = result.getNavigator().getSize();
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return result.getSingleRowData();
        }
        throw Error.error(3201);
    }

    public Object getValue(Session session) {
        Object[] objectArray = this.getValues(session);
        return objectArray[0];
    }

    Result getResult(Session session, int n) {
        int n2 = this.unionType == 2 ? n : 0;
        Result result = this.leftQueryExpression.getResult(session, n2);
        RowSetNavigatorData rowSetNavigatorData = (RowSetNavigatorData)result.getNavigator();
        Result result2 = this.rightQueryExpression.getResult(session, n2);
        RowSetNavigatorData rowSetNavigatorData2 = (RowSetNavigatorData)result2.getNavigator();
        if (this.unionCorresponding) {
            boolean bl = session.resultMaxMemoryRows == 0 || rowSetNavigatorData.getSize() < session.resultMaxMemoryRows && rowSetNavigatorData2.getSize() < session.resultMaxMemoryRows;
            RowSetNavigatorData rowSetNavigatorData3 = bl ? new RowSetNavigatorData(session, this) : new RowSetNavigatorDataTable(session, this);
            rowSetNavigatorData3.copy(rowSetNavigatorData, this.leftQueryExpression.unionColumnMap);
            rowSetNavigatorData = rowSetNavigatorData3;
            result.setNavigator(rowSetNavigatorData);
            result.metaData = this.getMetaData();
            rowSetNavigatorData3 = bl ? new RowSetNavigatorData(session, this) : new RowSetNavigatorDataTable(session, this);
            rowSetNavigatorData3.copy(rowSetNavigatorData2, this.rightQueryExpression.unionColumnMap);
            rowSetNavigatorData2 = rowSetNavigatorData3;
        }
        switch (this.unionType) {
            case 1: {
                rowSetNavigatorData.union(rowSetNavigatorData2);
                break;
            }
            case 2: {
                rowSetNavigatorData.unionAll(rowSetNavigatorData2);
                break;
            }
            case 3: {
                rowSetNavigatorData.intersect(rowSetNavigatorData2);
                break;
            }
            case 4: {
                rowSetNavigatorData.intersectAll(rowSetNavigatorData2);
                break;
            }
            case 6: {
                rowSetNavigatorData.except(rowSetNavigatorData2);
                break;
            }
            case 5: {
                rowSetNavigatorData.exceptAll(rowSetNavigatorData2);
                break;
            }
            default: {
                throw Error.runtimeError(201, "QueryExpression");
            }
        }
        if (this.sortAndSlice.hasOrder()) {
            rowSetNavigatorData.sortUnion(this.sortAndSlice);
        }
        if (this.sortAndSlice.hasLimit()) {
            rowSetNavigatorData.trim(this.sortAndSlice.getLimitStart(session), this.sortAndSlice.getLimitCount(session, n));
        }
        rowSetNavigatorData.reset();
        return result;
    }

    public OrderedHashSet getSubqueries() {
        OrderedHashSet orderedHashSet = this.leftQueryExpression.getSubqueries();
        return OrderedHashSet.addAll(orderedHashSet, this.rightQueryExpression.getSubqueries());
    }

    public boolean isSingleColumn() {
        return this.leftQueryExpression.isSingleColumn();
    }

    public ResultMetaData getMetaData() {
        if (this.resultMetaData != null) {
            return this.resultMetaData;
        }
        return this.leftQueryExpression.getMetaData();
    }

    public QuerySpecification getMainSelect() {
        if (this.leftQueryExpression == null) {
            return (QuerySpecification)this;
        }
        return this.leftQueryExpression.getMainSelect();
    }

    public String describe(Session session, int n) {
        String string;
        String string2 = ValuePool.spaceString.substring(0, n);
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.unionType) {
            case 1: {
                string = "UNION";
                break;
            }
            case 2: {
                string = "UNION ALL";
                break;
            }
            case 3: {
                string = "INTERSECT";
                break;
            }
            case 4: {
                string = "INTERSECT ALL";
                break;
            }
            case 6: {
                string = "EXCEPT";
                break;
            }
            case 5: {
                string = "EXCEPT ALL";
                break;
            }
            default: {
                throw Error.runtimeError(201, "QueryExpression");
            }
        }
        stringBuffer.append(string2).append(string).append("\n");
        stringBuffer.append(string2).append("Left Query=[\n");
        stringBuffer.append(string2).append(this.leftQueryExpression.describe(session, n + 2));
        stringBuffer.append(string2).append("]\n");
        stringBuffer.append(string2).append("Right Query=[\n");
        stringBuffer.append(string2).append(this.rightQueryExpression.describe(session, n + 2));
        stringBuffer.append(string2).append("]\n");
        return stringBuffer.toString();
    }

    public HsqlList getUnresolvedExpressions() {
        return this.unresolvedExpressions;
    }

    public boolean areColumnsResolved() {
        return this.unresolvedExpressions == null || this.unresolvedExpressions.isEmpty();
    }

    String[] getColumnNames() {
        if (this.unionCorrespondingColumns == null) {
            return this.leftQueryExpression.getColumnNames();
        }
        Object[] objectArray = new String[this.unionCorrespondingColumns.size()];
        this.unionCorrespondingColumns.toArray(objectArray);
        return objectArray;
    }

    public Type[] getColumnTypes() {
        return this.unionColumnTypes;
    }

    public int getColumnCount() {
        if (this.unionCorrespondingColumns == null) {
            int n;
            int n2 = this.leftQueryExpression.getColumnCount();
            if (n2 != (n = this.rightQueryExpression.getColumnCount())) {
                throw Error.error(5594);
            }
            return n2;
        }
        return this.unionCorrespondingColumns.size();
    }

    public OrderedHashSet collectAllExpressions(OrderedHashSet orderedHashSet, OrderedIntHashSet orderedIntHashSet, OrderedIntHashSet orderedIntHashSet2) {
        orderedHashSet = this.leftQueryExpression.collectAllExpressions(orderedHashSet, orderedIntHashSet, orderedIntHashSet2);
        if (this.rightQueryExpression != null) {
            orderedHashSet = this.rightQueryExpression.collectAllExpressions(orderedHashSet, orderedIntHashSet, orderedIntHashSet2);
        }
        return orderedHashSet;
    }

    public void collectObjectNames(Set set) {
        this.leftQueryExpression.collectObjectNames(set);
        if (this.rightQueryExpression != null) {
            this.rightQueryExpression.collectObjectNames(set);
        }
    }

    public HashMappedList getColumns() {
        this.getResultTable();
        return ((TableDerived)this.getResultTable()).columnList;
    }

    public void setView(View view) {
        this.isUpdatable = true;
        this.view = view;
        this.acceptsSequences = true;
        this.isTopLevel = true;
    }

    public void setTableColumnNames(HashMappedList hashMappedList) {
        if (this.resultTable != null) {
            ((TableDerived)this.resultTable).columnList = hashMappedList;
            return;
        }
        this.leftQueryExpression.setTableColumnNames(hashMappedList);
    }

    void createTable(Session session) {
        this.createResultTable(session);
        this.mainIndex = this.resultTable.getPrimaryIndex();
        if (this.sortAndSlice.hasOrder()) {
            this.orderIndex = this.resultTable.createAndAddIndexStructure(session, null, this.sortAndSlice.sortOrder, this.sortAndSlice.sortDescending, this.sortAndSlice.sortNullsLast, false, false, false);
        }
        int[] nArray = new int[this.columnCount];
        ArrayUtil.fillSequence(nArray);
        this.resultTable.fullIndex = this.fullIndex = this.resultTable.createAndAddIndexStructure(session, null, nArray, null, null, false, false, false);
    }

    void createResultTable(Session session) {
        HsqlNameManager.HsqlName hsqlName = session.database.nameManager.getSubqueryTableName();
        int n = this.persistenceScope == 21 ? 2 : 9;
        HashMappedList hashMappedList = this.leftQueryExpression.getUnionColumns();
        try {
            this.resultTable = new TableDerived(session.database, hsqlName, n, this.unionColumnTypes, hashMappedList, null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setColumnsDefined() {
        if (this.leftQueryExpression != null) {
            this.leftQueryExpression.setColumnsDefined();
        }
    }

    public void setReturningResult() {
        if (this.compileContext.getSequences().length > 0) {
            throw Error.error(5598);
        }
        this.isTopLevel = true;
        this.setReturningResultSet();
    }

    void setReturningResultSet() {
        if (this.unionCorresponding) {
            this.persistenceScope = 23;
            return;
        }
        this.leftQueryExpression.setReturningResultSet();
    }

    private HashMappedList getUnionColumns() {
        if (this.unionCorresponding || this.leftQueryExpression == null) {
            HashMappedList hashMappedList = ((TableDerived)this.resultTable).columnList;
            HashMappedList hashMappedList2 = new HashMappedList();
            for (int i = 0; i < this.unionColumnMap.length; ++i) {
                ColumnSchema columnSchema = (ColumnSchema)hashMappedList.get(i);
                hashMappedList2.add(columnSchema.getName().name, columnSchema);
            }
            return hashMappedList2;
        }
        return this.leftQueryExpression.getUnionColumns();
    }

    public HsqlNameManager.HsqlName[] getResultColumnNames() {
        if (this.resultTable == null) {
            return this.leftQueryExpression.getResultColumnNames();
        }
        HashMappedList hashMappedList = ((TableDerived)this.resultTable).columnList;
        HsqlNameManager.HsqlName[] hsqlNameArray = new HsqlNameManager.HsqlName[hashMappedList.size()];
        for (int i = 0; i < hsqlNameArray.length; ++i) {
            hsqlNameArray[i] = ((ColumnSchema)hashMappedList.get(i)).getName();
        }
        return hsqlNameArray;
    }

    public TableBase getResultTable() {
        if (this.resultTable != null) {
            return this.resultTable;
        }
        if (this.leftQueryExpression != null) {
            return this.leftQueryExpression.getResultTable();
        }
        return null;
    }

    public Table getBaseTable() {
        return null;
    }

    public boolean isUpdatable() {
        return this.isUpdatable;
    }

    public boolean isInsertable() {
        return this.isInsertable;
    }

    public int[] getBaseTableColumnMap() {
        return null;
    }

    public Expression getCheckCondition() {
        return null;
    }

    public boolean hasReference(RangeVariable rangeVariable) {
        if (this.leftQueryExpression.hasReference(rangeVariable)) {
            return true;
        }
        return this.rightQueryExpression.hasReference(rangeVariable);
    }

    void getBaseTableNames(OrderedHashSet orderedHashSet) {
        this.leftQueryExpression.getBaseTableNames(orderedHashSet);
        this.rightQueryExpression.getBaseTableNames(orderedHashSet);
    }

    boolean isEquivalent(QueryExpression queryExpression) {
        return this.leftQueryExpression.isEquivalent(queryExpression.leftQueryExpression) && this.unionType == queryExpression.unionType && (this.rightQueryExpression == null ? queryExpression.rightQueryExpression == null : this.rightQueryExpression.isEquivalent(queryExpression.rightQueryExpression));
    }

    public void replaceColumnReference(RangeVariable rangeVariable, Expression[] expressionArray) {
        this.leftQueryExpression.replaceColumnReference(rangeVariable, expressionArray);
        this.rightQueryExpression.replaceColumnReference(rangeVariable, expressionArray);
    }

    public void replaceRangeVariables(RangeVariable[] rangeVariableArray, RangeVariable[] rangeVariableArray2) {
        this.leftQueryExpression.replaceRangeVariables(rangeVariableArray, rangeVariableArray2);
        this.rightQueryExpression.replaceRangeVariables(rangeVariableArray, rangeVariableArray2);
    }
}

