/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.io;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import marytts.exceptions.MaryConfigurationException;

public class PropertiesAccessor {
    private boolean isSystemOverrides;
    private Map<String, String> replacements;
    private Properties p;

    public PropertiesAccessor(Properties p) {
        this(p, false, null);
    }

    public PropertiesAccessor(Properties p, boolean letSystemPropertiesOverride, Map<String, String> stringReplacements) {
        this.p = p;
        this.isSystemOverrides = letSystemPropertiesOverride;
        this.replacements = stringReplacements;
    }

    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    public String getProperty(String key, String defaultValue) {
        String value = this.isSystemOverrides && System.getProperties().contains(key) ? System.getProperty(key) : this.p.getProperty(key, defaultValue);
        if (value != null && this.replacements != null) {
            for (String s : this.replacements.keySet()) {
                if (!value.contains(s)) continue;
                value = value.replace(s, this.replacements.get(s));
            }
        }
        return value;
    }

    public boolean getBoolean(String property) {
        return this.getBoolean(property, false);
    }

    public boolean getBoolean(String property, boolean defaultValue) {
        String value = this.getProperty(property);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Boolean.valueOf(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public int getInteger(String property) {
        return this.getInteger(property, -1);
    }

    public int getInteger(String property, int defaultValue) {
        String value = this.getProperty(property);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.decode(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public double getDouble(String property) {
        return this.getDouble(property, Double.NaN);
    }

    public double getDouble(String property, double defaultValue) {
        String value = this.getProperty(property);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public InputStream getStream(String propertyName) throws FileNotFoundException, MaryConfigurationException {
        InputStream stream;
        String propertyValue = this.getProperty(propertyName);
        if (propertyValue == null) {
            return null;
        }
        if (propertyValue.startsWith("jar:")) {
            String classpathLocation = propertyValue.substring("jar:".length());
            stream = this.getClass().getResourceAsStream(classpathLocation);
            if (stream == null) {
                throw new MaryConfigurationException("For property '" + propertyName + "', no classpath resource available at '" + classpathLocation + "'");
            }
        } else {
            String fileName = propertyValue;
            stream = new FileInputStream(fileName);
        }
        return stream;
    }
}

