/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.io;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;

public class LittleEndianBinaryReader {
    private DataInputStream inputStream;
    private long accumLong;
    private int accumInt;
    private int shiftBy;
    private int low;
    private int high;

    public LittleEndianBinaryReader(DataInputStream d) {
        this.inputStream = d;
    }

    public LittleEndianBinaryReader(FileInputStream f) {
        this(new DataInputStream(f));
    }

    public LittleEndianBinaryReader(String filename) throws IOException {
        this(new DataInputStream(new FileInputStream(filename)));
    }

    public short readShort() throws IOException {
        this.low = this.inputStream.readByte() & 0xFF;
        this.high = this.inputStream.readByte() & 0xFF;
        return (short)(this.high << 8 | this.low);
    }

    public long readLong() throws IOException {
        this.accumLong = 0L;
        this.shiftBy = 0;
        while (this.shiftBy < 64) {
            this.accumLong |= (long)(this.inputStream.readByte() & 0xFF) << this.shiftBy;
            this.shiftBy += 8;
        }
        return this.accumLong;
    }

    public char readChar() throws IOException {
        this.low = this.inputStream.readByte() & 0xFF;
        this.high = this.inputStream.readByte();
        return (char)(this.high << 8 | this.low);
    }

    public int readInt() throws IOException {
        this.accumInt = 0;
        this.shiftBy = 0;
        while (this.shiftBy < 32) {
            this.accumInt |= (this.inputStream.readByte() & 0xFF) << this.shiftBy;
            this.shiftBy += 8;
        }
        return this.accumInt;
    }

    public double readDouble() throws IOException {
        this.accumLong = 0L;
        this.shiftBy = 0;
        while (this.shiftBy < 64) {
            this.accumLong |= (long)(this.inputStream.readByte() & 0xFF) << this.shiftBy;
            this.shiftBy += 8;
        }
        return Double.longBitsToDouble(this.accumLong);
    }

    public float readFloat() throws IOException {
        this.accumInt = 0;
        this.shiftBy = 0;
        while (this.shiftBy < 32) {
            this.accumInt |= (this.inputStream.readByte() & 0xFF) << this.shiftBy;
            this.shiftBy += 8;
        }
        return Float.intBitsToFloat(this.accumInt);
    }

    public byte readByte() throws IOException {
        return this.inputStream.readByte();
    }

    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
        }
    }
}

