/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.data;

import marytts.util.data.DoubleDataSource;

public class BaseDoubleDataSource
implements DoubleDataSource {
    protected DoubleDataSource inputSource = null;
    protected long dataLength = -1L;

    public BaseDoubleDataSource() {
    }

    public BaseDoubleDataSource(DoubleDataSource inputSource) {
        this.inputSource = inputSource;
        if (inputSource != null) {
            this.dataLength = inputSource.getDataLength();
        }
    }

    @Override
    public double[] getData(int amount) {
        if (amount <= 0) {
            throw new IllegalArgumentException("amount must be positive");
        }
        double[] container = new double[amount];
        int received = this.getData(container);
        if (received == 0) {
            return null;
        }
        if (received < amount) {
            double[] newContainer = new double[received];
            System.arraycopy(container, 0, newContainer, 0, received);
            return newContainer;
        }
        return container;
    }

    @Override
    public int getData(double[] target) {
        return this.getData(target, 0, target.length);
    }

    @Override
    public int getData(double[] target, int targetPos, int length) {
        if (target.length - targetPos < length) {
            throw new IllegalArgumentException("Target array cannot hold enough data (" + (target.length - targetPos) + " left, but " + length + " requested)");
        }
        if (this.inputSource == null) {
            return 0;
        }
        return this.inputSource.getData(target, targetPos, length);
    }

    @Override
    public boolean hasMoreData() {
        if (this.inputSource == null) {
            return false;
        }
        return this.inputSource.hasMoreData();
    }

    @Override
    public int available() {
        if (this.inputSource == null) {
            return 0;
        }
        return this.inputSource.available();
    }

    @Override
    public double[] getAllData() {
        double[] all = new double[8192];
        int currentPos = 0;
        while (this.hasMoreData()) {
            int nRead = this.getData(all, currentPos, all.length - currentPos);
            if (nRead < all.length - currentPos) {
                assert (!this.hasMoreData());
                currentPos += nRead;
                break;
            }
            assert (currentPos + nRead == all.length);
            double[] newAll = new double[2 * all.length];
            System.arraycopy(all, 0, newAll, 0, all.length);
            currentPos = all.length;
            all = newAll;
        }
        double[] result = new double[currentPos];
        System.arraycopy(all, 0, result, 0, currentPos);
        return result;
    }

    @Override
    public long getDataLength() {
        return this.dataLength;
    }
}

