/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection.select;

import marytts.features.FeatureVector;
import marytts.features.MaryGenericFeatureProcessors;
import marytts.modules.phonemiser.Allophone;
import marytts.modules.phonemiser.AllophoneSet;
import marytts.modules.synthesis.Voice;
import marytts.util.MaryRuntimeUtils;
import marytts.util.dom.MaryDomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.UserDataHandler;

public class Target {
    protected String name;
    protected Element maryxmlElement;
    protected FeatureVector featureVector = null;
    protected float duration = -1.0f;
    protected float f0 = -1.0f;
    protected int isSilence = -1;
    public static UserDataHandler targetFeatureCloner = new UserDataHandler(){

        @Override
        public void handle(short operation, String key, Object data, Node src, Node dest) {
            if (operation == 1 && key == "target") {
                dest.setUserData(key, data, this);
                System.err.println("yay");
            } else {
                System.err.println("nay");
            }
        }
    };

    public Target(String name, Element maryxmlElement) {
        this.name = name;
        this.maryxmlElement = maryxmlElement;
    }

    public Element getMaryxmlElement() {
        return this.maryxmlElement;
    }

    public String getName() {
        return this.name;
    }

    public FeatureVector getFeatureVector() {
        return this.featureVector;
    }

    public void setFeatureVector(FeatureVector featureVector) {
        this.featureVector = featureVector;
    }

    public float getTargetDurationInSeconds() {
        if (this.duration != -1.0f) {
            return this.duration;
        }
        if (this.maryxmlElement == null) {
            return 0.0f;
        }
        this.duration = new MaryGenericFeatureProcessors.UnitDuration().process(this);
        return this.duration;
    }

    public void setTargetDurationInSeconds(float newDuration) {
        if (this.maryxmlElement != null) {
            if (this.maryxmlElement.getTagName().equals("ph")) {
                this.maryxmlElement.setAttribute("d", Float.toString(newDuration));
            } else {
                assert (this.maryxmlElement.getTagName().equals("boundary")) : "segment should be a phone or a boundary, but is a " + this.maryxmlElement.getTagName();
                this.maryxmlElement.setAttribute("duration", Float.toString(newDuration));
            }
        }
    }

    public float getTargetF0InHz() {
        if (this.f0 != -1.0f) {
            return this.f0;
        }
        if (this.maryxmlElement == null) {
            throw new NullPointerException("Target " + this.name + " does not have a maryxml element.");
        }
        float logf0 = new MaryGenericFeatureProcessors.UnitLogF0().process(this);
        this.f0 = logf0 == 0.0f ? 0.0f : (float)Math.exp(logf0);
        return this.f0;
    }

    public boolean hasFeatureVector() {
        return this.featureVector != null;
    }

    public boolean isSilence() {
        if (this.isSilence == -1) {
            String silenceSymbol = "_";
            this.isSilence = this.name.startsWith(silenceSymbol) ? 1 : 0;
        }
        return this.isSilence == 1;
    }

    public Allophone getAllophone() {
        if (this.maryxmlElement != null) {
            String sampa;
            Voice v;
            AllophoneSet allophoneSet = null;
            Element voiceElement = (Element)MaryDomUtils.getAncestor((Node)this.maryxmlElement, "voice");
            if (voiceElement != null && (v = Voice.getVoice(voiceElement)) != null) {
                allophoneSet = v.getAllophoneSet();
            }
            if (allophoneSet == null) {
                try {
                    allophoneSet = MaryRuntimeUtils.determineAllophoneSet(this.maryxmlElement);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.maryxmlElement.getNodeName().equals("ph")) {
                sampa = this.maryxmlElement.getAttribute("p");
            } else {
                assert (this.maryxmlElement.getNodeName().equals("boundary"));
                sampa = "_";
            }
            return allophoneSet.getAllophone(sampa);
        }
        return null;
    }

    public String toString() {
        return this.name;
    }
}

