/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection.data;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import marytts.exceptions.MaryConfigurationException;
import marytts.util.data.MaryHeader;

public class SCostFileReader {
    private MaryHeader hdr = null;
    private int numberOfUnits = 0;
    private double[] sCost;

    public SCostFileReader() {
    }

    public SCostFileReader(String fileName) throws IOException, MaryConfigurationException {
        this.load(fileName);
    }

    public void load(String fileName) throws IOException, MaryConfigurationException {
        DataInputStream dis = null;
        try {
            dis = new DataInputStream(new BufferedInputStream(new FileInputStream(fileName)));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("File [" + fileName + "] was not found.");
        }
        try {
            this.hdr = new MaryHeader(dis);
            if (this.hdr.getType() != 445) {
                throw new RuntimeException("File [" + fileName + "] is not a valid Mary Units file.");
            }
            this.numberOfUnits = dis.readInt();
            if (this.numberOfUnits < 0) {
                throw new RuntimeException("File [" + fileName + "] has a negative number of units. Aborting.");
            }
            this.sCost = new double[this.numberOfUnits];
            for (int i = 0; i < this.numberOfUnits; ++i) {
                this.sCost[i] = dis.readFloat();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Reading the Mary header from file [" + fileName + "] failed.", e);
        }
    }

    public int getNumberOfUnits() {
        return this.numberOfUnits;
    }

    public double getSCost(int index) {
        return this.sCost[index];
    }
}

