/*
 * Decompiled with CFR 0.152.
 */
package marytts.tools.install;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import marytts.tools.install.ComponentDescription;
import marytts.tools.install.LanguageComponentDescription;
import marytts.tools.install.LanguagePanel;
import marytts.tools.install.VoiceComponentDescription;
import marytts.tools.install.VoicePanel;
import marytts.tools.install.VoiceUpdateListener;

public class ShortDescriptionPanel
extends JPanel
implements Observer {
    private ComponentDescription desc;
    private VoiceUpdateListener voiceUpdate;
    private Color selectedColor = new Color(102, 153, 255);
    private Color unselectedColor;
    private boolean isSelected = false;
    private JButton bDetails;
    private JCheckBox cbSelected;
    private JLabel lStatus;

    public ShortDescriptionPanel(ComponentDescription desc, VoiceUpdateListener voiceUpdate) {
        this.desc = desc;
        desc.addObserver(this);
        this.voiceUpdate = voiceUpdate;
        this.initComponents();
        this.unselectedColor = this.getBackground();
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, (int)this.getPreferredSize().getHeight()));
        this.verifyDisplay();
    }

    private void initComponents() {
        this.cbSelected = new JCheckBox();
        this.bDetails = new JButton();
        this.lStatus = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createBevelBorder(0));
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ShortDescriptionPanel.this.formFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                ShortDescriptionPanel.this.formFocusLost(evt);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ShortDescriptionPanel.this.formMouseClicked(evt);
            }
        });
        this.cbSelected.setText(this.desc.getName());
        this.cbSelected.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbSelected.setMargin(new Insets(0, 0, 0, 0));
        this.cbSelected.setPreferredSize(new Dimension(200, 18));
        this.cbSelected.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ShortDescriptionPanel.this.cbSelectedItemStateChanged(evt);
            }
        });
        this.cbSelected.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ShortDescriptionPanel.this.formFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                ShortDescriptionPanel.this.formFocusLost(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.cbSelected, gridBagConstraints);
        this.bDetails.setText("Details");
        this.bDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShortDescriptionPanel.this.bDetailsActionPerformed(evt);
            }
        });
        this.bDetails.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ShortDescriptionPanel.this.formFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                ShortDescriptionPanel.this.formFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.add((Component)this.bDetails, gridBagConstraints);
        this.lStatus.setFont(new Font("Lucida Grande", 0, 10));
        this.lStatus.setHorizontalAlignment(0);
        this.lStatus.setText(this.desc.isUpdateAvailable() ? "Update available" : this.desc.getStatus().toString());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        this.add((Component)this.lStatus, gridBagConstraints);
    }

    private void cbSelectedItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.desc.setSelected(true);
        } else if (evt.getStateChange() == 2) {
            this.desc.setSelected(false);
        }
    }

    private void formMouseClicked(MouseEvent evt) {
        this.requestFocusInWindow();
    }

    private void formFocusLost(FocusEvent evt) {
        this.setSelected(false);
    }

    private void formFocusGained(FocusEvent evt) {
        this.setSelected(true);
    }

    private void bDetailsActionPerformed(ActionEvent evt) {
        this.showComponentDetails(this.desc);
    }

    private void setSelected(boolean newSelected) {
        if (!this.isSelected && newSelected) {
            this.isSelected = true;
            this.setBackground(this.selectedColor);
            this.cbSelected.setBackground(this.selectedColor);
            if (this.voiceUpdate != null && this.desc instanceof LanguageComponentDescription) {
                this.voiceUpdate.updateVoices((LanguageComponentDescription)this.desc, false);
            }
        } else if (this.isSelected && !newSelected) {
            this.isSelected = false;
            this.setBackground(this.unselectedColor);
            this.cbSelected.setBackground(this.unselectedColor);
        }
    }

    private void showComponentDetails(ComponentDescription aDesc) {
        JPanel p = aDesc instanceof LanguageComponentDescription ? new LanguagePanel((LanguageComponentDescription)aDesc) : new VoicePanel((VoiceComponentDescription)aDesc);
        JOptionPane.showMessageDialog(null, p, "Component details", -1);
    }

    @Override
    public void update(Observable o, Object arg) {
        this.verifyDisplay();
    }

    private void verifyDisplay() {
        this.cbSelected.setSelected(this.desc.isSelected());
        this.lStatus.setText(this.desc.isUpdateAvailable() ? "Update available" : this.desc.getStatus().toString());
    }
}

