/*
 * Decompiled with CFR 0.152.
 */
package marytts.tools.install;

import java.io.IOException;
import java.net.URL;
import java.util.SortedSet;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import marytts.tools.install.ComponentDescription;
import org.jdesktop.layout.GroupLayout;

public class LicensePanel
extends JPanel {
    private JScrollPane jScrollPane1;
    private JTextPane licenseTextPane;
    private JLabel questionText;

    public LicensePanel(URL licenseURL, SortedSet<ComponentDescription> comps) {
        this.initComponents();
        StringBuilder sb = new StringBuilder();
        boolean isSingle = comps.size() == 1;
        sb.append("The component");
        if (isSingle) {
            sb.append("s");
        }
        sb.append(":\n");
        boolean isFirst = true;
        for (ComponentDescription cd : comps) {
            if (!isFirst) {
                sb.append(", ");
            }
            sb.append(cd.getName());
            isFirst = false;
        }
        sb.append("\n");
        sb.append(isSingle ? "is" : "are");
        sb.append(" governed by the following license.");
        this.questionText.setText(sb.toString());
        try {
            this.licenseTextPane.setPage(licenseURL);
        }
        catch (IOException ioe) {
            this.licenseTextPane.setText("Unknown license -- only proceed if you are certain you have the right to install these components!");
            ioe.printStackTrace();
        }
    }

    private void initComponents() {
        this.questionText = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.licenseTextPane = new JTextPane();
        this.jScrollPane1.setViewportView(this.licenseTextPane);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(2).add(1, this.jScrollPane1, -1, 462, Short.MAX_VALUE).add(1, this.questionText, -1, 462, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.questionText, -2, 58, -2).addPreferredGap(0).add(this.jScrollPane1, -1, 460, Short.MAX_VALUE).addContainerGap()));
    }
}

