/*
 * Decompiled with CFR 0.152.
 */
package marytts.tools.emospeak;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import marytts.tools.emospeak.TwoDimensionalModel;

public class RectangularTwoDimensionalModel
implements TwoDimensionalModel {
    private int x;
    private int y;
    private int minX;
    private int maxX;
    private int minY;
    private int maxY;
    private List changeListeners = new ArrayList();

    public RectangularTwoDimensionalModel() {
        this(0, 0, 0, 0, 0, 0);
    }

    public RectangularTwoDimensionalModel(int x, int y, int minX, int maxX, int minY, int maxY) {
        this.x = x;
        this.y = y;
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        if (!this.changeListeners.contains(l)) {
            this.changeListeners.add(l);
        }
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove(l);
    }

    private void notifyChangeListeners() {
        Iterator it = this.changeListeners.iterator();
        ChangeEvent e = new ChangeEvent(this);
        while (it.hasNext()) {
            ChangeListener l = (ChangeListener)it.next();
            l.stateChanged(e);
        }
    }

    @Override
    public void setMaxX(int maxX) {
        this.maxX = maxX;
    }

    @Override
    public void setMaxY(int maxY) {
        this.maxY = maxY;
    }

    @Override
    public void setMinX(int minX) {
        this.minX = minX;
    }

    @Override
    public void setMinY(int minY) {
        this.minY = minY;
    }

    @Override
    public void setX(int x) {
        if (this.minX <= x && x <= this.maxX) {
            this.x = x;
            this.notifyChangeListeners();
        }
    }

    @Override
    public void setXY(int x, int y) {
        if (this.minX <= x && x <= this.maxX && this.minY <= y && y <= this.maxY) {
            this.x = x;
            this.y = y;
            this.notifyChangeListeners();
        }
    }

    @Override
    public void setY(int y) {
        if (this.minY <= y && y <= this.maxY) {
            this.y = y;
            this.notifyChangeListeners();
        }
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getMaxX() {
        return this.maxX;
    }

    @Override
    public int getMinX() {
        return this.minX;
    }

    @Override
    public int getMaxY() {
        return this.maxY;
    }

    @Override
    public int getMinY() {
        return this.minY;
    }
}

