/*
 * Decompiled with CFR 0.152.
 */
package marytts.tools.emospeak;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import marytts.tools.emospeak.RectangularTwoDimensionalModel;
import marytts.tools.emospeak.TwoDimensionalModel;

public class JFeeltraceCircle
extends JPanel {
    private boolean isCircular = true;
    private int circleSize;
    private int cursorDiameter = 30;
    private RectangularShape feeltraceShape;
    private TwoDimensionalModel normalizedModel = new RectangularTwoDimensionalModel(0, 0, -100, 100, -100, 100);
    private Dimension requestedSize = new Dimension(200, 200);

    public int getCursorDiameter() {
        return this.cursorDiameter;
    }

    public void setCursorDiameter(int d) {
        this.cursorDiameter = d;
    }

    public void setRequestedSize(Dimension requestedSize) {
        this.requestedSize = requestedSize;
    }

    public Dimension getRequestedSize() {
        return this.requestedSize;
    }

    public JFeeltraceCircle(boolean isCircular, Dimension requestedSize) {
        this.isCircular = isCircular;
        this.requestedSize = requestedSize;
        this.initComponents();
        this.customInitComponents();
    }

    public JFeeltraceCircle() {
        this.initComponents();
        this.customInitComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                JFeeltraceCircle.this.formMousePressed(evt);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                JFeeltraceCircle.this.formMouseDragged(evt);
            }
        });
    }

    private void formMousePressed(MouseEvent evt) {
        this.setFeeltraceCursor(evt.getPoint());
        this.repaint();
    }

    private void formMouseDragged(MouseEvent evt) {
        this.setFeeltraceCursor(evt.getPoint());
        this.repaint();
    }

    private void customInitComponents() {
        this.feeltraceShape = this.isCircular ? new Ellipse2D.Float() : new Rectangle2D.Float();
        this.normalizedModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JFeeltraceCircle.this.repaint();
            }
        });
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Insets insets = this.getInsets();
        int currentWidth = this.getWidth() - insets.left - insets.right;
        int currentHeight = this.getHeight() - insets.top - insets.bottom;
        int offsetX = insets.left;
        int offsetY = insets.top;
        if (currentWidth >= currentHeight) {
            this.circleSize = currentHeight;
            offsetX += (currentWidth - this.circleSize) / 2;
        } else {
            this.circleSize = currentWidth;
            offsetY += (currentHeight - this.circleSize) / 2;
        }
        if (this.isCircular) {
            graphics.setColor(Color.white);
            graphics.fillOval(offsetX, offsetY, this.circleSize, this.circleSize);
            graphics.setColor(Color.black);
            graphics.drawOval(offsetX, offsetY, this.circleSize, this.circleSize);
            graphics.drawLine(offsetX, offsetY + this.circleSize / 2, offsetX + this.circleSize, offsetY + this.circleSize / 2);
            graphics.drawLine(offsetX + this.circleSize / 2, offsetY, offsetX + this.circleSize / 2, offsetY + this.circleSize);
        } else {
            graphics.setColor(Color.white);
            graphics.fillRect(offsetX, offsetY, this.circleSize, this.circleSize);
            graphics.setColor(Color.black);
            graphics.drawRect(offsetX, offsetY, this.circleSize, this.circleSize);
            graphics.drawLine(offsetX, offsetY + this.circleSize / 2, offsetX + this.circleSize, offsetY + this.circleSize / 2);
            graphics.drawLine(offsetX + this.circleSize / 2, offsetY, offsetX + this.circleSize / 2, offsetY + this.circleSize);
        }
        this.feeltraceShape.setFrame(offsetX, offsetY, this.circleSize, this.circleSize);
        int x = (int)(this.feeltraceShape.getCenterX() + (double)this.normalizedModel.getX() * (this.feeltraceShape.getMaxX() - this.feeltraceShape.getCenterX()) / (double)this.normalizedModel.getMaxX());
        int y = (int)(this.feeltraceShape.getCenterY() - (double)this.normalizedModel.getY() * (this.feeltraceShape.getMaxY() - this.feeltraceShape.getCenterY()) / (double)this.normalizedModel.getMaxY());
        graphics.setColor(Color.green);
        graphics.fillOval(x - this.cursorDiameter / 2, y - this.cursorDiameter / 2, this.cursorDiameter, this.cursorDiameter);
    }

    private void setFeeltraceCursor(Point p) {
        Point newLocation;
        if (this.feeltraceShape.contains(p)) {
            newLocation = p;
        } else if (this.isCircular) {
            double px = p.getX() - this.feeltraceShape.getCenterX();
            double py = p.getY() - this.feeltraceShape.getCenterY();
            if (py == 0.0) {
                newLocation = new Point((int)this.feeltraceShape.getCenterX() + this.circleSize, (int)this.feeltraceShape.getCenterY());
            } else {
                double y = (double)(this.circleSize / 2) / Math.sqrt(1.0 + px * px / (py * py));
                if (py < 0.0) {
                    y = -y;
                }
                double x = px / py * y;
                newLocation = new Point((int)(this.feeltraceShape.getCenterX() + x), (int)(this.feeltraceShape.getCenterY() + y));
            }
        } else {
            return;
        }
        this.normalizedModel.setXY((int)((newLocation.getX() - this.feeltraceShape.getCenterX()) / (this.feeltraceShape.getMaxX() - this.feeltraceShape.getCenterX()) * (double)this.normalizedModel.getMaxX()), -((int)((newLocation.getY() - this.feeltraceShape.getCenterY()) / (this.feeltraceShape.getMaxY() - this.feeltraceShape.getCenterY()) * (double)this.normalizedModel.getMaxY())));
    }

    public void setNormalizedLocation(int x, int y) {
        this.normalizedModel.setXY(x, y);
    }

    public void setNormalizedX(int x) {
        this.normalizedModel.setX(x);
    }

    public void setNormalizedY(int y) {
        this.normalizedModel.setY(y);
    }

    public int getNormalizedX() {
        return this.normalizedModel.getX();
    }

    public int getNormalizedY() {
        return this.normalizedModel.getY();
    }

    public TwoDimensionalModel getNormalizedModel() {
        return this.normalizedModel;
    }
}

