/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal.pitch;

import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.signalproc.analysis.PitchMarks;
import marytts.signalproc.analysis.PitchReaderWriter;
import marytts.signalproc.sinusoidal.NonharmonicSinusoidalSpeechFrame;
import marytts.signalproc.sinusoidal.NonharmonicSinusoidalSpeechSignal;
import marytts.signalproc.sinusoidal.PitchSynchronousSinusoidalAnalyzer;
import marytts.signalproc.sinusoidal.SinusoidalAnalysisParams;
import marytts.signalproc.sinusoidal.pitch.BaseSinusoidalPitchTracker;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.signal.SignalProcUtils;

public class CombFilterPitchTracker
extends BaseSinusoidalPitchTracker {
    @Override
    public double performanceCriterion(NonharmonicSinusoidalSpeechFrame sinFrame, float f0Candidate, int samplingRate) {
        int endIndex;
        double Q = 0.0;
        float f0CandidateInRadians = SignalProcUtils.hz2radian(f0Candidate, samplingRate);
        for (endIndex = 0; sinFrame.sinusoids[endIndex].freq < f0CandidateInRadians && endIndex < sinFrame.sinusoids.length - 1; ++endIndex) {
        }
        for (int k = 0; k <= endIndex; ++k) {
            Q += (double)(sinFrame.sinusoids[k].amp * sinFrame.sinusoids[k].amp) * Math.cos(Math.PI * 2 * (double)SignalProcUtils.radian2hz(sinFrame.sinusoids[k].freq, samplingRate) / (double)f0Candidate);
        }
        return Q;
    }

    public static void main(String[] args) throws UnsupportedAudioFileException, IOException {
        AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(args[0]));
        int samplingRate = (int)inputAudio.getFormat().getSampleRate();
        AudioDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
        double[] x = signal.getAllData();
        float searchStepInHz = 0.5f;
        float minFreqInHz = 40.0f;
        float maxFreqInHz = 400.0f;
        float windowSizeInSeconds = 0.02f;
        float skipSizeInSeconds = 0.01f;
        float deltaInHz = 50.0f;
        int windowType = 1;
        double startFreqInHz = 0.0;
        double endFreqInHz = 0.5 * (double)samplingRate;
        boolean bRefinePeakEstimatesParabola = true;
        boolean bRefinePeakEstimatesBias = true;
        boolean bSpectralReassignment = true;
        boolean bAdjustNeighFreqDependent = true;
        SinusoidalAnalysisParams params = new SinusoidalAnalysisParams(samplingRate, startFreqInHz, endFreqInHz, windowType, bRefinePeakEstimatesParabola, bRefinePeakEstimatesBias, bSpectralReassignment, bAdjustNeighFreqDependent);
        String strPitchFileIn = args[0].substring(0, args[0].length() - 4) + ".ptc";
        PitchReaderWriter f0 = new PitchReaderWriter(strPitchFileIn);
        int pitchMarkOffset = 0;
        PitchMarks pm = SignalProcUtils.pitchContour2pitchMarks(f0.contour, samplingRate, x.length, f0.header.windowSizeInSeconds, f0.header.skipSizeInSeconds, true, pitchMarkOffset);
        PitchSynchronousSinusoidalAnalyzer sa = new PitchSynchronousSinusoidalAnalyzer(params);
        NonharmonicSinusoidalSpeechSignal ss = sa.extractSinusoidsFixedRate(x, windowSizeInSeconds, skipSizeInSeconds, deltaInHz);
        CombFilterPitchTracker p = new CombFilterPitchTracker();
        float[] f0s = p.pitchTrack(ss, samplingRate, searchStepInHz, minFreqInHz, maxFreqInHz);
        String strPitchFileOut = args[0].substring(0, args[0].length() - 4) + ".ptcSin";
        PitchReaderWriter.write_pitch_file(strPitchFileOut, f0s, windowSizeInSeconds, skipSizeInSeconds, samplingRate);
        for (int i = 0; i < f0s.length; ++i) {
            System.out.println(String.valueOf((float)i * skipSizeInSeconds + 0.5f * windowSizeInSeconds) + " sec. = " + String.valueOf(f0s[i]));
        }
    }
}

