/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal.hntm.analysis;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import marytts.signalproc.sinusoidal.hntm.analysis.FrameNoisePartLpc;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmSpeechFrame;
import marytts.util.math.ArrayUtils;

public class HntmSpeechSignal {
    public HntmSpeechFrame[] frames;
    public int samplingRateInHz;
    public float originalDurationInSeconds;

    public HntmSpeechSignal(HntmSpeechSignal existing) {
        this.frames = null;
        if (existing != null) {
            if (existing.frames != null) {
                this.frames = new HntmSpeechFrame[existing.frames.length];
                for (int i = 0; i < existing.frames.length; ++i) {
                    this.frames[i] = new HntmSpeechFrame(existing.frames[i]);
                }
            }
            this.samplingRateInHz = existing.samplingRateInHz;
            this.originalDurationInSeconds = existing.originalDurationInSeconds;
        }
    }

    public HntmSpeechSignal(int totalFrm, int samplingRateInHz, float originalDurationInSeconds) {
        if (totalFrm > 0) {
            this.frames = new HntmSpeechFrame[totalFrm];
            for (int i = 0; i < totalFrm; ++i) {
                this.frames[i] = new HntmSpeechFrame();
            }
        } else {
            this.frames = null;
        }
        this.samplingRateInHz = samplingRateInHz;
        this.originalDurationInSeconds = originalDurationInSeconds;
    }

    public HntmSpeechSignal(String binaryFile, int noiseModel) {
        try {
            this.read(binaryFile, noiseModel);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void write(String binaryFile) throws IOException {
        DataOutputStream d = new DataOutputStream(new FileOutputStream(new File(binaryFile)));
        this.write(d);
    }

    public void write(DataOutputStream d) throws IOException {
        int totalFrm = 0;
        if (this.frames != null && this.frames.length > 0) {
            totalFrm = this.frames.length;
        }
        d.writeInt(totalFrm);
        if (totalFrm > 0) {
            for (int i = 0; i < totalFrm; ++i) {
                this.frames[i].write(d);
            }
        }
        d.writeInt(this.samplingRateInHz);
        d.writeFloat(this.originalDurationInSeconds);
    }

    public void read(String binaryFile, int noiseModel) throws IOException {
        DataInputStream d = new DataInputStream(new FileInputStream(new File(binaryFile)));
        this.read(d, noiseModel);
    }

    public void read(DataInputStream d, int noiseModel) throws IOException {
        int totalFrm = d.readInt();
        this.frames = null;
        if (totalFrm > 0) {
            this.frames = new HntmSpeechFrame[totalFrm];
            for (int i = 0; i < totalFrm; ++i) {
                this.frames[i] = new HntmSpeechFrame(d, noiseModel);
            }
        }
        this.samplingRateInHz = d.readInt();
        this.originalDurationInSeconds = d.readFloat();
    }

    public float[] getAnalysisTimes() {
        float[] times = null;
        if (this.frames != null) {
            times = new float[this.frames.length];
            for (int i = 0; i < this.frames.length; ++i) {
                times[i] = this.frames[i].tAnalysisInSeconds;
            }
        }
        return times;
    }

    public double[][] getPhasesInRadians() {
        Object phases = null;
        if (this.frames != null && this.frames.length > 0) {
            phases = new double[this.frames.length][];
            for (int i = 0; i < this.frames.length; ++i) {
                if (this.frames[i].h == null) continue;
                phases[i] = this.frames[i].h.getPhasesInRadians();
            }
        }
        return phases;
    }

    public float[][] getLpcsAll() {
        Object lpcsAll = null;
        if (this.frames != null && this.frames.length > 0) {
            lpcsAll = new float[this.frames.length][];
            for (int i = 0; i < this.frames.length; ++i) {
                if (!(this.frames[i].n instanceof FrameNoisePartLpc)) continue;
                lpcsAll[i] = ArrayUtils.copy(((FrameNoisePartLpc)this.frames[i].n).lpCoeffs);
            }
        }
        return lpcsAll;
    }

    public float[] getLpcGainsAll() {
        float[] gainsAll = null;
        if (this.frames != null && this.frames.length > 0) {
            gainsAll = new float[this.frames.length];
            for (int i = 0; i < this.frames.length; ++i) {
                gainsAll[i] = this.frames[i].n instanceof FrameNoisePartLpc ? ((FrameNoisePartLpc)this.frames[i].n).lpGain : -1.0f;
            }
        }
        return gainsAll;
    }

    public float[] getOrigNoiseStds() {
        float[] origNoiseStdsAll = null;
        if (this.frames != null && this.frames.length > 0) {
            origNoiseStdsAll = new float[this.frames.length];
            for (int i = 0; i < this.frames.length; ++i) {
                if (this.frames[i].n == null || !(this.frames[i].n instanceof FrameNoisePartLpc)) continue;
                origNoiseStdsAll[i] = ((FrameNoisePartLpc)this.frames[i].n).origNoiseStd;
            }
        }
        return origNoiseStdsAll;
    }

    public double[] getMaximumFrequencyOfVoicings() {
        double[] maximumFrequencyOfVoicings = null;
        if (this.frames != null && this.frames.length > 0) {
            maximumFrequencyOfVoicings = new double[this.frames.length];
            for (int i = 0; i < this.frames.length; ++i) {
                maximumFrequencyOfVoicings[i] = this.frames[i].maximumFrequencyOfVoicingInHz;
            }
        }
        return maximumFrequencyOfVoicings;
    }

    public int getTotalFrames() {
        if (this.frames != null && this.frames.length > 0) {
            return this.frames.length;
        }
        return 0;
    }
}

