/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal.hntm.analysis;

import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import marytts.signalproc.sinusoidal.BaseSinusoidalSpeechFrame;
import marytts.signalproc.sinusoidal.hntm.analysis.FrameHarmonicPart;
import marytts.signalproc.sinusoidal.hntm.analysis.FrameNoisePart;
import marytts.signalproc.sinusoidal.hntm.analysis.FrameNoisePartLpc;
import marytts.signalproc.sinusoidal.hntm.analysis.FrameNoisePartPseudoHarmonic;
import marytts.signalproc.sinusoidal.hntm.analysis.FrameNoisePartWaveform;

public class HntmSpeechFrame
extends BaseSinusoidalSpeechFrame {
    public FrameHarmonicPart h = null;
    public FrameNoisePart n = null;
    public float f0InHz;
    public float maximumFrequencyOfVoicingInHz;
    public float tAnalysisInSeconds;
    public float deltaAnalysisTimeInSeconds;

    public HntmSpeechFrame() {
        this(0.0f);
    }

    public HntmSpeechFrame(float f0InHzIn) {
        this.f0InHz = f0InHzIn;
        this.maximumFrequencyOfVoicingInHz = 0.0f;
        this.tAnalysisInSeconds = -1.0f;
        this.deltaAnalysisTimeInSeconds = 0.0f;
    }

    public HntmSpeechFrame(HntmSpeechFrame existing) {
        this();
        if (existing != null) {
            if (existing.h != null) {
                this.h = new FrameHarmonicPart(existing.h);
            }
            if (existing.n != null) {
                if (existing.n instanceof FrameNoisePartLpc) {
                    this.n = new FrameNoisePartLpc((FrameNoisePartLpc)existing.n);
                } else if (existing.n instanceof FrameNoisePartPseudoHarmonic) {
                    this.n = new FrameNoisePartPseudoHarmonic((FrameNoisePartPseudoHarmonic)existing.n);
                } else if (existing.n instanceof FrameNoisePartWaveform) {
                    this.n = new FrameNoisePartWaveform((FrameNoisePartWaveform)existing.n);
                }
                this.f0InHz = existing.f0InHz;
                this.maximumFrequencyOfVoicingInHz = existing.maximumFrequencyOfVoicingInHz;
                this.tAnalysisInSeconds = existing.tAnalysisInSeconds;
                this.deltaAnalysisTimeInSeconds = existing.deltaAnalysisTimeInSeconds;
            }
        }
    }

    public HntmSpeechFrame(DataInputStream dis, int noiseModel) throws IOException, EOFException {
        this();
        this.f0InHz = dis.readFloat();
        this.maximumFrequencyOfVoicingInHz = dis.readFloat();
        this.tAnalysisInSeconds = dis.readFloat();
        this.deltaAnalysisTimeInSeconds = dis.readFloat();
        int numHarmonics = dis.readInt();
        if (numHarmonics > 0) {
            this.h = new FrameHarmonicPart(dis, numHarmonics);
        }
        int vectorSize = dis.readInt();
        if (noiseModel == 2) {
            this.n = new FrameNoisePartLpc(dis, vectorSize);
            if (((FrameNoisePartLpc)this.n).lpCoeffs == null) {
                this.n = null;
            }
        } else if (noiseModel == 3) {
            this.n = new FrameNoisePartPseudoHarmonic(dis, vectorSize);
            if (((FrameNoisePartPseudoHarmonic)this.n).ceps == null) {
                this.n = null;
            }
        } else if (noiseModel == 1) {
            this.n = new FrameNoisePartWaveform(dis, vectorSize);
            if (((FrameNoisePartWaveform)this.n).waveform == null) {
                this.n = null;
            }
        }
    }

    public HntmSpeechFrame(ByteBuffer bb, int noiseModel) throws IOException, EOFException {
        this();
        this.f0InHz = bb.getFloat();
        this.maximumFrequencyOfVoicingInHz = bb.getFloat();
        this.tAnalysisInSeconds = bb.getFloat();
        this.deltaAnalysisTimeInSeconds = bb.getFloat();
        int numHarmonics = bb.getInt();
        if (numHarmonics > 0) {
            this.h = new FrameHarmonicPart(bb, numHarmonics);
        }
        int vectorSize = bb.getInt();
        if (noiseModel == 2) {
            this.n = new FrameNoisePartLpc(bb, vectorSize);
            if (((FrameNoisePartLpc)this.n).lpCoeffs == null) {
                this.n = null;
            }
        } else if (noiseModel == 3) {
            this.n = new FrameNoisePartPseudoHarmonic(bb, vectorSize);
            if (((FrameNoisePartPseudoHarmonic)this.n).ceps == null) {
                this.n = null;
            }
        } else if (noiseModel == 1) {
            this.n = new FrameNoisePartWaveform(bb, vectorSize);
            if (((FrameNoisePartWaveform)this.n).waveform == null) {
                this.n = null;
            }
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeFloat(this.f0InHz);
        out.writeFloat(this.maximumFrequencyOfVoicingInHz);
        out.writeFloat(this.tAnalysisInSeconds);
        out.writeFloat(this.deltaAnalysisTimeInSeconds);
        int numHarmonics = 0;
        if (this.h != null && this.h.complexAmps != null) {
            numHarmonics = this.h.complexAmps.length;
        }
        out.writeInt(numHarmonics);
        if (this.h != null) {
            this.h.write(out);
        }
        int vectorSize = 0;
        if (this.n != null) {
            vectorSize = this.n.getVectorSize();
        }
        out.writeInt(vectorSize);
        if (this.n != null) {
            this.n.write(out);
        }
    }

    public boolean equals(HntmSpeechFrame other) {
        if (!this.h.equals(other.h)) {
            return false;
        }
        if (!this.n.equals(other.n)) {
            return false;
        }
        if (this.f0InHz != other.f0InHz) {
            return false;
        }
        if (this.maximumFrequencyOfVoicingInHz != other.maximumFrequencyOfVoicingInHz) {
            return false;
        }
        if (this.tAnalysisInSeconds != other.tAnalysisInSeconds) {
            return false;
        }
        return this.deltaAnalysisTimeInSeconds == other.deltaAnalysisTimeInSeconds;
    }

    public int getLength() {
        int len = 24;
        if (this.h != null) {
            len += this.h.getLength();
        }
        if (this.n != null) {
            len += this.n.getLength();
        }
        return len;
    }
}

