/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal.hntm.analysis;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import marytts.signalproc.sinusoidal.hntm.analysis.pitch.HnmPitchVoicingAnalyzerParams;

public class HntmAnalyzerParams {
    public HnmPitchVoicingAnalyzerParams hnmPitchVoicingAnalyzerParams;
    public boolean useJampackInAnalysis;
    public boolean isSilentAnalysis;
    public boolean readAnalysisResultsFromFile;
    public int harmonicModel;
    public static final int HARMONICS_PLUS_NOISE = 1;
    public static final int HARMONICS_PLUS_TRANSIENTS_PLUS_NOISE = 2;
    public int noiseModel;
    public static final int WAVEFORM = 1;
    public static final int LPC = 2;
    public static final int PSEUDO_HARMONIC = 3;
    public static final int VOICEDNOISE_LPC_UNVOICEDNOISE_WAVEFORM = 4;
    public static final int UNVOICEDNOISE_LPC_VOICEDNOISE_WAVEFORM = 5;
    public int regularizedCepstrumWarpingMethod;
    public int harmonicSynthesisMethodBeforeNoiseAnalysis;
    public boolean useHarmonicAmplitudesDirectly;
    public float regularizedCepstrumLambdaHarmonic;
    public boolean useWeightingInRegularizedCepstrumEstimationHarmonic;
    public int harmonicPartCepstrumOrderPreMel;
    public int harmonicPartCepstrumOrder;
    public boolean computeNoisePartLpOrderFromSamplingRate;
    public int noisePartLpOrder;
    public float preemphasisCoefNoise;
    public boolean hpfBeforeNoiseAnalysis;
    public boolean decimateNoiseWaveform;
    public boolean overlapNoiseWaveformModel;
    public boolean useNoiseAmplitudesDirectly;
    public float regularizedCepstrumEstimationLambdaNoise;
    public boolean useWeightingInRegularizedCesptrumEstimationNoise;
    public int noisePartCepstrumOderPre;
    public int noisePartCepstrumOrder;
    public boolean usePosteriorMelWarpingNoise;
    public float noiseF0InHz;
    public float hpfTransitionBandwidthInHz;
    public float noiseAnalysisWindowDurationInSeconds;
    public float overlapBetweenHarmonicAndNoiseRegionsInHz;
    public float overlapBetweenTransientAndNontransientSectionsInSeconds;
    public int harmonicAnalysisWindowType;
    public int noiseAnalysisWindowType;
    public int numHarmonicsForVoicing;
    public float harmonicsNeigh;
    public float numPeriodsHarmonicsExtraction;
    public float fftPeakPickerPeriods;
    public static boolean UNWRAP_PHASES_ALONG_HARMONICS_AFTER_ANALYSIS = false;
    public static boolean UNWRAP_PHASES_ALONG_HARMONICS_AFTER_TIME_SCALING = false;
    public static boolean UNWRAP_PHASES_ALONG_HARMONICS_AFTER_PITCH_SCALING = false;

    public HntmAnalyzerParams() {
        this.hnmPitchVoicingAnalyzerParams = new HnmPitchVoicingAnalyzerParams();
        this.useJampackInAnalysis = true;
        this.isSilentAnalysis = false;
        this.harmonicModel = 1;
        this.noiseModel = 1;
        this.regularizedCepstrumWarpingMethod = 2;
        this.harmonicSynthesisMethodBeforeNoiseAnalysis = 1;
        this.useHarmonicAmplitudesDirectly = true;
        this.regularizedCepstrumLambdaHarmonic = 1.0E-5f;
        this.useWeightingInRegularizedCepstrumEstimationHarmonic = false;
        this.harmonicPartCepstrumOrder = 24;
        this.harmonicPartCepstrumOrderPreMel = 40;
        this.computeNoisePartLpOrderFromSamplingRate = false;
        this.noisePartLpOrder = 12;
        this.preemphasisCoefNoise = 0.97f;
        this.hpfBeforeNoiseAnalysis = true;
        this.decimateNoiseWaveform = false;
        this.overlapNoiseWaveformModel = true;
        this.useNoiseAmplitudesDirectly = true;
        this.regularizedCepstrumEstimationLambdaNoise = 2.0E-4f;
        this.useWeightingInRegularizedCesptrumEstimationNoise = false;
        this.noisePartCepstrumOderPre = 12;
        this.noisePartCepstrumOrder = 20;
        this.usePosteriorMelWarpingNoise = true;
        this.noiseF0InHz = 100.0f;
        this.hpfTransitionBandwidthInHz = 0.0f;
        this.noiseAnalysisWindowDurationInSeconds = 0.06f;
        this.overlapBetweenHarmonicAndNoiseRegionsInHz = 0.0f;
        this.overlapBetweenTransientAndNontransientSectionsInSeconds = 0.005f;
        this.harmonicAnalysisWindowType = 1;
        this.noiseAnalysisWindowType = 1;
        this.numHarmonicsForVoicing = 4;
        this.harmonicsNeigh = 0.3f;
        this.numPeriodsHarmonicsExtraction = 2.0f;
        this.fftPeakPickerPeriods = 3.0f;
    }

    public HntmAnalyzerParams(String binaryFile) {
        try {
            this.read(binaryFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public HntmAnalyzerParams(DataInputStream dis) {
        try {
            this.read(dis);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public HntmAnalyzerParams(HntmAnalyzerParams existing) {
        this.hnmPitchVoicingAnalyzerParams = new HnmPitchVoicingAnalyzerParams(existing.hnmPitchVoicingAnalyzerParams);
        this.useJampackInAnalysis = existing.useJampackInAnalysis;
        this.isSilentAnalysis = existing.isSilentAnalysis;
        this.harmonicModel = existing.harmonicModel;
        this.noiseModel = existing.noiseModel;
        this.regularizedCepstrumWarpingMethod = existing.regularizedCepstrumWarpingMethod;
        this.harmonicSynthesisMethodBeforeNoiseAnalysis = existing.harmonicSynthesisMethodBeforeNoiseAnalysis;
        this.useHarmonicAmplitudesDirectly = existing.useHarmonicAmplitudesDirectly;
        this.regularizedCepstrumLambdaHarmonic = existing.regularizedCepstrumLambdaHarmonic;
        this.useWeightingInRegularizedCepstrumEstimationHarmonic = existing.useWeightingInRegularizedCepstrumEstimationHarmonic;
        this.harmonicPartCepstrumOrderPreMel = existing.harmonicPartCepstrumOrderPreMel;
        this.harmonicPartCepstrumOrder = existing.harmonicPartCepstrumOrder;
        this.computeNoisePartLpOrderFromSamplingRate = existing.computeNoisePartLpOrderFromSamplingRate;
        this.noisePartLpOrder = existing.noisePartLpOrder;
        this.preemphasisCoefNoise = existing.preemphasisCoefNoise;
        this.hpfBeforeNoiseAnalysis = existing.hpfBeforeNoiseAnalysis;
        this.decimateNoiseWaveform = existing.decimateNoiseWaveform;
        this.overlapNoiseWaveformModel = existing.overlapNoiseWaveformModel;
        this.useNoiseAmplitudesDirectly = existing.useNoiseAmplitudesDirectly;
        this.regularizedCepstrumEstimationLambdaNoise = existing.regularizedCepstrumEstimationLambdaNoise;
        this.useWeightingInRegularizedCesptrumEstimationNoise = existing.useWeightingInRegularizedCesptrumEstimationNoise;
        this.noisePartCepstrumOderPre = existing.noisePartCepstrumOderPre;
        this.noisePartCepstrumOrder = existing.noisePartCepstrumOrder;
        this.usePosteriorMelWarpingNoise = existing.usePosteriorMelWarpingNoise;
        this.noiseF0InHz = existing.noiseF0InHz;
        this.hpfTransitionBandwidthInHz = existing.hpfTransitionBandwidthInHz;
        this.noiseAnalysisWindowDurationInSeconds = existing.noiseAnalysisWindowDurationInSeconds;
        this.overlapBetweenHarmonicAndNoiseRegionsInHz = existing.overlapBetweenHarmonicAndNoiseRegionsInHz;
        this.overlapBetweenTransientAndNontransientSectionsInSeconds = existing.overlapBetweenTransientAndNontransientSectionsInSeconds;
        this.harmonicAnalysisWindowType = existing.harmonicAnalysisWindowType;
        this.noiseAnalysisWindowType = existing.noiseAnalysisWindowType;
        this.numHarmonicsForVoicing = existing.numHarmonicsForVoicing;
        this.harmonicsNeigh = existing.harmonicsNeigh;
        this.numPeriodsHarmonicsExtraction = existing.numPeriodsHarmonicsExtraction;
        this.fftPeakPickerPeriods = existing.fftPeakPickerPeriods;
    }

    public boolean equals(HntmAnalyzerParams existing) {
        if (!this.hnmPitchVoicingAnalyzerParams.equals(existing.hnmPitchVoicingAnalyzerParams)) {
            return false;
        }
        if (this.useJampackInAnalysis != existing.useJampackInAnalysis) {
            return false;
        }
        if (this.isSilentAnalysis != existing.isSilentAnalysis) {
            return false;
        }
        if (this.harmonicModel != existing.harmonicModel) {
            return false;
        }
        if (this.noiseModel != existing.noiseModel) {
            return false;
        }
        if (this.regularizedCepstrumWarpingMethod != existing.regularizedCepstrumWarpingMethod) {
            return false;
        }
        if (this.harmonicSynthesisMethodBeforeNoiseAnalysis != existing.harmonicSynthesisMethodBeforeNoiseAnalysis) {
            return false;
        }
        if (this.useHarmonicAmplitudesDirectly != existing.useHarmonicAmplitudesDirectly) {
            return false;
        }
        if (this.regularizedCepstrumLambdaHarmonic != existing.regularizedCepstrumLambdaHarmonic) {
            return false;
        }
        if (this.useWeightingInRegularizedCepstrumEstimationHarmonic != existing.useWeightingInRegularizedCepstrumEstimationHarmonic) {
            return false;
        }
        if (this.harmonicPartCepstrumOrderPreMel != existing.harmonicPartCepstrumOrderPreMel) {
            return false;
        }
        if (this.harmonicPartCepstrumOrder != existing.harmonicPartCepstrumOrder) {
            return false;
        }
        if (this.computeNoisePartLpOrderFromSamplingRate != existing.computeNoisePartLpOrderFromSamplingRate) {
            return false;
        }
        if (this.noisePartLpOrder != existing.noisePartLpOrder) {
            return false;
        }
        if (this.preemphasisCoefNoise != existing.preemphasisCoefNoise) {
            return false;
        }
        if (this.hpfBeforeNoiseAnalysis != existing.hpfBeforeNoiseAnalysis) {
            return false;
        }
        if (this.decimateNoiseWaveform != existing.decimateNoiseWaveform) {
            return false;
        }
        if (this.overlapNoiseWaveformModel != existing.overlapNoiseWaveformModel) {
            return false;
        }
        if (this.useNoiseAmplitudesDirectly != existing.useNoiseAmplitudesDirectly) {
            return false;
        }
        if (this.regularizedCepstrumEstimationLambdaNoise != existing.regularizedCepstrumEstimationLambdaNoise) {
            return false;
        }
        if (this.useWeightingInRegularizedCesptrumEstimationNoise != existing.useWeightingInRegularizedCesptrumEstimationNoise) {
            return false;
        }
        if (this.noisePartCepstrumOderPre != existing.noisePartCepstrumOderPre) {
            return false;
        }
        if (this.noisePartCepstrumOrder != existing.noisePartCepstrumOrder) {
            return false;
        }
        if (this.usePosteriorMelWarpingNoise != existing.usePosteriorMelWarpingNoise) {
            return false;
        }
        if (this.noiseF0InHz != existing.noiseF0InHz) {
            return false;
        }
        if (this.hpfTransitionBandwidthInHz != existing.hpfTransitionBandwidthInHz) {
            return false;
        }
        if (this.noiseAnalysisWindowDurationInSeconds != existing.noiseAnalysisWindowDurationInSeconds) {
            return false;
        }
        if (this.overlapBetweenHarmonicAndNoiseRegionsInHz != existing.overlapBetweenHarmonicAndNoiseRegionsInHz) {
            return false;
        }
        if (this.overlapBetweenTransientAndNontransientSectionsInSeconds != existing.overlapBetweenTransientAndNontransientSectionsInSeconds) {
            return false;
        }
        if (this.harmonicAnalysisWindowType != existing.harmonicAnalysisWindowType) {
            return false;
        }
        if (this.noiseAnalysisWindowType != existing.noiseAnalysisWindowType) {
            return false;
        }
        if (this.numHarmonicsForVoicing != existing.numHarmonicsForVoicing) {
            return false;
        }
        if (this.harmonicsNeigh != existing.harmonicsNeigh) {
            return false;
        }
        if (this.numPeriodsHarmonicsExtraction != existing.numPeriodsHarmonicsExtraction) {
            return false;
        }
        return this.fftPeakPickerPeriods == existing.fftPeakPickerPeriods;
    }

    public void write(String binaryFile) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FileOutputStream(new File(binaryFile)));
        this.write(dos);
    }

    public void write(DataOutputStream dos) throws IOException {
        this.hnmPitchVoicingAnalyzerParams.write(dos);
        dos.writeBoolean(this.useJampackInAnalysis);
        dos.writeBoolean(this.isSilentAnalysis);
        dos.writeInt(this.harmonicModel);
        dos.writeInt(this.noiseModel);
        dos.writeInt(this.regularizedCepstrumWarpingMethod);
        dos.writeInt(this.harmonicSynthesisMethodBeforeNoiseAnalysis);
        dos.writeBoolean(this.useHarmonicAmplitudesDirectly);
        dos.writeFloat(this.regularizedCepstrumLambdaHarmonic);
        dos.writeBoolean(this.useWeightingInRegularizedCepstrumEstimationHarmonic);
        dos.writeInt(this.harmonicPartCepstrumOrderPreMel);
        dos.writeInt(this.harmonicPartCepstrumOrder);
        dos.writeBoolean(this.computeNoisePartLpOrderFromSamplingRate);
        dos.writeInt(this.noisePartLpOrder);
        dos.writeFloat(this.preemphasisCoefNoise);
        dos.writeBoolean(this.hpfBeforeNoiseAnalysis);
        dos.writeBoolean(this.decimateNoiseWaveform);
        dos.writeBoolean(this.overlapNoiseWaveformModel);
        dos.writeBoolean(this.useNoiseAmplitudesDirectly);
        dos.writeFloat(this.regularizedCepstrumEstimationLambdaNoise);
        dos.writeBoolean(this.useWeightingInRegularizedCesptrumEstimationNoise);
        dos.writeInt(this.noisePartCepstrumOderPre);
        dos.writeInt(this.noisePartCepstrumOrder);
        dos.writeBoolean(this.usePosteriorMelWarpingNoise);
        dos.writeFloat(this.noiseF0InHz);
        dos.writeFloat(this.hpfTransitionBandwidthInHz);
        dos.writeFloat(this.noiseAnalysisWindowDurationInSeconds);
        dos.writeFloat(this.overlapBetweenHarmonicAndNoiseRegionsInHz);
        dos.writeFloat(this.overlapBetweenTransientAndNontransientSectionsInSeconds);
        dos.writeInt(this.harmonicAnalysisWindowType);
        dos.writeInt(this.noiseAnalysisWindowType);
        dos.writeInt(this.numHarmonicsForVoicing);
        dos.writeFloat(this.harmonicsNeigh);
        dos.writeFloat(this.numPeriodsHarmonicsExtraction);
        dos.writeFloat(this.fftPeakPickerPeriods);
    }

    public void read(String binaryFile) throws IOException {
        DataInputStream dis = new DataInputStream(new FileInputStream(new File(binaryFile)));
        this.read(dis);
    }

    public void read(DataInputStream dis) throws IOException {
        this.hnmPitchVoicingAnalyzerParams = new HnmPitchVoicingAnalyzerParams(dis);
        this.useJampackInAnalysis = dis.readBoolean();
        this.isSilentAnalysis = dis.readBoolean();
        this.harmonicModel = dis.readInt();
        this.noiseModel = dis.readInt();
        this.regularizedCepstrumWarpingMethod = dis.readInt();
        this.harmonicSynthesisMethodBeforeNoiseAnalysis = dis.readInt();
        this.useHarmonicAmplitudesDirectly = dis.readBoolean();
        this.regularizedCepstrumLambdaHarmonic = dis.readFloat();
        this.useWeightingInRegularizedCepstrumEstimationHarmonic = dis.readBoolean();
        this.harmonicPartCepstrumOrderPreMel = dis.readInt();
        this.harmonicPartCepstrumOrder = dis.readInt();
        this.computeNoisePartLpOrderFromSamplingRate = dis.readBoolean();
        this.noisePartLpOrder = dis.readInt();
        this.preemphasisCoefNoise = dis.readFloat();
        this.hpfBeforeNoiseAnalysis = dis.readBoolean();
        this.decimateNoiseWaveform = dis.readBoolean();
        this.overlapNoiseWaveformModel = dis.readBoolean();
        this.useNoiseAmplitudesDirectly = dis.readBoolean();
        this.regularizedCepstrumEstimationLambdaNoise = dis.readFloat();
        this.useWeightingInRegularizedCesptrumEstimationNoise = dis.readBoolean();
        this.noisePartCepstrumOderPre = dis.readInt();
        this.noisePartCepstrumOrder = dis.readInt();
        this.usePosteriorMelWarpingNoise = dis.readBoolean();
        this.noiseF0InHz = dis.readFloat();
        this.hpfTransitionBandwidthInHz = dis.readFloat();
        this.noiseAnalysisWindowDurationInSeconds = dis.readFloat();
        this.overlapBetweenHarmonicAndNoiseRegionsInHz = dis.readFloat();
        this.overlapBetweenTransientAndNontransientSectionsInSeconds = dis.readFloat();
        this.harmonicAnalysisWindowType = dis.readInt();
        this.noiseAnalysisWindowType = dis.readInt();
        this.numHarmonicsForVoicing = dis.readInt();
        this.harmonicsNeigh = dis.readFloat();
        this.numPeriodsHarmonicsExtraction = dis.readFloat();
        this.fftPeakPickerPeriods = dis.readFloat();
    }
}

