/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.process;

import java.io.File;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.signalproc.process.FrameOverlapAddSource;
import marytts.signalproc.process.PolarFrequencyProcessor;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;

public class SimpleNoiseRemover
extends PolarFrequencyProcessor {
    protected double threshold;

    public SimpleNoiseRemover(int fftSize, double threshold) {
        super(fftSize);
        this.threshold = threshold;
    }

    @Override
    protected void processPolar(double[] r, double[] phi) {
        int halfWinLength = r.length / 2;
        int i = 0;
        while (i < r.length) {
            double rNorm = r[i] / (double)halfWinLength;
            double factor = rNorm / (rNorm + this.threshold);
            int n = i++;
            r[n] = r[n] * factor;
        }
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(args[i]));
            int samplingRate = (int)inputAudio.getFormat().getSampleRate();
            AudioDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
            int frameLength = Integer.getInteger("signalproc.simplenoiseremover.framelength", 1024);
            double threshold = Double.parseDouble(System.getProperty("signalproc.simplenoiseremover.threshold", "50.0"));
            FrameOverlapAddSource foas = new FrameOverlapAddSource(signal, 3, true, frameLength, samplingRate, new SimpleNoiseRemover(frameLength, threshold));
            DDSAudioInputStream outputAudio = new DDSAudioInputStream(new BufferedDoubleDataSource(foas), inputAudio.getFormat());
            String outFileName = args[i].substring(0, args[i].length() - 4) + "_denoised.wav";
            AudioSystem.write((AudioInputStream)outputAudio, AudioFileFormat.Type.WAVE, new File(outFileName));
        }
    }
}

