/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.filter;

import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.signalproc.filter.ComplementaryFilterBankChannelAnalyser;
import marytts.signalproc.filter.FilterBankAnalyserBase;
import marytts.signalproc.filter.Subband;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.signal.SignalProcUtils;

public class ComplementaryFilterBankAnalyser
extends FilterBankAnalyserBase {
    public int numLevels;
    public int numBands;
    public int baseFilterOrder;
    protected ComplementaryFilterBankChannelAnalyser[] channelAnalysers;
    protected double originalEnergy;

    public ComplementaryFilterBankAnalyser(int numLevelsIn, int baseFilterOrderIn) {
        if (numLevelsIn >= 0) {
            this.numLevels = numLevelsIn;
            this.numBands = (int)Math.pow(2.0, this.numLevels);
            this.channelAnalysers = new ComplementaryFilterBankChannelAnalyser[this.numLevels];
            int N = this.baseFilterOrder = baseFilterOrderIn;
            for (int i = 0; i < this.numLevels; ++i) {
                this.channelAnalysers[i] = new ComplementaryFilterBankChannelAnalyser(N);
                N = (int)((double)N * 0.5);
            }
        }
    }

    public Subband[] apply(double[] x, int samplingRateInHz) {
        int i;
        Subband[] subbands = null;
        this.originalEnergy = SignalProcUtils.energy(x);
        this.channelAnalysers[0].apply(x);
        for (i = 1; i < this.numLevels; ++i) {
            this.channelAnalysers[i].apply(this.channelAnalysers[i - 1].lpfOut);
        }
        subbands = new Subband[this.numLevels + 1];
        int currentSamplingRate = (int)((double)samplingRateInHz / Math.pow(2.0, this.numLevels));
        double startFreqInHz = 0.0;
        double endFreqInHz = 0.5 * (double)currentSamplingRate;
        int subbandInd = 0;
        subbands[subbandInd++] = new Subband(this.channelAnalysers[this.numLevels - 1].lpfOut, currentSamplingRate, startFreqInHz, endFreqInHz);
        startFreqInHz = endFreqInHz;
        for (i = this.numLevels; i >= 1; --i) {
            currentSamplingRate = 2 * currentSamplingRate;
            endFreqInHz = 0.5 * (double)currentSamplingRate;
            subbands[subbandInd++] = new Subband(this.channelAnalysers[i - 1].hpfOut, currentSamplingRate, startFreqInHz, endFreqInHz);
            startFreqInHz = endFreqInHz;
        }
        return subbands;
    }

    public static void main(String[] args) throws UnsupportedAudioFileException, IOException {
        AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(args[0]));
        int samplingRate = (int)inputAudio.getFormat().getSampleRate();
        AudioDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
        double[] x = signal.getAllData();
        int numLevels = 4;
        int N = 512;
        ComplementaryFilterBankAnalyser analyser = new ComplementaryFilterBankAnalyser(numLevels, N);
        Subband[] subbands = analyser.apply(x, samplingRate);
        for (int i = 0; i < subbands.length; ++i) {
            AudioFormat outputFormat = new AudioFormat((int)subbands[i].samplingRate, inputAudio.getFormat().getSampleSizeInBits(), inputAudio.getFormat().getChannels(), true, true);
            DDSAudioInputStream outputAudio = new DDSAudioInputStream(new BufferedDoubleDataSource(subbands[i].waveform), outputFormat);
            String outFileName = args[0].substring(0, args[0].length() - 4) + "_sb" + String.valueOf(i + 1) + ".wav";
            AudioSystem.write((AudioInputStream)outputAudio, AudioFileFormat.Type.WAVE, new File(outFileName));
        }
    }
}

