/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.filter;

import marytts.signalproc.filter.FIRFilter;
import marytts.util.math.MathUtils;

public class AveragingFilter
extends FIRFilter {
    public AveragingFilter(double lengthInSeconds, int samplingRate) {
        this((int)(lengthInSeconds * (double)samplingRate));
    }

    public AveragingFilter(int lengthInSamples) {
        int fftLength = MathUtils.closestPowerOfTwoAbove(lengthInSamples);
        if (fftLength == lengthInSamples) {
            fftLength *= 2;
        }
        double[] impulseResponse = new double[lengthInSamples];
        for (int i = 0; i < lengthInSamples; ++i) {
            impulseResponse[i] = 1.0 / (double)lengthInSamples;
        }
        this.initialise(impulseResponse, fftLength - lengthInSamples);
    }
}

