/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.effects;

import marytts.signalproc.effects.ChorusEffectBase;
import marytts.util.math.MathUtils;

public class StadiumEffect
extends ChorusEffectBase {
    float amount;
    public static float DEFAULT_AMOUNT = 100.0f;
    public static float MAX_AMOUNT = 200.0f;
    public static float MIN_AMOUNT = 0.0f;

    public StadiumEffect() {
        this(16000);
    }

    public StadiumEffect(int samplingRate) {
        super(samplingRate);
        this.delaysInMiliseconds = new int[2];
        this.delaysInMiliseconds[0] = 466;
        this.delaysInMiliseconds[1] = 600;
        this.amps = new double[2];
        this.amps[0] = 0.54;
        this.amps[1] = -0.1;
        this.setExampleParameters("amount" + chParamEquals + "100.0");
        this.strHelpText = this.getHelpText();
        this.initialise();
    }

    @Override
    public void parseParameters(String param) {
        super.parseChildParameters(param);
        if (param != "") {
            this.amount = this.expectFloatParameter("amount");
            if (this.amount == NULL_FLOAT_PARAM) {
                this.amount = DEFAULT_AMOUNT;
            }
            this.amount = MathUtils.CheckLimits(this.amount, MIN_AMOUNT, MAX_AMOUNT);
            for (int i = 0; i < this.delaysInMiliseconds.length; ++i) {
                this.delaysInMiliseconds[i] = (int)((float)this.delaysInMiliseconds[i] * this.amount / 100.0f);
            }
        }
        this.initialise();
    }

    @Override
    public String getHelpText() {
        String strHelp = "Stadium Effect:" + strLineBreak + "Adds stadium effect by applying a specially designed multi-tap chorus." + strLineBreak + "Parameter:" + strLineBreak + "   <amount>" + "   Definition : The amount of stadium effect at the output" + strLineBreak + "   Range      : [" + String.valueOf(MIN_AMOUNT) + "," + String.valueOf(MAX_AMOUNT) + "]" + strLineBreak + "Example:" + strLineBreak + this.getExampleParameters();
        return strHelp;
    }

    @Override
    public String getName() {
        return "Stadium";
    }
}

