/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.adaptation.gmm.jointgmm;

import java.io.FileNotFoundException;
import java.io.IOException;
import marytts.machinelearning.ContextualGMMParams;
import marytts.signalproc.adaptation.VocalTractTransformationData;
import marytts.signalproc.adaptation.gmm.jointgmm.JointGMM;
import marytts.util.io.MaryRandomAccessFile;

public class JointGMMSet
extends VocalTractTransformationData {
    public static final String DEFAULT_EXTENSION = ".jgs";
    public JointGMM[] gmms;
    public ContextualGMMParams cgParams;

    public JointGMMSet() {
        this.allocate(0, null);
    }

    public JointGMMSet(JointGMMSet existing) {
        this.gmms = null;
        if (existing != null) {
            this.allocate(existing.gmms.length, null);
            for (int i = 0; i < existing.gmms.length; ++i) {
                this.gmms[i] = new JointGMM(existing.gmms[i]);
            }
            this.cgParams = new ContextualGMMParams(existing.cgParams);
        }
    }

    public JointGMMSet(int numGMMs) {
        this(numGMMs, null);
    }

    public JointGMMSet(int numGMMs, ContextualGMMParams cgParamsIn) {
        this.allocate(numGMMs, cgParamsIn);
    }

    public void allocate(int numGMMs, ContextualGMMParams cgParamsIn) {
        this.gmms = numGMMs > 0 ? new JointGMM[numGMMs] : null;
        this.cgParams = cgParamsIn != null ? new ContextualGMMParams(cgParamsIn) : (numGMMs > 0 ? new ContextualGMMParams(numGMMs) : null);
    }

    public JointGMMSet(String jointGMMFile) {
        this.read(jointGMMFile);
    }

    public void write(String jointGMMFile) {
        MaryRandomAccessFile stream = null;
        try {
            stream = new MaryRandomAccessFile(jointGMMFile, "rw");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        if (stream != null) {
            if (this.gmms != null && this.gmms.length > 0) {
                try {
                    stream.writeInt(this.gmms.length);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                if (this.cgParams != null) {
                    this.cgParams.write(stream);
                }
                for (int i = 0; i < this.gmms.length; ++i) {
                    if (this.gmms[i] != null) {
                        try {
                            stream.writeBoolean(true);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        this.gmms[i].write(stream);
                        continue;
                    }
                    try {
                        stream.writeBoolean(false);
                        continue;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                try {
                    stream.writeInt(0);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            try {
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void read(String jointGMMFile) {
        MaryRandomAccessFile stream = null;
        try {
            stream = new MaryRandomAccessFile(jointGMMFile, "r");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        if (stream != null) {
            int numGMMs = 0;
            try {
                numGMMs = stream.readInt();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            if (numGMMs > 0) {
                ContextualGMMParams tmpCgParams = new ContextualGMMParams();
                tmpCgParams.read(stream);
                this.allocate(numGMMs, tmpCgParams);
                for (int i = 0; i < numGMMs; ++i) {
                    boolean isGmmExisting = false;
                    try {
                        isGmmExisting = stream.readBoolean();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (!isGmmExisting) continue;
                    this.gmms[i] = new JointGMM(stream);
                }
            }
            try {
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

