/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.adaptation.codebook;

import java.io.IOException;
import marytts.signalproc.adaptation.BaselineFeatureExtractor;
import marytts.signalproc.analysis.EnergyFileHeader;
import marytts.signalproc.analysis.LsfFileHeader;
import marytts.signalproc.analysis.MfccFileHeader;
import marytts.signalproc.analysis.PitchFileHeader;
import marytts.util.io.MaryRandomAccessFile;

public class WeightedCodebookFileHeader {
    public int totalEntries;
    public int codebookType;
    public static int FRAMES = 1;
    public static int FRAME_GROUPS = 2;
    public static int LABELS = 3;
    public static int LABEL_GROUPS = 4;
    public static int SPEECH = 5;
    public String sourceTag;
    public String targetTag;
    public LsfFileHeader lsfParams;
    public PitchFileHeader ptcParams;
    public EnergyFileHeader energyParams;
    public MfccFileHeader mfccParams;
    public int numNeighboursInFrameGroups;
    public int numNeighboursInLabelGroups;
    public int vocalTractFeature;

    public WeightedCodebookFileHeader() {
        this(0);
    }

    public WeightedCodebookFileHeader(int totalEntriesIn) {
        this.totalEntries = totalEntriesIn;
        this.codebookType = FRAMES;
        this.sourceTag = "source";
        this.targetTag = "target";
        this.lsfParams = new LsfFileHeader();
        this.ptcParams = new PitchFileHeader();
        this.energyParams = new EnergyFileHeader();
        this.mfccParams = new MfccFileHeader();
        this.vocalTractFeature = BaselineFeatureExtractor.LSF_FEATURES;
    }

    public WeightedCodebookFileHeader(WeightedCodebookFileHeader h) {
        this.totalEntries = h.totalEntries;
        this.codebookType = h.codebookType;
        this.sourceTag = h.sourceTag;
        this.targetTag = h.targetTag;
        this.lsfParams = new LsfFileHeader(h.lsfParams);
        this.ptcParams = new PitchFileHeader(h.ptcParams);
        this.energyParams = new EnergyFileHeader(h.energyParams);
        this.mfccParams = new MfccFileHeader(h.mfccParams);
        this.numNeighboursInFrameGroups = h.numNeighboursInFrameGroups;
        this.numNeighboursInLabelGroups = h.numNeighboursInLabelGroups;
        this.vocalTractFeature = h.vocalTractFeature;
    }

    public void resetTotalEntries() {
        this.totalEntries = 0;
    }

    public void read(MaryRandomAccessFile ler) throws IOException {
        this.totalEntries = ler.readInt();
        this.lsfParams = new LsfFileHeader();
        this.lsfParams.readHeader(ler);
        this.ptcParams = new PitchFileHeader();
        this.ptcParams.readPitchHeader(ler);
        this.energyParams = new EnergyFileHeader();
        this.energyParams.read(ler, true);
        this.mfccParams.readHeader(ler);
        this.codebookType = ler.readInt();
        this.numNeighboursInFrameGroups = ler.readInt();
        this.numNeighboursInLabelGroups = ler.readInt();
        int tagLen = ler.readInt();
        this.sourceTag = String.copyValueOf(ler.readChar(tagLen));
        tagLen = ler.readInt();
        this.targetTag = String.copyValueOf(ler.readChar(tagLen));
        this.vocalTractFeature = ler.readInt();
    }

    public void write(MaryRandomAccessFile ler) throws IOException {
        ler.writeInt(this.totalEntries);
        this.lsfParams.writeHeader(ler);
        this.ptcParams.writePitchHeader(ler);
        this.energyParams.write(ler);
        this.mfccParams.writeHeader(ler);
        ler.writeInt(this.codebookType);
        ler.writeInt(this.numNeighboursInFrameGroups);
        ler.writeInt(this.numNeighboursInLabelGroups);
        int tagLen = this.sourceTag.length();
        ler.writeInt(tagLen);
        ler.writeChar(this.sourceTag.toCharArray());
        tagLen = this.targetTag.length();
        ler.writeInt(tagLen);
        ler.writeChar(this.targetTag.toCharArray());
        ler.writeInt(this.vocalTractFeature);
    }
}

