/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.adaptation;

import java.io.IOException;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.signalproc.adaptation.BaselineAdaptationItem;
import marytts.signalproc.adaptation.BaselineAdaptationSet;
import marytts.signalproc.adaptation.BaselineParams;
import marytts.signalproc.adaptation.codebook.WeightedCodebookTrainerParams;
import marytts.signalproc.adaptation.codebook.WeightedCodebookTransformerParams;
import marytts.signalproc.adaptation.gmm.jointgmm.JointGMMTransformerParams;
import marytts.signalproc.analysis.EnergyContourRms;
import marytts.signalproc.analysis.EnergyFileHeader;
import marytts.signalproc.analysis.F0TrackerAutocorrelationHeuristic;
import marytts.signalproc.analysis.LsfAnalyser;
import marytts.signalproc.analysis.LsfFileHeader;
import marytts.signalproc.analysis.MfccFileHeader;
import marytts.signalproc.analysis.PitchFileHeader;
import marytts.util.io.FileUtils;
import marytts.util.string.StringUtils;

public class BaselineFeatureExtractor {
    public static final int NOT_DEFINED = Integer.parseInt("00000000", 2);
    public static final int LSF_FEATURES = Integer.parseInt("00000001", 2);
    public static final int F0_FEATURES = Integer.parseInt("00000010", 2);
    public static final int ENERGY_FEATURES = Integer.parseInt("00000100", 2);
    public static final int DURATION_FEATURES = Integer.parseInt("00001000", 2);
    public static final int MFCC_FEATURES_FROM_FILES = Integer.parseInt("00010000", 2);

    public BaselineFeatureExtractor() {
        this(null);
    }

    public BaselineFeatureExtractor(BaselineFeatureExtractor existing) {
        if (existing != null) {
            // empty if block
        }
    }

    public void run(BaselineAdaptationSet fileSet, BaselineParams params, int desiredFeatures) throws IOException, UnsupportedAudioFileException {
        LsfFileHeader lsfParams = null;
        if (params instanceof WeightedCodebookTrainerParams) {
            lsfParams = new LsfFileHeader(((WeightedCodebookTrainerParams)params).codebookHeader.lsfParams);
        } else if (params instanceof WeightedCodebookTransformerParams) {
            lsfParams = new LsfFileHeader(((WeightedCodebookTransformerParams)params).lsfParams);
        } else if (params instanceof JointGMMTransformerParams) {
            lsfParams = new LsfFileHeader(((JointGMMTransformerParams)params).lsfParams);
        }
        PitchFileHeader ptcParams = null;
        if (params instanceof WeightedCodebookTrainerParams) {
            ptcParams = new PitchFileHeader(((WeightedCodebookTrainerParams)params).codebookHeader.ptcParams);
        } else if (params instanceof WeightedCodebookTransformerParams) {
            ptcParams = new PitchFileHeader(((WeightedCodebookTransformerParams)params).ptcParams);
        } else if (params instanceof JointGMMTransformerParams) {
            ptcParams = new PitchFileHeader(((JointGMMTransformerParams)params).ptcParams);
        }
        EnergyFileHeader energyParams = null;
        if (params instanceof WeightedCodebookTrainerParams) {
            energyParams = new EnergyFileHeader(((WeightedCodebookTrainerParams)params).codebookHeader.energyParams);
        } else if (params instanceof WeightedCodebookTransformerParams) {
            energyParams = new EnergyFileHeader(((WeightedCodebookTransformerParams)params).energyParams);
        } else if (params instanceof JointGMMTransformerParams) {
            energyParams = new EnergyFileHeader(((JointGMMTransformerParams)params).energyParams);
        }
        MfccFileHeader mfccParams = null;
        if (params instanceof WeightedCodebookTrainerParams) {
            mfccParams = new MfccFileHeader(((WeightedCodebookTrainerParams)params).codebookHeader.mfccParams);
        } else if (params instanceof WeightedCodebookTransformerParams) {
            mfccParams = new MfccFileHeader(((WeightedCodebookTransformerParams)params).mfccParams);
        } else if (params instanceof JointGMMTransformerParams) {
            mfccParams = new MfccFileHeader(((JointGMMTransformerParams)params).mfccParams);
        }
        boolean isForcedAnalysis = false;
        if (params instanceof WeightedCodebookTrainerParams) {
            isForcedAnalysis = ((WeightedCodebookTrainerParams)params).isForcedAnalysis;
        } else if (params instanceof WeightedCodebookTransformerParams) {
            isForcedAnalysis = ((WeightedCodebookTransformerParams)params).isForcedAnalysis;
        } else if (params instanceof JointGMMTransformerParams) {
            isForcedAnalysis = ((JointGMMTransformerParams)params).isForcedAnalysis;
        }
        if (StringUtils.isDesired(LSF_FEATURES, desiredFeatures)) {
            BaselineFeatureExtractor.lsfAnalysis(fileSet, lsfParams, isForcedAnalysis);
        }
        if (StringUtils.isDesired(F0_FEATURES, desiredFeatures)) {
            BaselineFeatureExtractor.f0Analysis(fileSet, ptcParams, isForcedAnalysis);
        }
        if (StringUtils.isDesired(ENERGY_FEATURES, desiredFeatures)) {
            BaselineFeatureExtractor.energyAnalysis(fileSet, energyParams, isForcedAnalysis);
        }
        if (StringUtils.isDesired(MFCC_FEATURES_FROM_FILES, desiredFeatures)) {
            BaselineFeatureExtractor.checkMfccFiles(fileSet, mfccParams, isForcedAnalysis);
        }
    }

    public static void lsfAnalysis(BaselineAdaptationItem item, LsfFileHeader lsfParams, boolean isForcedAnalysis) throws IOException {
        BaselineAdaptationSet fileSet = new BaselineAdaptationSet(1);
        fileSet.items[0] = new BaselineAdaptationItem(item);
        BaselineFeatureExtractor.lsfAnalysis(fileSet, lsfParams, isForcedAnalysis);
    }

    public static void lsfAnalysis(BaselineAdaptationSet fileSet, LsfFileHeader lsfParams, boolean isForcedAnalysis) throws IOException {
        System.err.println("Starting LSF analysis...");
        for (int i = 0; i < fileSet.items.length; ++i) {
            LsfFileHeader tmpParams;
            boolean bAnalyze = true;
            if (!isForcedAnalysis && FileUtils.exists(fileSet.items[i].lsfFile) && (tmpParams = new LsfFileHeader(fileSet.items[i].lsfFile)).isIdenticalAnalysisParams(lsfParams)) {
                bAnalyze = false;
            }
            if (bAnalyze) {
                LsfAnalyser.lsfAnalyzeWavFile(fileSet.items[i].audioFile, fileSet.items[i].lsfFile, lsfParams);
                System.err.println("Extracted LSFs: " + fileSet.items[i].lsfFile);
                continue;
            }
            System.err.println("LSF file found with identical analysis parameters: " + fileSet.items[i].lsfFile);
        }
        System.err.println("LSF analysis completed...");
    }

    public static void f0Analysis(BaselineAdaptationSet fileSet, PitchFileHeader ptcParams, boolean isForcedAnalysis) throws UnsupportedAudioFileException, IOException {
        System.err.println("Starting f0 analysis...");
        F0TrackerAutocorrelationHeuristic p = new F0TrackerAutocorrelationHeuristic(ptcParams);
        for (int i = 0; i < fileSet.items.length; ++i) {
            boolean bAnalyze = true;
            if (!isForcedAnalysis && FileUtils.exists(fileSet.items[i].pitchFile)) {
                bAnalyze = false;
            }
            if (bAnalyze) {
                p.pitchAnalyzeWavFile(fileSet.items[i].audioFile, fileSet.items[i].pitchFile);
                System.err.println("Extracted f0 contour: " + fileSet.items[i].pitchFile);
                continue;
            }
            System.err.println("F0 file found with identical analysis parameters: " + fileSet.items[i].pitchFile);
        }
        System.err.println("f0 analysis completed...");
    }

    public static void energyAnalysis(BaselineAdaptationSet fileSet, EnergyFileHeader energyParams, boolean isForcedAnalysis) throws UnsupportedAudioFileException, IOException {
        System.err.println("Starting energy analysis...");
        EnergyContourRms e = null;
        for (int i = 0; i < fileSet.items.length; ++i) {
            boolean bAnalyze = true;
            if (!isForcedAnalysis && FileUtils.exists(fileSet.items[i].energyFile)) {
                bAnalyze = false;
            }
            if (bAnalyze) {
                e = new EnergyContourRms(fileSet.items[i].audioFile, fileSet.items[i].energyFile, energyParams.windowSizeInSeconds, energyParams.skipSizeInSeconds);
                System.err.println("Extracted energy contour: " + fileSet.items[i].energyFile);
                continue;
            }
            System.err.println("Energy file found with identical analysis parameters: " + fileSet.items[i].energyFile);
        }
        System.err.println("Energy analysis completed...");
    }

    public static void checkMfccFiles(BaselineAdaptationSet fileSet, MfccFileHeader mfccParams, boolean isForcedAnalysis) throws IOException {
        System.err.println("Attempting to read MFCC parameters from files...");
        for (int i = 0; i < fileSet.items.length; ++i) {
            if (FileUtils.exists(fileSet.items[i].mfccFile)) continue;
            System.err.println("MFCC files not found!Please use SPTK generated raw MFCC file named as " + fileSet.items[i].mfccFile);
        }
        System.err.println("MFCC files verified...");
    }
}

