/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.en;

import com.sun.speech.freetts.FeatureSet;
import com.sun.speech.freetts.Item;
import com.sun.speech.freetts.ProcessException;
import com.sun.speech.freetts.Relation;
import com.sun.speech.freetts.Utterance;
import com.sun.speech.freetts.UtteranceProcessor;
import com.sun.speech.freetts.lexicon.Lexicon;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import marytts.server.MaryProperties;

public class Segmenter
implements UtteranceProcessor {
    private static final String STRESS = "1";
    private static final String NO_STRESS = "0";
    private Map addenda;

    @Override
    public void processUtterance(Utterance utterance) throws ProcessException {
        if (utterance.getRelation("Word") == null) {
            throw new IllegalStateException("Word relation has not been set");
        }
        if (utterance.getRelation("Syllable") != null) {
            throw new IllegalStateException("Syllable relation has already been set");
        }
        if (utterance.getRelation("SylStructure") != null) {
            throw new IllegalStateException("SylStructure relation has already been set");
        }
        if (utterance.getRelation("Segment") != null) {
            throw new IllegalStateException("Segment relation has already been set");
        }
        String stress = NO_STRESS;
        Relation syl = utterance.createRelation("Syllable");
        Relation sylstructure = utterance.createRelation("SylStructure");
        Relation seg = utterance.createRelation("Segment");
        String voicename = utterance.getVoice().getName();
        Lexicon lex = utterance.getVoice().getLexicon();
        ArrayList<String> syllableList = null;
        for (Item word = utterance.getRelation("Word").getHead(); word != null; word = word.getNext()) {
            boolean useLTSRules;
            Item ssword = sylstructure.appendItem(word);
            Item sylItem = null;
            Item segItem = null;
            Item sssyl = null;
            String[] phones = null;
            String pos = NO_STRESS;
            FeatureSet wordFeatures = word.getFeatures();
            if (wordFeatures != null && wordFeatures.isPresent("pos")) {
                pos = wordFeatures.getString("pos");
                if ((pos = pos.toLowerCase()).charAt(0) == 'd') {
                    pos = "d";
                }
            }
            Item token = word.getItemAs("Token");
            FeatureSet featureSet = null;
            if (token != null) {
                Item parent = token.getParent();
                featureSet = parent.getFeatures();
            }
            String wordString = word.toString();
            phones = featureSet != null && featureSet.isPresent("phones") ? (String[])featureSet.getObject("phones") : ((useLTSRules = MaryProperties.getBoolean("english.lexicon.useLTSrules", true)) ? lex.getPhones(wordString, pos, true) : lex.getPhones(wordString, pos, false));
            if (phones == null) {
                phones = lex.getPhones(wordString, pos, true);
                StringBuffer ltsPhoneString = new StringBuffer();
                for (int i = 0; i < phones.length; ++i) {
                    ltsPhoneString.append(phones[i] + " ");
                }
                lex.addAddendum(wordString, null, phones);
                if (this.addenda == null) {
                    this.addenda = new HashMap();
                }
                this.addenda.put(wordString, ltsPhoneString);
            }
            for (int j = 0; j < phones.length; ++j) {
                if (sylItem == null) {
                    sylItem = syl.appendItem();
                    sssyl = ssword.addDaughter(sylItem);
                    stress = NO_STRESS;
                    syllableList = new ArrayList<String>();
                }
                segItem = seg.appendItem();
                if (this.isStressed(phones[j])) {
                    stress = STRESS;
                    phones[j] = this.deStress(phones[j]);
                }
                segItem.getFeatures().setString("name", phones[j]);
                sssyl.addDaughter(segItem);
                syllableList.add(phones[j]);
                if (!lex.isSyllableBoundary(syllableList, phones, j + 1)) continue;
                sylItem = null;
                sssyl.getFeatures().setString("stress", stress);
            }
        }
        assert (utterance.getRelation("Word") != null);
        assert (utterance.getRelation("Syllable") != null);
        assert (utterance.getRelation("SylStructure") != null);
        assert (utterance.getRelation("Segment") != null);
    }

    protected boolean isStressed(String phone) {
        return phone.endsWith(STRESS);
    }

    protected String deStress(String phone) {
        String retPhone = phone;
        if (this.isStressed(phone)) {
            retPhone = phone.substring(0, phone.length() - 1);
        }
        return retPhone;
    }

    public void saveAddenda() throws IOException {
        String path = MaryProperties.maryBase() + "/log/addenda.log";
        if (this.addenda != null && path != null) {
            try {
                StringBuilder addendaBuf = new StringBuilder();
                addendaBuf.append("# Logfile contains words that are not in the lexicon\n# and their transcriptions predicted by the LTS-rules\n# (for English)\n");
                Set words = this.addenda.keySet();
                for (String nextWord : words) {
                    addendaBuf.append(nextWord + " " + this.addenda.get(nextWord) + "\n");
                }
                PrintWriter addendaOut = new PrintWriter(new FileOutputStream(new File(path)));
                addendaOut.print(addendaBuf.toString());
                addendaOut.flush();
                addendaOut.close();
            }
            catch (Exception e) {
                throw new IOException("Could not save addenda because : " + e.getMessage());
            }
        }
    }

    public String toString() {
        return "Segmenter";
    }
}

