/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.en;

import com.sun.speech.freetts.Utterance;
import com.sun.speech.freetts.UtteranceProcessor;
import com.sun.speech.freetts.en.PauseGenerator;
import java.util.List;
import java.util.Locale;
import marytts.datatypes.MaryData;
import marytts.language.en_US.datatypes.USEnglishDataTypes;
import marytts.modules.InternalModule;
import marytts.modules.synthesis.FreeTTSVoices;

public class FreeTTSPauseGenerator
extends InternalModule {
    private UtteranceProcessor processor;

    public FreeTTSPauseGenerator() {
        super("PauseGenerator", USEnglishDataTypes.FREETTS_SEGMENTS, USEnglishDataTypes.FREETTS_PAUSES, Locale.ENGLISH);
    }

    @Override
    public void startup() throws Exception {
        super.startup();
        FreeTTSVoices.load();
        this.processor = new PauseGenerator();
    }

    @Override
    public MaryData process(MaryData d) throws Exception {
        List<Utterance> utterances = d.getUtterances();
        for (Utterance utterance : utterances) {
            this.processor.processUtterance(utterance);
        }
        MaryData output = new MaryData(this.outputType(), d.getLocale());
        output.setUtterances(utterances);
        return output;
    }
}

